/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.List;
import org.antublue.verifyica.api.Verifyica;
import org.antublue.verifyica.engine.support.ArgumentSupport;
import org.antublue.verifyica.engine.support.DisplayNameSupport;

public class OrderSupport {
    private OrderSupport() {
    }

    public static void orderClasses(List<Class<?>> classes) {
        ArgumentSupport.notNull(classes, "classes is null");
        classes.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        classes.sort(Comparator.comparingInt(OrderSupport::getOrder));
    }

    public static int getOrder(Class<?> clazz) {
        ArgumentSupport.notNull(clazz, "clazz is null");
        int order = Integer.MAX_VALUE;
        Verifyica.Order annotation = clazz.getAnnotation(Verifyica.Order.class);
        if (annotation != null) {
            order = annotation.order();
        }
        return order;
    }

    public static void orderMethods(List<Method> methods) {
        ArgumentSupport.notNull(methods, "methods is null");
        methods.sort(Comparator.comparing(DisplayNameSupport::getDisplayName));
        methods.sort(Comparator.comparingInt(OrderSupport::getOrder));
    }

    public static int getOrder(Method method) {
        ArgumentSupport.notNull(method, "method is null");
        int order = Integer.MAX_VALUE;
        Verifyica.Order annotation = method.getAnnotation(Verifyica.Order.class);
        if (annotation != null) {
            order = annotation.order();
        }
        return order;
    }
}

