/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.antublue.verifyica.api.Verifyica;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class TagSupport {
    private TagSupport() {
    }

    public static List<String> getTags(Class<?> clazz) {
        Verifyica.Tag[] tagAnnotations;
        ArgumentSupport.notNull(clazz, "clazz is null");
        HashSet<String> tags = new HashSet<String>();
        TagSupport.getTag(clazz).ifPresent(tags::add);
        Verifyica.Tags tagsAnnotation = clazz.getAnnotation(Verifyica.Tags.class);
        if (tagsAnnotation != null && (tagAnnotations = tagsAnnotation.value()) != null) {
            for (Verifyica.Tag tagAnnotation : tagAnnotations) {
                String tag = tagAnnotation.tag();
                if (tag == null || tag.trim().isEmpty()) continue;
                tags.add(tag.trim());
            }
        }
        return new ArrayList<String>(tags);
    }

    public static List<String> getTags(Method method) {
        Verifyica.Tag[] tagAnnotations;
        ArgumentSupport.notNull(method, "method is null");
        HashSet<String> tags = new HashSet<String>();
        TagSupport.getTag(method).ifPresent(tags::add);
        Verifyica.Tags tagsAnnotation = method.getAnnotation(Verifyica.Tags.class);
        if (tagsAnnotation != null && (tagAnnotations = tagsAnnotation.value()) != null) {
            for (Verifyica.Tag tagAnnotation : tagAnnotations) {
                String tag = tagAnnotation.tag();
                if (tag == null || tag.trim().isEmpty()) continue;
                tags.add(tag.trim());
            }
        }
        return new ArrayList<String>(tags);
    }

    private static Optional<String> getTag(Method method) {
        String tag;
        Verifyica.Tag annotation = method.getAnnotation(Verifyica.Tag.class);
        if (annotation != null && (tag = annotation.tag()) != null && !tag.trim().isEmpty()) {
            return Optional.of(tag.trim());
        }
        return Optional.empty();
    }

    private static Optional<String> getTag(Class<?> clazz) {
        String tag;
        Verifyica.Tag annotation = clazz.getAnnotation(Verifyica.Tag.class);
        if (annotation != null && (tag = annotation.tag()) != null && !tag.trim().isEmpty()) {
            return Optional.of(tag.trim());
        }
        return Optional.empty();
    }
}

