/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.engine.support;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import org.antublue.verifyica.engine.support.ArgumentSupport;

public class UrlSupport {
    private UrlSupport() {
    }

    public static InputStream createInputStream(URL url) throws IOException {
        ArgumentSupport.notNull(url, "url is null");
        URLConnection connection = url.openConnection();
        connection.connect();
        return connection.getInputStream();
    }

    public static BufferedReader createBufferedReader(URL url) throws IOException {
        ArgumentSupport.notNull(url, "url is null");
        return new BufferedReader(new InputStreamReader(UrlSupport.createInputStream(url), StandardCharsets.UTF_8));
    }
}

