/*
 * Decompiled with CFR 0.152.
 */
package org.antublue.verifyica.maven.plugin;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.StringJoiner;
import org.antublue.verifyica.api.Configuration;
import org.antublue.verifyica.engine.VerifyicaEngine;
import org.antublue.verifyica.engine.configuration.DefaultConfigurationParameters;
import org.antublue.verifyica.engine.context.DefaultEngineContext;
import org.antublue.verifyica.engine.descriptor.StatusEngineDescriptor;
import org.antublue.verifyica.engine.listener.ChainedEngineExecutionListener;
import org.antublue.verifyica.engine.listener.StatusEngineExecutionListener;
import org.antublue.verifyica.engine.listener.SummaryEngineExecutionListener;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.ExecutionRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;

@Mojo(name="test", threadSafe=true, requiresDependencyResolution=ResolutionScope.TEST)
public class VerifyicaMavenPlugin
extends AbstractMojo {
    private static final String MAVEN_PLUGIN_PROPERTIES_RESOURCE = "/maven-plugin.properties";
    private static final String MAVEN_PLUGIN_VERSION_KEY = "version";
    private static final String UNKNOWN_VERSION = "unknown";
    private static final String INTERACTIVE = "interactive";
    private static final String BATCH = "batch";
    private static final String GROUP_ID = "org.antublue.verifyica";
    private static final String ARTIFACT_ID = "maven-plugin";
    public static final String VERSION = VerifyicaMavenPlugin.version();
    @Parameter(defaultValue="${session}", required=true, readonly=true)
    private MavenSession mavenSession;
    @Parameter(property="project", required=true, readonly=true)
    private MavenProject mavenProject;
    @Parameter(property="properties")
    private Map<String, String> properties;

    public Optional<String> getVersion() {
        return Optional.of(VERSION);
    }

    public void execute() throws MojoFailureException, MojoExecutionException {
        Logger logger = Logger.from(this.getLog());
        try {
            List artifactList;
            Set artifactSet;
            Artifact artifact;
            Object path;
            Configuration configuration = DefaultEngineContext.getInstance().getConfiguration();
            configuration.put("verifyica.maven.plugin", "true");
            logger.debug("property [%s] = [%s]", "verifyica.maven.plugin", "true");
            configuration.put("verifyica.maven.plugin.version", VERSION);
            logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.version", VERSION);
            if (this.mavenSession.getRequest().isInteractiveMode()) {
                configuration.put("verifyica.maven.plugin.mode", INTERACTIVE);
                logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.mode", INTERACTIVE);
            } else {
                configuration.put("verifyica.maven.plugin.mode", BATCH);
                logger.debug("property [%s] = [%s]", "verifyica.maven.plugin.mode", BATCH);
            }
            if (this.properties != null) {
                for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                    if (entry.getKey() == null || entry.getValue() == null) continue;
                    System.setProperty(entry.getKey(), entry.getValue());
                    logger.debug("property [%s] = [%s]", entry.getKey(), entry.getValue());
                }
            }
            LinkedHashSet<Object> artifactPaths = new LinkedHashSet<Object>();
            List classpathElements = this.mavenProject.getCompileClasspathElements();
            if (classpathElements != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getCompileClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getRuntimeClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((classpathElements = this.mavenProject.getTestClasspathElements()) != null) {
                for (String classpathElement : classpathElements) {
                    path = new File(classpathElement).toPath();
                    artifactPaths.add(path);
                    logger.debug("classpathElement [%s]", path);
                }
            }
            if ((artifact = this.mavenProject.getArtifact()) != null) {
                Path path2 = artifact.getFile().toPath();
                artifactPaths.add(path2);
                logger.debug("classpathElement [%s]", path2);
            }
            if ((artifactSet = this.mavenProject.getDependencyArtifacts()) != null) {
                for (Artifact a : artifactSet) {
                    Path path3 = a.getFile().toPath();
                    artifactPaths.add(path3);
                    logger.debug("classpathElement [%s]", path3);
                }
            }
            if ((artifactList = this.mavenProject.getAttachedArtifacts()) != null) {
                for (Artifact a : artifactList) {
                    Path path2 = a.getFile().toPath();
                    artifactPaths.add(path2);
                    logger.debug("classpathElement [%s]", path2);
                }
            }
            LinkedHashMap<String, URL> urls = new LinkedHashMap<String, URL>();
            for (Path path3 : artifactPaths) {
                URL url = path3.toUri().toURL();
                urls.putIfAbsent(url.getPath(), url);
            }
            System.setProperty("java.class.path", VerifyicaMavenPlugin.buildClasspath(urls.values()));
            URLClassLoader classLoader = new URLClassLoader(urls.values().toArray(new URL[0]), Thread.currentThread().getContextClassLoader());
            Thread.currentThread().setContextClassLoader(classLoader);
            ChainedEngineExecutionListener chainedEngineExecutionListener = new ChainedEngineExecutionListener(new EngineExecutionListener[]{new StatusEngineExecutionListener(), new SummaryEngineExecutionListener()});
            LauncherDiscoveryRequest launcherDiscoveryRequest = LauncherDiscoveryRequestBuilder.request().selectors(DiscoverySelectors.selectClasspathRoots(artifactPaths)).filters(new Filter[]{ClassNameFilter.includeClassNamePatterns((String[])new String[]{".*"})}).configurationParameters(Collections.emptyMap()).build();
            VerifyicaEngine engine = new VerifyicaEngine();
            TestDescriptor testDescriptor = engine.discover((EngineDiscoveryRequest)launcherDiscoveryRequest, UniqueId.forEngine((String)engine.getId()));
            ExecutionRequest executionRequest = new ExecutionRequest(testDescriptor, (EngineExecutionListener)chainedEngineExecutionListener, (ConfigurationParameters)new DefaultConfigurationParameters(DefaultEngineContext.getInstance().getConfiguration()));
            engine.execute(executionRequest);
            if (((StatusEngineDescriptor)testDescriptor).hasFailures()) {
                throw new MojoFailureException("");
            }
        }
        catch (MojoFailureException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new MojoExecutionException(t);
        }
    }

    private static String buildClasspath(Collection<URL> urls) {
        StringJoiner stringJoiner = new StringJoiner(File.pathSeparator);
        for (URL url : urls) {
            stringJoiner.add(url.getPath());
        }
        return stringJoiner.toString();
    }

    private static String version() {
        String value = UNKNOWN_VERSION;
        try (InputStream inputStream = VerifyicaMavenPlugin.class.getResourceAsStream(MAVEN_PLUGIN_PROPERTIES_RESOURCE);){
            if (inputStream != null) {
                Properties properties = new Properties();
                properties.load(inputStream);
                value = properties.getProperty(MAVEN_PLUGIN_VERSION_KEY).trim();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return value;
    }

    private static class Logger {
        private final Log log;

        private Logger(Log log) {
            this.log = log;
        }

        public void debug(String format, Object ... objects) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((CharSequence)String.format(format, objects));
            }
        }

        public static Logger from(Log log) {
            return new Logger(log);
        }
    }
}

