/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.datasource;

import java.sql.Connection;
import java.sql.Driver;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.annotation.Component;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.datasource.DataSourceHolder;
import org.anyline.data.datasource.DataSourceKeyMap;
import org.anyline.data.datasource.init.AbstractDataSourceHolder;
import org.anyline.data.jdbc.runtime.JDBCRuntimeHolder;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.transaction.init.DefaultTransactionManage;
import org.anyline.data.util.DataSourceUtil;
import org.anyline.metadata.type.Convert;
import org.anyline.metadata.type.ConvertException;
import org.anyline.metadata.type.DatabaseType;
import org.anyline.proxy.ConvertProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.datasource.loader.jdbc")
public class JDBCDataSourceHolder
extends AbstractDataSourceHolder
implements DataSourceHolder {
    private static final JDBCDataSourceHolder instance = new JDBCDataSourceHolder();

    public static JDBCDataSourceHolder instance() {
        return instance;
    }

    public JDBCDataSourceHolder() {
        for (DatabaseType type : DatabaseType.values()) {
            String url = type.url();
            if (!url.contains("jdbc:") || !url.contains("://")) continue;
            DataSourceHolder.register((Object)type, (DataSourceHolder)this);
            DataSourceHolder.register((Object)type.driver(), (DataSourceHolder)this);
            DataSourceHolder.register((Object)type.name().toUpperCase(), (DataSourceHolder)this);
            String[] chks = url.split("://");
            DataSourceHolder.register((Object)chks[0], (DataSourceHolder)this);
        }
        DataSourceHolder.register((Object)"com.alibaba.druid.pool.DruidDataSource", (DataSourceHolder)this);
        DataSourceHolder.register((Object)"com.zaxxer.hikari.HikariDataSource", (DataSourceHolder)this);
        DataSourceHolder.register(Connection.class, (DataSourceHolder)this);
        DataSourceHolder.register(DataSource.class, (DataSourceHolder)this);
    }

    public String reg(String key, String prefix) {
        try {
            String url;
            String type;
            if (BasicUtil.isNotEmpty((Object)prefix) && !prefix.endsWith(".")) {
                prefix = prefix + ".";
            }
            if (null == (type = (String)this.value(prefix, "type", String.class, null))) {
                type = (String)this.value(prefix.substring(0, prefix.length() - key.length() - 1), "type", String.class, null);
            }
            if (type == null) {
                type = "com.zaxxer.hikari.HikariDataSource";
            }
            if (BasicUtil.isEmpty((Object)(url = (String)this.value(prefix, "url", String.class, null)))) {
                return null;
            }
            if (!url.startsWith("jdbc:")) {
                return null;
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("type", type);
            String datasource = this.inject(key, prefix, map, true);
            if (null == datasource) {
                return null;
            }
            this.runtime(key, datasource, true);
            return datasource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String create(String key, DatabaseType database, String url, String user, String password) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("driverClass", database.driver());
        params.put("url", url);
        params.put("user", user);
        params.put("password", password);
        String ds = this.inject(key, params, true);
        return this.runtime(key, ds, false);
    }

    public String create(String key, String prefix) {
        return this.reg(key, prefix);
    }

    public DataSource create(String key, Connection connection, boolean override) {
        return null;
    }

    public boolean validate(DataRuntime runtime) throws Exception {
        return false;
    }

    public String regTransactionManager(String key, DataSource datasource, boolean primary) {
        if (ConfigTable.IS_OPEN_TRANSACTION_MANAGER) {
            TransactionManage.reg((String)key, (TransactionManage)new DefaultTransactionManage(datasource));
        }
        return key;
    }

    public String runtime(String key, String datasource, boolean override) throws Exception {
        if (null != datasource) {
            Map param;
            DataSourceHolder.check((String)key, (boolean)override);
            this.regTransactionManager(key, datasource);
            DataRuntime runtime = JDBCRuntimeHolder.instance().reg(key, datasource);
            if (null != runtime && null != (param = (Map)params.get(key))) {
                runtime.setDriver(param.get("driver") + "");
                String url = param.get("url") + "";
                runtime.setUrl(url);
                String adapter = param.get("adapter") + "";
                if (BasicUtil.isEmpty((Object)adapter)) {
                    adapter = DataSourceUtil.parseAdapterKey((String)url);
                }
                runtime.setAdapterKey(adapter);
                String catalog = param.get("catalog") + "";
                if (BasicUtil.isEmpty((Object)catalog)) {
                    catalog = DataSourceUtil.parseCatalog((String)url);
                }
                runtime.setCatalog(catalog);
                String schema = param.get("schema") + "";
                if (BasicUtil.isEmpty((Object)schema)) {
                    schema = DataSourceUtil.parseSchema((String)url);
                }
                runtime.setSchema(schema);
            }
        }
        return datasource;
    }

    public DataRuntime runtime(String key, Object datasource, String database, DatabaseType type, DriverAdapter adapter, boolean override) throws Exception {
        DataRuntime runtime = null;
        if (datasource instanceof DataSource) {
            if (null != ConfigTable.worker) {
                DataSourceHolder.check((String)key, (boolean)override);
                this.regTransactionManager(key, (DataSource)datasource);
                runtime = JDBCRuntimeHolder.instance().reg(key, (DataSource)datasource);
                if (null == adapter && null != type) {
                    adapter = DriverAdapterHolder.getAdapter((DatabaseType)type);
                }
                if (null != adapter) {
                    runtime.setAdapter(adapter);
                }
            } else if (!caches.containsKey(key) || override) {
                caches.put(key, (DataSource)datasource);
            }
        }
        return runtime;
    }

    public String inject(String key, Map params, boolean over) throws Exception {
        return this.inject(key, null, params, over);
    }

    public String inject(String key, String prefix, Map<String, Object> params, boolean override) throws Exception {
        DataSourceHolder.check((String)key, (boolean)override);
        String datasource_id = "anyline.datasource." + key;
        try {
            String url = (String)this.value(params, "url", String.class, null);
            if (BasicUtil.isEmpty((Object)url)) {
                url = (String)this.value(prefix, "url", String.class, null);
            }
            if (BasicUtil.isEmpty((Object)url)) {
                return null;
            }
            if (!url.toLowerCase().startsWith("jdbc:")) {
                return null;
            }
            params.put("url", url);
            String type = (String)this.value(params, "type", String.class, null);
            if (BasicUtil.isEmpty((Object)type)) {
                type = (String)this.value(prefix, "type", String.class, null);
            }
            if (type == null) {
                type = "com.zaxxer.hikari.HikariDataSource";
            }
            Class<?> poolClass = Class.forName(type);
            Object driver = JDBCDataSourceHolder.value(params, (String)"driverClass");
            if (null == driver) {
                driver = this.value(prefix, "driverClass");
            }
            if (driver instanceof String) {
                Class<?> calzz = Class.forName((String)driver);
                driver = calzz.newInstance();
            }
            if (null != driver) {
                params.put("driver", driver);
            }
            Map sets = ConfigTable.environment().inject(datasource_id, prefix, params, DataSourceKeyMap.maps, poolClass);
            if (!params.containsKey(key)) {
                params.put(key, sets);
            }
            log.info("[\u6ce8\u5165\u6570\u636e\u6e90][type:JDBC][key:{}][bean:{}]", (Object)key, (Object)datasource_id);
        }
        catch (Exception e) {
            log.error("[\u6ce8\u5165\u6570\u636e\u6e90\u5931\u8d25][type:JDBC][key:{}][msg:{}]", (Object)key, (Object)e.toString());
            e.printStackTrace();
            return null;
        }
        return datasource_id;
    }

    static {
        ConvertProxy.reg((Convert)new Convert(){

            public Class getOrigin() {
                return String.class;
            }

            public Class getTarget() {
                return Driver.class;
            }

            public Object exe(Object value, Object def) throws ConvertException {
                if (null != value) {
                    try {
                        return Class.forName(value.toString()).newInstance();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return null;
            }
        });
    }
}

