/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.adapter.init;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.anyline.adapter.EntityAdapter;
import org.anyline.annotation.Component;
import org.anyline.data.adapter.DriverActuator;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.datasource.ApplicationConnectionHolder;
import org.anyline.data.datasource.ThreadConnectionHolder;
import org.anyline.data.handler.ConnectionHandler;
import org.anyline.data.handler.DataHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.jdbc.adapter.JDBCAdapter;
import org.anyline.data.jdbc.handler.SimpleConnectionHandler;
import org.anyline.data.jdbc.util.JDBCUtil;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.PageNavi;
import org.anyline.log.Log;
import org.anyline.log.LogProxy;
import org.anyline.metadata.ACTION;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Index;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Parameter;
import org.anyline.metadata.Procedure;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.View;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ConfigTable;
import org.anyline.util.DateUtil;
import org.anyline.util.LogUtil;

@Component(value="anyline.environment.data.driver.actuator.jdbc")
public class DefaultJDBCActuator
implements DriverActuator {
    private Log log = LogProxy.get(DefaultJDBCActuator.class);

    public Class<? extends DriverAdapter> supportAdapterType() {
        return JDBCAdapter.class;
    }

    public DataSource getDataSource(DriverAdapter adapter, DataRuntime runtime) {
        DataSource datasource = this.datasource(runtime);
        return datasource;
    }

    public Connection getConnection(DriverAdapter adapter, DataRuntime runtime, DataSource datasource) {
        Connection con = null;
        try {
            con = ThreadConnectionHolder.get((DataSource)datasource);
            if (null == con) {
                con = datasource.getConnection();
            }
        }
        catch (Exception e) {
            this.log.error("\u8fde\u63a5 \u5f02\u5e38:", (Throwable)e);
        }
        return con;
    }

    public void releaseConnection(DriverAdapter adapter, DataRuntime runtime, Connection connection, DataSource datasource) {
        try {
            if (ThreadConnectionHolder.contains((DataSource)datasource, (Connection)connection) || ApplicationConnectionHolder.contains((DataSource)datasource, (Connection)connection)) {
                return;
            }
            connection.close();
        }
        catch (SQLException e) {
            this.log.error("\u91ca\u653e\u8fde\u63a5 \u5f02\u5e38:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, DataSource ds, T meta) {
        String schema;
        if (null == meta || null != meta.getCheckSchemaTime()) {
            return;
        }
        String catalog = meta.getCatalogName();
        if (null == catalog) {
            catalog = runtime.getCatalog();
        }
        if (null == (schema = meta.getSchemaName())) {
            schema = runtime.getSchema();
        }
        if (null == catalog && null == schema) {
            Connection con = null;
            try {
                if (adapter.empty((Metadata)meta.getCatalog()) || adapter.empty((Metadata)meta.getSchema())) {
                    con = this.getConnection(adapter, runtime, ds);
                    this.checkSchema(adapter, runtime, con, meta);
                }
                this.releaseConnection(adapter, runtime, con, ds);
            }
            catch (Exception e) {
                try {
                    this.log.warn("[check schema][fail:{}]", (Object)e.toString());
                    this.releaseConnection(adapter, runtime, con, ds);
                }
                catch (Throwable throwable) {
                    this.releaseConnection(adapter, runtime, con, ds);
                    throw throwable;
                }
            }
        } else {
            meta.setCatalog(catalog);
            meta.setSchema(schema);
        }
    }

    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, T meta) {
        if (null != meta) {
            String schema;
            String catalog = meta.getCatalogName();
            if (null == catalog) {
                catalog = runtime.getCatalog();
            }
            if (null == (schema = meta.getSchemaName())) {
                schema = runtime.getSchema();
            }
            if (null == catalog && null == schema) {
                this.checkSchema(adapter, runtime, this.datasource(runtime), meta);
            } else {
                meta.setCatalog(catalog);
                meta.setSchema(schema);
            }
        }
    }

    public <T extends Metadata> void checkSchema(DriverAdapter adapter, DataRuntime runtime, Connection con, T meta) {
        String schema;
        if (null == meta) {
            return;
        }
        String catalog = meta.getCatalogName();
        if (null == catalog) {
            catalog = runtime.getCatalog();
        }
        if (null == (schema = meta.getSchemaName())) {
            schema = runtime.getSchema();
        }
        if (null == catalog && null == schema) {
            try {
                if (adapter.empty((Metadata)meta.getCatalog())) {
                    catalog = con.getCatalog();
                }
            }
            catch (Exception e) {
                this.log.warn("[check catalog][result:fail][exception:{}]", (Object)e.toString());
            }
            try {
                if (adapter.empty((Metadata)meta.getSchema())) {
                    schema = con.getSchema();
                }
            }
            catch (Exception e) {
                this.log.warn("[check schema][result:fail][exception:{}]", (Object)e.toString());
            }
            adapter.correctSchemaFromJDBC(runtime, meta, catalog, schema, true, true);
            meta.setCheckSchemaTime(new Date());
        } else {
            meta.setCatalog(catalog);
            meta.setSchema(schema);
        }
    }

    private DataSource datasource(DataRuntime runtime) {
        return (DataSource)runtime.getProcessor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataSet select(DriverAdapter adapter, DataRuntime runtime, String random, boolean system, ACTION.DML action, Table table, ConfigStore configs, Run run, String sql, List<Object> values, LinkedHashMap<String, Column> columns) throws Exception {
        boolean[] process;
        long[] mid;
        long fr;
        DataSet set;
        block17: {
            DataHandler handler;
            set = new DataSet();
            fr = System.currentTimeMillis();
            DataRuntime rt = runtime;
            mid = new long[]{System.currentTimeMillis()};
            process = new boolean[]{false};
            LinkedHashMap<String, Column> metadatas = new LinkedHashMap<String, Column>();
            if (null != columns) {
                metadatas.putAll(columns);
            }
            set.setMetadata(metadatas);
            DataSource datasource = this.datasource(runtime);
            if (null == datasource) {
                return set;
            }
            DataHandler _handler = null;
            if (null != configs && (handler = configs.handler()) instanceof StreamHandler) {
                _handler = (StreamHandler)handler;
            }
            handler = _handler;
            Connection con = this.getConnection(adapter, runtime, datasource);
            PreparedStatement ps = null;
            ResultSet rs = null;
            long[] count = new long[]{0L};
            boolean keep = false;
            try {
                ps = con.prepareStatement(sql, 1003, 1007);
                if (null != handler) {
                    keep = handler.keep();
                    ps.setFetchSize(handler.size());
                }
                ps.setFetchDirection(1000);
                JDBCUtil.queryTimeout(ps, configs);
                if (null != values && !values.isEmpty()) {
                    int idx = 0;
                    for (Object value : values) {
                        ps.setObject(++idx, value);
                    }
                }
                rs = ps.executeQuery();
                if (null != handler) {
                    if (keep && handler instanceof ResultSetHandler) {
                        SimpleConnectionHandler ch = new SimpleConnectionHandler(datasource, con, ps, rs);
                        ch.setActuator(this);
                        handler.handler((ConnectionHandler)ch);
                        ((ResultSetHandler)handler).read(rs);
                        break block17;
                    }
                    while (rs.next()) {
                        count[0] = count[0] + 1L;
                        boolean next = JDBCUtil.stream(adapter, (StreamHandler)handler, rs, configs, true, runtime, null);
                        if (next) continue;
                        break block17;
                    }
                    break block17;
                }
                while (rs.next()) {
                    count[0] = count[0] + 1L;
                    DataRow row = JDBCUtil.row(adapter, system, rt, metadatas, configs, rs);
                    set.add(row);
                }
            }
            finally {
                if (!keep) {
                    if (null != rs && !rs.isClosed()) {
                        rs.close();
                    }
                    if (null != ps && !ps.isClosed()) {
                        ps.close();
                    }
                    this.releaseConnection(adapter, runtime, con, datasource);
                }
            }
        }
        if (!process[0]) {
            mid[0] = System.currentTimeMillis();
        }
        configs.setLastPackageTime(System.currentTimeMillis() - mid[0]);
        configs.setLastExecuteTime(mid[0] - fr);
        return set;
    }

    public DataSet querys(DriverAdapter adapter, DataRuntime runtime, String random, Procedure procedure, PageNavi navi) throws Exception {
        Parameter param;
        int i;
        List inputs = procedure.getInputs();
        List outputs = procedure.getOutputs();
        String rdm = random;
        DataRuntime rt = runtime;
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return new DataSet();
        }
        Connection conn = this.getConnection(adapter, runtime, datasource);
        String sql = "{call " + procedure.getName() + "(";
        int sizeIn = inputs.size();
        int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        for (int i2 = 0; i2 < size; ++i2) {
            sql = sql + "?";
            if (i2 >= size - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")}";
        CallableStatement cs = conn.prepareCall(sql);
        for (i = 1; i <= sizeIn; ++i) {
            param = (Parameter)inputs.get(i - 1);
            Object value = param.getValue();
            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                value = null;
            }
            cs.setObject(i, value, (int)param.getType());
        }
        for (i = 1; i <= sizeOut; ++i) {
            param = (Parameter)outputs.get(i - 1);
            if (null == param.getValue()) {
                cs.registerOutParameter(i + sizeIn, (int)param.getType());
                continue;
            }
            cs.setObject(i, param.getValue(), (int)param.getType());
        }
        JDBCUtil.queryTimeout(cs, null);
        ResultSet rs = cs.executeQuery();
        DataSet set = new DataSet();
        ResultSetMetaData rsmd = rs.getMetaData();
        int cols = rsmd.getColumnCount();
        for (int i3 = 1; i3 <= cols; ++i3) {
            String name = rsmd.getColumnLabel(i3);
            if (null == name) {
                name = rsmd.getColumnName(i3);
            }
            set.addHead(name);
        }
        long mid = System.currentTimeMillis();
        int index = 0;
        long first = -1L;
        long last = -1L;
        if (null != navi) {
            first = navi.getFirstRow();
            last = navi.getLastRow();
        }
        while (rs.next()) {
            if (first == -1L || (long)index >= first && (long)index <= last) {
                DataRow row = new DataRow();
                for (int i4 = 1; i4 <= cols; ++i4) {
                    row.put(false, rsmd.getColumnLabel(i4), rs.getObject(i4));
                }
                set.addRow(row);
            }
            if (first == -1L || (long)(++index) <= last && (first != 0L || last != 0L)) continue;
        }
        if (null != navi) {
            navi.setTotalRow((long)index);
            set.setNavi(navi);
            navi.setDataSize(set.size());
        }
        set.setDatalink(rt.datasource());
        if (ConfigTable.IS_LOG_SQL_TIME && this.log.isInfoEnabled()) {
            this.log.info("{}[\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{rdm, DateUtil.format((long)(System.currentTimeMillis() - mid)), set.size()});
        }
        if (ConfigTable.IS_LOG_QUERY_RESULT && this.log.isInfoEnabled()) {
            this.log.info("{}[\u67e5\u8be2\u7ed3\u679c]{}", (Object)random, (Object)LogUtil.table((DataSet)set));
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> maps(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        long[] mid;
        long fr;
        long[] count;
        List values;
        String sql;
        ArrayList<Map<String, Object>> maps;
        block19: {
            DataHandler handler;
            maps = new ArrayList<Map<String, Object>>();
            sql = run.getFinalQuery();
            values = run.getValues();
            DataSource datasource = this.datasource(runtime);
            if (null == datasource) {
                return maps;
            }
            StreamHandler _handler = null;
            if (null != configs && (handler = configs.handler()) instanceof StreamHandler) {
                _handler = (StreamHandler)handler;
            }
            Connection con = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            count = new long[]{0L};
            boolean[] process = new boolean[]{false};
            StreamHandler handler2 = _handler;
            fr = System.currentTimeMillis();
            mid = new long[]{System.currentTimeMillis()};
            boolean keep = false;
            if (null != handler2) {
                keep = handler2.keep();
            }
            try {
                con = this.getConnection(adapter, runtime, datasource);
                ps = con.prepareStatement(sql, 1003, 1007);
                if (null != handler2) {
                    ps.setFetchSize(handler2.size());
                }
                ps.setFetchDirection(1000);
                JDBCUtil.queryTimeout(ps, configs);
                if (null != values && !values.isEmpty()) {
                    int idx = 0;
                    for (Object value : values) {
                        ps.setObject(++idx, value);
                    }
                }
                rs = ps.executeQuery();
                if (null != handler2) {
                    if (keep && handler2 instanceof ResultSetHandler) {
                        SimpleConnectionHandler ch = new SimpleConnectionHandler(datasource, con, ps, rs);
                        ch.setActuator(this);
                        handler2.handler((ConnectionHandler)ch);
                        ((ResultSetHandler)handler2).read(rs);
                        break block19;
                    }
                    while (rs.next()) {
                        count[0] = count[0] + 1L;
                        boolean next = JDBCUtil.stream(adapter, handler2, rs, configs, true, runtime, null);
                        if (next) continue;
                        break block19;
                    }
                    break block19;
                }
                while (rs.next()) {
                    count[0] = count[0] + 1L;
                    LinkedHashMap<String, Object> map = JDBCUtil.map(adapter, false, runtime, null, configs, rs);
                    maps.add(map);
                }
            }
            finally {
                if (!keep) {
                    if (null != rs && !rs.isClosed()) {
                        rs.close();
                    }
                    this.releaseConnection(adapter, runtime, con, datasource);
                }
            }
        }
        mid[0] = System.currentTimeMillis();
        count[0] = maps.size();
        boolean slow = false;
        if (ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs) > 0L && mid[0] - fr > ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs)) {
            slow = true;
            this.log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, DateUtil.format((long)(mid[0] - fr)), run.log(ACTION.DML.SELECT, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)))});
            if (null != adapter.getDMListener()) {
                adapter.getDMListener().slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, maps, mid[0] - fr);
            }
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}]", (Object)random, (Object)DateUtil.format((long)(mid[0] - fr)));
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((long)(System.currentTimeMillis() - mid[0])), count[0]});
        }
        return maps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Object> map(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        LinkedHashMap<String, Object> map = null;
        String sql = run.getFinalExists();
        List values = run.getValues();
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return new HashMap<String, Object>();
        }
        Connection con = null;
        Statement ps = null;
        ResultSet rs = null;
        long fr = System.currentTimeMillis();
        try {
            con = this.getConnection(adapter, runtime, datasource);
            ps = con.prepareStatement(sql, 1003, 1007);
            ps.setFetchDirection(1000);
            JDBCUtil.queryTimeout(ps, configs);
            if (null != values && !values.isEmpty()) {
                int idx = 0;
                for (Object value : values) {
                    ps.setObject(++idx, value);
                }
            }
            if ((rs = ps.executeQuery()).next()) {
                map = JDBCUtil.map(adapter, false, runtime, null, configs, rs);
            }
        }
        finally {
            if (null != rs && !rs.isClosed()) {
                rs.close();
            }
            if (null != ps && !ps.isClosed()) {
                ps.close();
            }
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        long time = System.currentTimeMillis() - fr;
        fr = System.currentTimeMillis();
        boolean slow = false;
        if (ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs) > 0L && time > ConfigStore.SLOW_SQL_MILLIS((ConfigStore)configs)) {
            slow = true;
            this.log.warn("{}[slow cmd][action:select][\u6267\u884c\u8017\u65f6:{}]{}", new Object[]{random, DateUtil.format((long)time), run.log(ACTION.DML.SELECT, Boolean.valueOf(ConfigStore.IS_SQL_LOG_PLACEHOLDER((ConfigStore)configs)))});
            if (null != adapter.getDMListener()) {
                adapter.getDMListener().slow(runtime, random, ACTION.DML.SELECT, null, sql, values, null, true, map, time);
            }
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u6267\u884c\u8017\u65f6:{}]", (Object)random, (Object)DateUtil.format((long)time));
        }
        if (!slow && this.log.isInfoEnabled() && ConfigStore.IS_LOG_SQL_TIME((ConfigStore)configs)) {
            this.log.info("{}[action:select][\u5c01\u88c5\u8017\u65f6:{}][\u5c01\u88c5\u884c\u6570:{}]", new Object[]{random, DateUtil.format((long)(System.currentTimeMillis() - fr)), 1});
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long insert(DriverAdapter adapter, DataRuntime runtime, String random, Object data, ConfigStore configs, Run run, String generatedKey, String[] pks) throws Exception {
        long cnt = -1L;
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return -1L;
        }
        Connection con = this.getConnection(adapter, runtime, datasource);
        String cmd = run.getFinalInsert();
        int batch = run.getBatch();
        List values = run.getValues();
        if (batch > 1) {
            cnt = this.batch(adapter, runtime, datasource, cmd, batch, run.getVol(), (List<Object>)values);
        } else {
            boolean keyHolder = adapter.supportKeyHolder(runtime, configs);
            if (data instanceof RunPrepare) {
                keyHolder = false;
            }
            PreparedStatement ps = null;
            ps = keyHolder ? (null != pks && pks.length > 0 ? con.prepareStatement(cmd, pks) : con.prepareStatement(cmd, 1)) : con.prepareStatement(cmd);
            int idx = 0;
            if (null != values) {
                for (Object obj : values) {
                    ps.setObject(++idx, obj);
                }
            }
            JDBCUtil.updateTimeout(ps, configs);
            cnt = ps.executeUpdate();
            if (keyHolder) {
                try (ResultSet rs = ps.getGeneratedKeys();){
                    this.identity(adapter, runtime, random, data, configs, rs, generatedKey);
                }
            }
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        return cnt;
    }

    /*
     * WARNING - void declaration
     */
    public boolean identity(DriverAdapter adapter, DataRuntime runtime, String random, Object data, ConfigStore configs, ResultSet rs, String generatedKey) {
        block20: {
            try {
                if (null == rs) {
                    return false;
                }
                if (!adapter.supportKeyHolder(runtime, configs)) {
                    return false;
                }
                Map<String, Integer> ks = JDBCUtil.keys(rs);
                ArrayList pvs = new ArrayList();
                while (rs.next()) {
                    HashMap<String, Object> pv = new HashMap<String, Object>();
                    for (String string : ks.keySet()) {
                        Integer idx = ks.get(string);
                        pv.put(string, rs.getObject(idx));
                    }
                    pvs.add(pv);
                }
                if (null == generatedKey && !pvs.isEmpty()) {
                    Map key = (Map)pvs.get(0);
                    generatedKey = (String)key.keySet().iterator().next();
                }
                if (data instanceof Collection) {
                    Long num;
                    Object last;
                    Object item;
                    ArrayList ids = new ArrayList();
                    Collection list = (Collection)data;
                    Iterator iterator = list.iterator();
                    if (iterator.hasNext() && BasicUtil.isNotEmpty((boolean)true, (Object)EntityAdapter.getPrimaryValue(item = iterator.next()))) {
                        return true;
                    }
                    if (BasicUtil.isEmpty((Object)generatedKey)) {
                        return false;
                    }
                    boolean bl = false;
                    int data_size = list.size();
                    if (list.size() == pvs.size()) {
                        for (Object item2 : list) {
                            void var12_16;
                            Map key = (Map)pvs.get((int)var12_16);
                            Object id = key.get(generatedKey);
                            ids.add(id);
                            EntityAdapter.setPrimaryValue(item2, id);
                            ++var12_16;
                        }
                    } else if (!pvs.isEmpty() && (last = ((Map)pvs.get(0)).get(generatedKey)) instanceof Number && null != (num = BasicUtil.parseLong((Object)last.toString(), null))) {
                        num = num - (long)data_size + 1L;
                        for (Object item3 : list) {
                            Long l = num;
                            Long l2 = num = Long.valueOf(num + 1L);
                            EntityAdapter.setPrimaryValue(item3, (Object)l);
                        }
                    }
                    if (ConfigStore.IS_LOG_SQL((ConfigStore)configs) && this.log.isWarnEnabled()) {
                        this.log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, ids);
                    }
                    break block20;
                }
                if (!pvs.isEmpty() && BasicUtil.isEmpty((boolean)true, (Object)EntityAdapter.getPrimaryValue((Object)data))) {
                    Object id = ((Map)pvs.get(0)).get(generatedKey);
                    EntityAdapter.setPrimaryValue((Object)data, id);
                    if (ConfigStore.IS_LOG_SQL((ConfigStore)configs) && this.log.isWarnEnabled()) {
                        this.log.info("{}[exe insert][\u751f\u6210\u4e3b\u952e:{}]", (Object)random, id);
                    }
                }
            }
            catch (Exception e) {
                if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                    this.log.error("identity \u5f02\u5e38:", (Throwable)e);
                }
                if (ConfigStore.IS_LOG_SQL_WHEN_ERROR((ConfigStore)configs)) {
                    this.log.warn("{}[exe insert][\u8fd4\u56de\u4e3b\u952e\u5931\u8d25]", (Object)random);
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long batch(DriverAdapter adapter, DataRuntime runtime, DataSource datasource, String sql, int batch, int vol, List<Object> values) {
        int size = values.size();
        int line = size / vol;
        if (null == datasource) {
            return line;
        }
        Connection con = this.getConnection(adapter, runtime, datasource);
        try {
            this.batch(adapter, runtime, con, sql, batch, vol, values);
        }
        catch (Exception e) {
            this.log.error("sql\u5f02\u5e38", (Throwable)e);
        }
        finally {
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        return line;
    }

    public long batch(DriverAdapter adapter, DataRuntime runtime, Connection con, String sql, int batch, int vol, List<Object> values) throws Exception {
        int size = values.size();
        int line = size / vol;
        PreparedStatement ps = null;
        con.setAutoCommit(false);
        ps = con.prepareStatement(sql);
        for (int r = 1; r <= line; ++r) {
            for (int c = 1; c <= vol; ++c) {
                ps.setObject(c, values.get(vol * r + c - 1));
            }
            ps.addBatch();
            if (r % batch != 0) continue;
            ps.executeBatch();
            ps.clearBatch();
        }
        con.commit();
        return line;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long update(DriverAdapter adapter, DataRuntime runtime, String random, Table dest, Object data, ConfigStore configs, Run run) throws Exception {
        long result = 0L;
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return -1L;
        }
        String cmd = run.getFinalUpdate();
        List values = run.getValues();
        int batch = run.getBatch();
        if (batch > 1) {
            result = this.batch(adapter, runtime, datasource, cmd, batch, run.getVol(), (List<Object>)values);
        } else {
            Connection con = this.getConnection(adapter, runtime, datasource);
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(cmd);
                int idx = 0;
                if (null != values) {
                    for (Object obj : values) {
                        ps.setObject(++idx, obj);
                    }
                }
                result = ps.executeUpdate();
            }
            finally {
                this.releaseConnection(adapter, runtime, con, datasource);
            }
        }
        return result;
    }

    public List<Object> execute(DriverAdapter adapter, DataRuntime runtime, String random, Procedure procedure, String sql, List<Parameter> inputs, List<Parameter> outputs) throws Exception {
        Parameter param;
        int i;
        ArrayList<Object> list = new ArrayList<Object>();
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return list;
        }
        Connection con = this.getConnection(adapter, runtime, datasource);
        int sizeIn = inputs.size();
        int sizeOut = outputs.size();
        int size = sizeIn + sizeOut;
        CallableStatement cs = con.prepareCall(sql);
        int returnIndex = 0;
        if (procedure.hasReturn()) {
            returnIndex = 1;
            cs.registerOutParameter(1, 12);
        }
        for (i = 1; i <= sizeIn; ++i) {
            param = inputs.get(i - 1);
            Object value = param.getValue();
            if (null == value || "NULL".equalsIgnoreCase(value.toString())) {
                value = null;
            }
            cs.setObject(i + returnIndex, value, (int)param.getType());
        }
        for (i = 1; i <= sizeOut; ++i) {
            param = outputs.get(i - 1);
            if (null == param.getValue()) {
                cs.registerOutParameter(i + sizeIn + returnIndex, (int)param.getType());
                continue;
            }
            cs.setObject(i + sizeIn + returnIndex, param.getValue(), (int)param.getType());
        }
        cs.execute();
        if (procedure.hasReturn()) {
            list.add(cs.getObject(1));
        }
        if (sizeOut > 0) {
            for (i = 1; i <= sizeOut; ++i) {
                Object output = cs.getObject(sizeIn + returnIndex + i);
                list.add(output);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, Run run) throws Exception {
        long result = -1L;
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return -1L;
        }
        int batch = run.getBatch();
        String sql = run.getFinalExecute();
        List values = run.getValues();
        if (batch > 1) {
            result = this.batch(adapter, runtime, datasource, sql, batch, run.getVol(), (List<Object>)values);
        } else {
            Connection con = this.getConnection(adapter, runtime, datasource);
            PreparedStatement ps = null;
            try {
                ps = con.prepareStatement(sql);
                int idx = 0;
                if (null != values) {
                    for (Object obj : values) {
                        ps.setObject(++idx, obj);
                    }
                }
                result = ps.executeUpdate();
            }
            finally {
                this.releaseConnection(adapter, runtime, con, datasource);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long execute(DriverAdapter adapter, DataRuntime runtime, String random, ConfigStore configs, List<Run> runs) throws Exception {
        long result = -1L;
        DataSource datasource = this.datasource(runtime);
        if (null == datasource) {
            return -1L;
        }
        Connection con = this.getConnection(adapter, runtime, datasource);
        try {
            for (Run run : runs) {
                int batch = run.getBatch();
                String sql = run.getFinalExecute();
                List values = run.getValues();
                if (batch > 1) {
                    result = this.batch(adapter, runtime, con, sql, batch, run.getVol(), (List<Object>)values);
                    continue;
                }
                PreparedStatement ps = con.prepareStatement(sql);
                int idx = 0;
                if (null != values) {
                    for (Object obj : values) {
                        ps.setObject(++idx, obj);
                    }
                }
                result = ps.executeUpdate();
            }
        }
        finally {
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, Column> metadata(DriverAdapter adapter, DataRuntime runtime, String random, Run run, boolean comment) {
        LinkedHashMap<String, Column> columns = null;
        DataSource datasource = this.datasource(runtime);
        String sql = run.getFinalQuery(Boolean.valueOf(false));
        if (ConfigTable.IS_LOG_SQL && this.log.isInfoEnabled()) {
            this.log.info("{}[action:metadata][cmd:\n{}\n]", (Object)random, (Object)sql);
        }
        if (null == datasource) {
            return new LinkedHashMap<String, Column>();
        }
        Connection con = this.getConnection(adapter, runtime, datasource);
        PreparedStatement ps = null;
        try {
            ps = con.prepareStatement(sql);
            ResultSet rs = ps.executeQuery();
        }
        catch (Exception e) {
            this.log.error("metadata \u5f02\u5e38:", (Throwable)e);
        }
        finally {
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String product(DriverAdapter adapter, DataRuntime runtime, boolean create, String product) {
        Connection con;
        DataSource datasource;
        block5: {
            datasource = null;
            con = null;
            datasource = this.datasource(runtime);
            if (null != datasource) break block5;
            String string = null;
            this.releaseConnection(adapter, runtime, con, datasource);
            return string;
        }
        try {
            con = this.getConnection(adapter, runtime, datasource);
            product = con.getMetaData().getDatabaseProductName();
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        catch (Exception e) {
            try {
                this.log.warn("[check product][fail:{}]", (Object)e.toString());
                this.releaseConnection(adapter, runtime, con, datasource);
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, datasource);
                throw throwable;
            }
        }
        return product;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String version(DriverAdapter adapter, DataRuntime runtime, boolean create, String version) {
        DataSource datasource;
        Connection con;
        block5: {
            con = null;
            datasource = null;
            datasource = this.datasource(runtime);
            if (null != datasource) break block5;
            String string = null;
            this.releaseConnection(adapter, runtime, con, datasource);
            return string;
        }
        try {
            con = this.getConnection(adapter, runtime, datasource);
            version = con.getMetaData().getDatabaseProductVersion();
            this.releaseConnection(adapter, runtime, con, datasource);
        }
        catch (Exception e) {
            try {
                this.log.warn("[check version][fail:{}]", (Object)e.toString());
                this.releaseConnection(adapter, runtime, con, datasource);
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, datasource);
                throw throwable;
            }
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> LinkedHashMap<String, T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table query, int types) throws Exception {
        Connection con;
        DataSource datasource;
        String pattern;
        Schema schema;
        Catalog catalog;
        block5: {
            catalog = query.getCatalog();
            schema = query.getSchema();
            pattern = query.getName();
            datasource = null;
            con = null;
            try {
                datasource = this.datasource(runtime);
                if (null != datasource) break block5;
                LinkedHashMap<String, T> linkedHashMap = null;
                this.releaseConnection(adapter, runtime, con, datasource);
                return linkedHashMap;
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, datasource);
                throw throwable;
            }
        }
        con = this.getConnection(adapter, runtime, datasource);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        String[] tps = (String[])BeanUtil.list2array((List)adapter.names(Table.types((int)types)));
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, tps);
        previous = JDBCUtil.tables(adapter, runtime, create, previous, set);
        this.releaseConnection(adapter, runtime, con, datasource);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Table> List<T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> previous, Table query, int types) throws Exception {
        Connection con;
        DataSource datasource;
        String pattern;
        Schema schema;
        Catalog catalog;
        block5: {
            catalog = query.getCatalog();
            schema = query.getSchema();
            pattern = query.getName();
            datasource = null;
            con = null;
            try {
                datasource = this.datasource(runtime);
                if (null != datasource) break block5;
                List<T> list = null;
                this.releaseConnection(adapter, runtime, con, datasource);
                return list;
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, datasource);
                throw throwable;
            }
        }
        con = this.getConnection(adapter, runtime, datasource);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        String[] tps = (String[])BeanUtil.list2array((List)adapter.names(Table.types((int)types)));
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, tps);
        previous = JDBCUtil.tables(adapter, runtime, create, previous, set);
        this.releaseConnection(adapter, runtime, con, datasource);
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends View> LinkedHashMap<String, T> views(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, View query, int types) throws Exception {
        Connection con;
        DataSource datasource;
        String pattern;
        Schema schema;
        Catalog catalog;
        block5: {
            catalog = query.getCatalog();
            schema = query.getSchema();
            pattern = query.getName();
            datasource = null;
            con = null;
            try {
                datasource = this.datasource(runtime);
                if (null != datasource) break block5;
                LinkedHashMap<String, T> linkedHashMap = null;
                this.releaseConnection(adapter, runtime, con, datasource);
                return linkedHashMap;
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, datasource);
                throw throwable;
            }
        }
        con = this.getConnection(adapter, runtime, datasource);
        DatabaseMetaData dbmd = con.getMetaData();
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        String[] tmp = adapter.correctSchemaFromJDBC(catalogName, schemaName);
        ResultSet set = dbmd.getTables(tmp[0], tmp[1], pattern, new String[]{"VIEW"});
        previous = JDBCUtil.views(adapter, runtime, create, previous, set);
        this.releaseConnection(adapter, runtime, con, datasource);
        return previous;
    }

    public <T extends Table> List<T> views(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> previous, View query, int types) throws Exception {
        return previous;
    }

    public <T extends Column> LinkedHashMap<String, T> columns(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> previous, Table table, String sql) throws Exception {
        return previous;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Column> LinkedHashMap<String, T> metadata(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, Column query) throws Exception {
        Table table = query.getTable();
        String pattern = query.getName();
        DataSource ds = null;
        Connection con = null;
        DatabaseMetaData metadata = null;
        try {
            ds = this.datasource(runtime);
            con = this.getConnection(adapter, runtime, ds);
            metadata = con.getMetaData();
            columns = JDBCUtil.metadata(adapter, runtime, true, columns, metadata, table, pattern);
            this.releaseConnection(adapter, runtime, con, ds);
        }
        catch (Exception e) {
            try {
                if (ConfigTable.IS_PRINT_EXCEPTION_STACK_TRACE) {
                    this.log.error("metadata \u5f02\u5e38:", (Throwable)e);
                }
                this.releaseConnection(adapter, runtime, con, ds);
            }
            catch (Throwable throwable) {
                this.releaseConnection(adapter, runtime, con, ds);
                throw throwable;
            }
        }
        return columns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Index> LinkedHashMap<String, T> indexes(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> indexes, Index query) throws Exception {
        Table table = query.getTable();
        boolean unique = query.isUnique();
        boolean approximate = query.isApproximate();
        DataSource ds = null;
        Connection con = null;
        if (null == indexes) {
            indexes = new LinkedHashMap();
        }
        ds = this.datasource(runtime);
        try {
            con = this.getConnection(adapter, runtime, ds);
            DatabaseMetaData dbmd = con.getMetaData();
            adapter.checkName(runtime, null, (Metadata)table);
            String[] tmp = adapter.correctSchemaFromJDBC(table.getCatalogName(), table.getSchemaName());
            ResultSet set = dbmd.getIndexInfo(tmp[0], tmp[1], table.getName(), unique, approximate);
            Map<String, Integer> keys = JDBCUtil.keys(set);
            LinkedHashMap<String, Column> columns = null;
            while (set.next()) {
                String name = JDBCUtil.string(keys, "INDEX_NAME", set);
                if (null == name) continue;
                Index index = (Index)indexes.get(name.toUpperCase());
                if (null == index) {
                    if (!create) continue;
                    index = new Index();
                    indexes.put(name.toUpperCase(), index);
                    index.setName(JDBCUtil.string(keys, "INDEX_NAME", set));
                    index.setUnique(JDBCUtil.bool(keys, "NON_UNIQUE", set, false) == false);
                    String catalog = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_CATALOG", set), JDBCUtil.string(keys, "TABLE_CAT", set)});
                    String schema = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_SCHEMA", set), JDBCUtil.string(keys, "TABLE_SCHEM", set)});
                    adapter.correctSchemaFromJDBC(runtime, (Metadata)index, catalog, schema);
                    if (!adapter.equals(table.getCatalog(), index.getCatalog()) || !adapter.equals(table.getSchema(), index.getSchema())) continue;
                    index.setTable(JDBCUtil.string(keys, "TABLE_NAME", set));
                    indexes.put(name.toUpperCase(), index);
                    columns = new LinkedHashMap<String, Column>();
                    index.setColumns(columns);
                    if (name.equalsIgnoreCase("PRIMARY")) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    } else if (name.equalsIgnoreCase("PK_" + table.getName())) {
                        index.setCluster(true);
                        index.setPrimary(true);
                    }
                } else {
                    columns = index.getColumns();
                }
                String columnName = JDBCUtil.string(keys, "COLUMN_NAME", set);
                Column col = table.getColumn(columnName.toUpperCase());
                Column column = null;
                if (null != col) {
                    column = (Column)col.clone();
                } else {
                    column = new Column();
                    column.setName(columnName);
                }
                String order = JDBCUtil.string(keys, "ASC_OR_DESC", set);
                order = null != order && order.startsWith("D") ? "DESC" : "ASC";
                column.setOrder(order);
                column.setPosition(JDBCUtil.integer(keys, "ORDINAL_POSITION", set, null));
                columns.put(column.getName().toUpperCase(), column);
            }
        }
        finally {
            this.releaseConnection(adapter, runtime, con, ds);
        }
        return indexes;
    }
}

