/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.listener;

import java.util.Map;
import org.anyline.annotation.Component;
import org.anyline.bean.LoadListener;
import org.anyline.cache.CacheProvider;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.adapter.DriverAdapterHolder;
import org.anyline.data.adapter.DriverWorker;
import org.anyline.data.datasource.DataSourceLoader;
import org.anyline.data.interceptor.CountInterceptor;
import org.anyline.data.interceptor.DDInterceptor;
import org.anyline.data.interceptor.DeleteInterceptor;
import org.anyline.data.interceptor.ExecuteInterceptor;
import org.anyline.data.interceptor.InsertInterceptor;
import org.anyline.data.interceptor.QueryInterceptor;
import org.anyline.data.interceptor.UpdateInterceptor;
import org.anyline.data.listener.DDListener;
import org.anyline.data.listener.DMListener;
import org.anyline.entity.generator.PrimaryGenerator;
import org.anyline.proxy.CacheProxy;
import org.anyline.proxy.InterceptorProxy;
import org.anyline.proxy.ServiceProxy;
import org.anyline.service.AnylineService;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;

@Component(value="anyline.environment.data.listener.jdbc")
public class JDBCLoadListener
implements LoadListener {
    public void load() {
        AnylineService service;
        CacheProvider provider = (CacheProvider)ConfigTable.environment().getBean(CacheProvider.class);
        CacheProxy.init((CacheProvider)provider);
        InterceptorProxy.setQueryInterceptors((Map)ConfigTable.environment().getBeans(QueryInterceptor.class));
        InterceptorProxy.setCountInterceptors((Map)ConfigTable.environment().getBeans(CountInterceptor.class));
        InterceptorProxy.setUpdateInterceptors((Map)ConfigTable.environment().getBeans(UpdateInterceptor.class));
        InterceptorProxy.setInsertInterceptors((Map)ConfigTable.environment().getBeans(InsertInterceptor.class));
        InterceptorProxy.setDeleteInterceptors((Map)ConfigTable.environment().getBeans(DeleteInterceptor.class));
        InterceptorProxy.setExecuteInterceptors((Map)ConfigTable.environment().getBeans(ExecuteInterceptor.class));
        InterceptorProxy.setDDInterceptors((Map)ConfigTable.environment().getBeans(DDInterceptor.class));
        PrimaryGenerator primaryGenerator = (PrimaryGenerator)ConfigTable.environment().getBean(PrimaryGenerator.class);
        DMListener dmListener = (DMListener)ConfigTable.environment().getBean(DMListener.class);
        DDListener ddListener = (DDListener)ConfigTable.environment().getBean(DDListener.class);
        Map adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        Map workers = ConfigTable.environment().getBeans(DriverWorker.class);
        Map loaders = ConfigTable.environment().getBeans(DataSourceLoader.class);
        if (null != adapters) {
            DriverAdapterHolder.setAdapters((Map)adapters);
            for (DriverAdapter adapter : adapters.values()) {
                String delimiter;
                if (null != dmListener) {
                    adapter.setListener(dmListener);
                }
                if (null != ddListener) {
                    adapter.setListener(ddListener);
                }
                if (null != primaryGenerator) {
                    adapter.setGenerator(primaryGenerator);
                }
                if (null == (delimiter = ConfigTable.getString((String)("anyline.data.jdbc.delimiter." + adapter.type().name().toLowerCase())))) continue;
                adapter.setDelimiter(delimiter);
            }
        }
        if (null != loaders) {
            for (DataSourceLoader loader : loaders.values()) {
                loader.load();
            }
        }
        if (null == adapters || adapters.isEmpty()) {
            adapters = ConfigTable.environment().getBeans(DriverAdapter.class);
        }
        if (null == workers || workers.isEmpty()) {
            workers = ConfigTable.environment().getBeans(DriverWorker.class);
        }
        if (null != workers && null != adapters) {
            for (DriverWorker worker : workers.values()) {
                Class clazz = worker.supportAdapterType();
                for (DriverAdapter adapter : adapters.values()) {
                    DriverWorker origin;
                    if (!ClassUtil.isInSub(adapter.getClass(), (Class[])new Class[]{clazz}) || null != (origin = adapter.getWorker()) && origin.priority() >= worker.priority()) continue;
                    adapter.setWorker(worker);
                }
            }
        }
        if (ConfigTable.environment().containsBean("anyline.service.default") && null != (service = (AnylineService)ConfigTable.environment().getBean("anyline.service.default", AnylineService.class))) {
            ServiceProxy.init((AnylineService)service);
            Map services = ConfigTable.environment().getBeans(AnylineService.class);
            for (AnylineService item : services.values()) {
                if (null != item.getDao()) continue;
                item.setDao(service.getDao());
            }
        }
    }
}

