/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.jdbc.util;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.anyline.adapter.KeyAdapter;
import org.anyline.data.adapter.DriverAdapter;
import org.anyline.data.handler.DataRowHandler;
import org.anyline.data.handler.EntityHandler;
import org.anyline.data.handler.MapHandler;
import org.anyline.data.handler.ResultSetHandler;
import org.anyline.data.handler.StreamHandler;
import org.anyline.data.param.ConfigStore;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.metadata.BaseMetadata;
import org.anyline.metadata.Catalog;
import org.anyline.metadata.Column;
import org.anyline.metadata.Schema;
import org.anyline.metadata.Table;
import org.anyline.metadata.Tag;
import org.anyline.metadata.View;
import org.anyline.util.BasicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCUtil {
    private static Logger log = LoggerFactory.getLogger(JDBCUtil.class);

    public static Column column(DriverAdapter adapter, DataRuntime runtime, Column column, ResultSetMetaData rsm, int index) {
        if (null == column) {
            column = new Column();
        }
        String catalog = null;
        String schema = null;
        try {
            catalog = (String)BasicUtil.evl((Object[])new String[]{rsm.getCatalogName(index)});
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getCatalogName]");
        }
        try {
            schema = (String)BasicUtil.evl((Object[])new String[]{rsm.getSchemaName(index)});
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getSchemaName]");
        }
        adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)column, catalog, schema);
        try {
            column.setClassName(rsm.getColumnClassName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnClassName]");
        }
        try {
            column.caseSensitive(Boolean.valueOf(rsm.isCaseSensitive(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCaseSensitive]");
        }
        try {
            column.currency(Boolean.valueOf(rsm.isCurrency(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isCurrency]");
        }
        try {
            column.setOriginName(rsm.getColumnName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnName]");
        }
        try {
            column.setName(rsm.getColumnLabel(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnLabel]");
        }
        try {
            column.setPrecision(Integer.valueOf(rsm.getPrecision(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getPrecision]");
        }
        try {
            column.setScale(Integer.valueOf(rsm.getScale(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getScale]");
        }
        try {
            column.setDisplaySize(Integer.valueOf(rsm.getColumnDisplaySize(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnDisplaySize]");
        }
        try {
            column.setSigned(Boolean.valueOf(rsm.isSigned(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:isSigned]");
        }
        try {
            column.setTable(rsm.getTableName(index));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getTableName]");
        }
        try {
            column.setType(Integer.valueOf(rsm.getColumnType(index)));
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnType]");
        }
        try {
            String jdbcType = rsm.getColumnTypeName(index);
            column.setJdbcType(jdbcType);
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
        }
        catch (Exception e) {
            log.debug("[\u83b7\u53d6MetaData\u5931\u8d25][\u9a71\u52a8\u672a\u5b9e\u73b0:getColumnTypeName]");
        }
        adapter.typeMetadata(runtime, column);
        return column;
    }

    public static <T extends Column> LinkedHashMap<String, T> metadata(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> columns, DatabaseMetaData dbmd, Table table, String pattern) throws Exception {
        if (null == columns) {
            columns = new LinkedHashMap();
        }
        Catalog catalog = table.getCatalog();
        Schema schema = table.getSchema();
        if (BasicUtil.isEmpty((Object)table.getName())) {
            return columns;
        }
        String catalogName = null;
        String schemaName = null;
        if (null != catalog) {
            catalogName = catalog.getName();
        }
        if (null != schema) {
            schemaName = schema.getName();
        }
        ResultSet set = dbmd.getColumns(catalogName, schemaName, table.getName(), pattern);
        Map<String, Integer> keys = JDBCUtil.keys(set);
        while (set.next()) {
            Column column;
            String columnSchema;
            String name = set.getString("COLUMN_NAME");
            if (null == name) continue;
            String columnCatalog = JDBCUtil.string(keys, "TABLE_CAT", set, null);
            if (null != columnCatalog) {
                columnCatalog = columnCatalog.trim();
            }
            if (null != (columnSchema = JDBCUtil.string(keys, "TABLE_SCHEM", set, null))) {
                columnSchema = columnSchema.trim();
            }
            if (null == (column = (Column)columns.get(name.toUpperCase()))) {
                if (!create) continue;
                column = new Column(name);
                columns.put(name.toUpperCase(), column);
            }
            adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)column, columnCatalog, columnSchema);
            if (!BasicUtil.equalsIgnoreCase((Object)catalog, (Object)column.getCatalogName()) || !BasicUtil.equalsIgnoreCase((Object)schema, (Object)column.getSchemaName())) continue;
            String remark = JDBCUtil.string(keys, "REMARKS", set, column.getComment());
            if ("TAG".equals(remark)) {
                column = new Tag();
            }
            column.setComment(remark);
            column.setTable((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_NAME", set, table.getName()), column.getTableName(true)}));
            column.setType(JDBCUtil.integer(keys, "DATA_TYPE", set, column.getType()));
            column.setType(JDBCUtil.integer(keys, "SQL_DATA_TYPE", set, column.getType()));
            String jdbcType = JDBCUtil.string(keys, "TYPE_NAME", set, column.getTypeName());
            if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                column.setTypeName(jdbcType);
            }
            column.setJdbcType(jdbcType);
            column.setPrecision(JDBCUtil.integer(keys, "COLUMN_SIZE", set, column.getPrecision()));
            column.setScale(JDBCUtil.integer(keys, "DECIMAL_DIGITS", set, column.getScale()));
            column.nullable(JDBCUtil.bool(keys, "NULLABLE", set, column.isNullable()));
            column.setDefaultValue(JDBCUtil.value(keys, "COLUMN_DEF", set, column.getDefaultValue()));
            column.setPosition(JDBCUtil.integer(keys, "ORDINAL_POSITION", set, column.getPosition()));
            column.autoIncrement(JDBCUtil.bool(keys, "IS_AUTOINCREMENT", set, column.isAutoIncrement()));
            adapter.typeMetadata(runtime, column);
            JDBCUtil.column(adapter, runtime, column, set);
            column.setName(name);
        }
        ResultSet rs = dbmd.getPrimaryKeys(catalogName, schemaName, table.getName());
        while (rs.next()) {
            String name = rs.getString(4);
            Column column = (Column)columns.get(name.toUpperCase());
            if (null == column) continue;
            column.primary(Boolean.valueOf(true));
        }
        return columns;
    }

    public static Column column(DriverAdapter adapter, DataRuntime runtime, Column column, ResultSet rs) {
        if (null == column) {
            column = new Column();
        }
        try {
            Map<String, Integer> keys = JDBCUtil.keys(rs);
            if (null == column.getName()) {
                column.setName(JDBCUtil.string(keys, "COLUMN_NAME", rs));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)JDBCUtil.string(keys, "DATA_TYPE", rs), null));
            }
            if (null == column.getType()) {
                column.setType(BasicUtil.parseInt((Object)JDBCUtil.string(keys, "SQL_DATA_TYPE", rs), null));
            }
            if (null == column.getTypeName()) {
                String jdbcType = JDBCUtil.string(keys, "TYPE_NAME", rs);
                column.setJdbcType(jdbcType);
                if (BasicUtil.isEmpty((Object)column.getTypeName())) {
                    column.setTypeName(jdbcType);
                }
            }
            if (null == column.getPrecision()) {
                column.setPrecision(JDBCUtil.integer(keys, "COLUMN_SIZE", rs, null));
            }
            if (null == column.getScale()) {
                column.setScale(BasicUtil.parseInt((Object)JDBCUtil.string(keys, "DECIMAL_DIGITS", rs), null));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)JDBCUtil.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (-1 == column.isAutoIncrement()) {
                column.autoIncrement(BasicUtil.parseBoolean((Object)JDBCUtil.string(keys, "IS_AUTOINCREMENT", rs), (Boolean)false));
            }
            if (-1 == column.isGenerated()) {
                column.generated(BasicUtil.parseBoolean((Object)JDBCUtil.string(keys, "IS_GENERATEDCOLUMN", rs), (Boolean)false));
            }
            if (null == column.getComment()) {
                column.setComment(JDBCUtil.string(keys, "REMARKS", rs));
            }
            if (null == column.getPosition()) {
                column.setPosition(BasicUtil.parseInt((Object)JDBCUtil.string(keys, "ORDINAL_POSITION", rs), (Integer)0));
            }
            if (BasicUtil.isEmpty((Object)column.getDefaultValue())) {
                column.setDefaultValue((Object)JDBCUtil.string(keys, "COLUMN_DEF", rs));
            }
            adapter.typeMetadata(runtime, column);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return column;
    }

    public static DataRow row(DriverAdapter adapter, boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ConfigStore configs, ResultSet rs) {
        DataRow row = null;
        KeyAdapter.KEY_CASE kc = null;
        if (null != configs) {
            kc = configs.keyCase();
        }
        boolean upper = false;
        if (KeyAdapter.KEY_CASE.PUT_UPPER == kc) {
            upper = true;
            row = new DataRow(KeyAdapter.KEY_CASE.SRC);
        } else {
            row = null != kc ? new DataRow(kc) : new DataRow();
        }
        try {
            Column column;
            String name;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && (null == metadatas || metadatas.isEmpty())) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = JDBCUtil.column(adapter, runtime, column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                try {
                    column = metadatas.get(name.toUpperCase());
                    Object value = adapter.read(runtime, column, rs.getObject(name), null);
                    if (upper) {
                        name = name.toUpperCase();
                    }
                    row.put(false, name, value);
                    continue;
                }
                catch (Exception e) {
                    if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[\u7ed3\u679c\u96c6\u5c01\u88c5][result:fail][msg:{}]", (Object)e.toString());
                }
            }
            row.setMetadata(metadatas);
        }
        catch (Exception e) {
            if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                e.printStackTrace();
            }
            log.error("[\u7ed3\u679c\u96c6\u5c01\u88c5][result:fail][msg:{}]", (Object)e.toString());
        }
        return row;
    }

    public static LinkedHashMap<String, Object> map(DriverAdapter adapter, boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas, ConfigStore configs, ResultSet rs) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        try {
            Column column;
            String name;
            int i;
            ResultSetMetaData rsmd = rs.getMetaData();
            int qty = rsmd.getColumnCount();
            if (!system && (null == metadatas || metadatas.isEmpty())) {
                for (i = 1; i <= qty; ++i) {
                    name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                    column = metadatas.get(name);
                    column = JDBCUtil.column(adapter, runtime, column, rsmd, i);
                    metadatas.put(name.toUpperCase(), column);
                }
            }
            for (i = 1; i <= qty; ++i) {
                name = rsmd.getColumnLabel(i);
                if (null == name || name.toUpperCase().equals("PAGE_ROW_NUMBER_")) continue;
                try {
                    column = metadatas.get(name.toUpperCase());
                    Object value = adapter.read(runtime, column, rs.getObject(name), null);
                    map.put(name, value);
                    continue;
                }
                catch (Exception e) {
                    if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                        e.printStackTrace();
                        continue;
                    }
                    log.error("[\u7ed3\u679c\u96c6\u5c01\u88c5][result:fail][msg:{}]", (Object)e.toString());
                }
            }
        }
        catch (Exception e) {
            if (ConfigStore.IS_PRINT_EXCEPTION_STACK_TRACE((ConfigStore)configs)) {
                e.printStackTrace();
            }
            log.error("[\u7ed3\u679c\u96c6\u5c01\u88c5][result:fail][msg:{}]", (Object)e.toString());
        }
        return map;
    }

    public static boolean stream(DriverAdapter adapter, StreamHandler handler, ResultSet rs, ConfigStore configs, boolean system, DataRuntime runtime, LinkedHashMap<String, Column> metadatas) {
        try {
            if (handler instanceof ResultSetHandler) {
                return ((ResultSetHandler)handler).read(rs);
            }
            if (handler instanceof DataRowHandler) {
                DataRowHandler dataRowHandler = (DataRowHandler)handler;
                DataRow row = JDBCUtil.row(adapter, system, runtime, metadatas, configs, rs);
                if (!dataRowHandler.read(row)) {
                    return false;
                }
            } else if (handler instanceof EntityHandler) {
                DataRow row;
                EntityHandler entityHandler;
                Class clazz = configs.entityClass();
                if (null != clazz && !(entityHandler = (EntityHandler)handler).read((row = JDBCUtil.row(adapter, system, runtime, metadatas, configs, rs)).entity(clazz, new String[0]))) {
                    return false;
                }
            } else if (handler instanceof MapHandler) {
                MapHandler mh = (MapHandler)handler;
                ResultSetMetaData rsmd = rs.getMetaData();
                int cols = rsmd.getColumnCount();
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (int i = 1; i <= cols; ++i) {
                    String name = rsmd.getColumnLabel(i);
                    if (null == name) {
                        name = rsmd.getColumnName(i);
                    }
                    map.put(name, rs.getObject(i));
                }
                if (!mh.read(map)) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String string(Map<String, Integer> keys, String key, ResultSet set, String def) throws Exception {
        Object value = JDBCUtil.value(keys, key, set);
        if (null != value) {
            return value.toString();
        }
        return def;
    }

    public static String string(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return JDBCUtil.string(keys, key, set, null);
    }

    public static Integer integer(Map<String, Integer> keys, String key, ResultSet set, Integer def) throws Exception {
        Object value = JDBCUtil.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseInt((Object)value, (Integer)def);
        }
        return null;
    }

    public static Long longs(Map<String, Integer> keys, String key, ResultSet set, Long def) throws Exception {
        Object value = JDBCUtil.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseLong((Object)value, (Long)def);
        }
        return null;
    }

    public static Boolean bool(Map<String, Integer> keys, String key, ResultSet set, Boolean def) throws Exception {
        Object value = JDBCUtil.value(keys, key, set);
        if (null != value) {
            return BasicUtil.parseBoolean((Object)value, (Boolean)def);
        }
        return null;
    }

    public static Boolean bool(Map<String, Integer> keys, String key, ResultSet set, int def) throws Exception {
        Boolean defaultValue = null;
        if (def == 0) {
            defaultValue = false;
        } else if (def == 1) {
            defaultValue = true;
        }
        return JDBCUtil.bool(keys, key, set, defaultValue);
    }

    public static Object value(Map<String, Integer> keys, String key, ResultSet set, Object def) throws Exception {
        String[] ks = key.split(",");
        Object result = null;
        for (String k : ks) {
            Integer index = keys.get(k);
            if (null == index || index < 0) continue;
            try {
                result = set.getObject(index);
                if (null == result) continue;
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return def;
    }

    public static Object value(Map<String, Integer> keys, String key, ResultSet set) throws Exception {
        return JDBCUtil.value(keys, key, set, null);
    }

    public static <T extends Table> LinkedHashMap<String, T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> tables, ResultSet set) throws Exception {
        if (null == tables) {
            tables = new LinkedHashMap();
        }
        Map<String, Integer> keys = JDBCUtil.keys(set);
        while (set.next()) {
            String tableName = JDBCUtil.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = JDBCUtil.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            Table table = (Table)tables.get(tableName.toUpperCase());
            if (null == table) {
                if (!create) continue;
                table = new Table();
                tables.put(tableName.toUpperCase(), table);
            }
            String catalogName = JDBCUtil.string(keys, "TABLE_CAT", set);
            String schemaName = JDBCUtil.string(keys, "TABLE_SCHEM", set);
            adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)table, catalogName, schemaName);
            table.setName(tableName);
            JDBCUtil.init(table, set, keys);
            tables.put(tableName.toUpperCase(), table);
        }
        return tables;
    }

    public static <T extends Table> List<T> tables(DriverAdapter adapter, DataRuntime runtime, boolean create, List<T> tables, ResultSet set) throws Exception {
        if (null == tables) {
            tables = new ArrayList<T>();
        }
        Map<String, Integer> keys = JDBCUtil.keys(set);
        while (set.next()) {
            String tableName = JDBCUtil.string(keys, "TABLE_NAME", set);
            if (BasicUtil.isEmpty((Object)tableName)) {
                tableName = JDBCUtil.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)tableName)) continue;
            String catalogName = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_CATALOG", set), JDBCUtil.string(keys, "TABLE_CAT", set)});
            String schemaName = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_SCHEMA", set), JDBCUtil.string(keys, "TABLE_SCHEM", set)});
            Table chk = new Table();
            adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)chk, catalogName, schemaName);
            Table table = (Table)adapter.search(tables, chk.getCatalog(), chk.getSchema(), tableName);
            boolean contains = true;
            if (null == table) {
                if (!create) continue;
                table = new Table();
                contains = false;
            }
            adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)table, catalogName, schemaName);
            table.setSchema(schemaName);
            table.setName(tableName);
            JDBCUtil.init(table, set, keys);
            if (contains) continue;
            tables.add(table);
        }
        return tables;
    }

    public static <T extends View> LinkedHashMap<String, T> views(DriverAdapter adapter, DataRuntime runtime, boolean create, LinkedHashMap<String, T> views, ResultSet set) throws Exception {
        if (null == views) {
            views = new LinkedHashMap();
        }
        Map<String, Integer> keys = JDBCUtil.keys(set);
        while (set.next()) {
            String viewName = JDBCUtil.string(keys, "VIEW_NAME", set);
            if (BasicUtil.isEmpty((Object)viewName)) {
                viewName = JDBCUtil.string(keys, "NAME", set);
            }
            if (BasicUtil.isEmpty((Object)viewName)) {
                viewName = JDBCUtil.string(keys, "TABLE_NAME", set);
            }
            if (BasicUtil.isEmpty((Object)viewName)) continue;
            View view = (View)views.get(viewName.toUpperCase());
            if (null == view) {
                if (!create) continue;
                view = new View();
                views.put(viewName.toUpperCase(), view);
            }
            String catalogName = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_CATALOG", set), JDBCUtil.string(keys, "TABLE_CAT", set)});
            String schemaName = (String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_SCHEMA", set), JDBCUtil.string(keys, "TABLE_SCHEM", set)});
            adapter.correctSchemaFromJDBC(runtime, (BaseMetadata)view, catalogName, schemaName);
            view.setName(viewName);
            JDBCUtil.init(view, set, keys);
            views.put(viewName.toUpperCase(), view);
        }
        return views;
    }

    public static Map<String, Integer> keys(ResultSet set) throws Exception {
        ResultSetMetaData rsmd = set.getMetaData();
        HashMap<String, Integer> keys = new HashMap<String, Integer>();
        if (null != rsmd) {
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                String name = rsmd.getColumnLabel(i);
                if (null == name) {
                    name = rsmd.getColumnName(i);
                }
                keys.put(name.toUpperCase(), i);
            }
        }
        return keys;
    }

    public static void init(Table table, ResultSet set, Map<String, Integer> keys) {
        try {
            table.setType((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_TYPE", set), table.getType()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.setComment((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "REMARKS", set), table.getComment()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.setTypeCat((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TYPE_CAT", set), table.getTypeCat()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.setTypeName((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TYPE_NAME", set), table.getTypeName()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "SELF_REFERENCING_COL_NAME", set), table.getSelfReferencingColumn()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            table.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "REF_GENERATION", set), table.getRefGeneration()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void init(View view, ResultSet set, Map<String, Integer> keys) {
        try {
            view.setType((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TABLE_TYPE", set), view.getType()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setComment((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "REMARKS", set), view.getComment()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTypeCat((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TYPE_CAT", set), view.getTypeCat()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setTypeName((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "TYPE_NAME", set), view.getTypeName()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setSelfReferencingColumn((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "SELF_REFERENCING_COL_NAME", set), view.getSelfReferencingColumn()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            view.setRefGeneration((String)BasicUtil.evl((Object[])new String[]{JDBCUtil.string(keys, "REF_GENERATION", set), view.getRefGeneration()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void queryTimeout(Statement statement, ConfigStore configs) {
        int timeout = ConfigStore.SQL_QUERY_TIMEOUT((ConfigStore)configs);
        if (timeout > 0) {
            try {
                statement.setQueryTimeout(timeout);
            }
            catch (Exception e) {
                log.warn("\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u5f02\u5e38:{}", (Object)e.toString());
            }
        }
    }

    public static void updateTimeout(Statement statement, ConfigStore configs) {
        int timeout = ConfigStore.SQL_QUERY_TIMEOUT((ConfigStore)configs);
        if (timeout > 0) {
            try {
                statement.setQueryTimeout(timeout);
            }
            catch (Exception e) {
                log.warn("\u8bbe\u7f6e\u8d85\u65f6\u65f6\u95f4\u5f02\u5e38:{}", (Object)e.toString());
            }
        }
    }
}

