/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.prepare.auto.init;

import java.util.List;
import org.anyline.data.prepare.RunPrepare;
import org.anyline.data.prepare.auto.TablePrepare;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoPrepare;
import org.anyline.data.run.Run;
import org.anyline.data.run.TableRun;
import org.anyline.data.runtime.DataRuntime;
import org.anyline.entity.DataRow;
import org.anyline.entity.OriginRow;
import org.anyline.metadata.Table;

public class DefaultTablePrepare
extends DefaultAutoPrepare
implements TablePrepare {
    public DefaultTablePrepare() {
        this.chain = new DefaultAutoConditionChain();
    }

    public DefaultTablePrepare(String table) {
        this.chain = new DefaultAutoConditionChain();
        this.setTable(table);
    }

    public DefaultTablePrepare(Table table) {
        this.chain = new DefaultAutoConditionChain();
        this.setTable(table);
    }

    @Override
    public RunPrepare setTable(String table) {
        this.table = null != table ? new Table(table) : null;
        this.parseTable(this.table);
        return this;
    }

    @Override
    public Run build(DataRuntime runtime) {
        TableRun run = new TableRun(runtime, this.getTable());
        run.setPrepare(this);
        run.setConfigStore(this.condition());
        List<RunPrepare> unions = this.getUnions();
        if (null != unions) {
            for (RunPrepare union : unions) {
                run.union(union.build(runtime));
            }
        }
        return run;
    }

    @Override
    public DataRow map(boolean empty, boolean join) {
        OriginRow row = new OriginRow();
        row.put("table", (Object)this.table.getName());
        if (null != this.table.getAlias() || empty) {
            row.put("alias", (Object)this.table.getAlias());
        }
        if (join && null != this.join) {
            row.put("type", (Object)this.join.getType().name());
            row.put("conditions", (Object)this.join.getConditions().getConfigChain().map(empty));
        }
        return row;
    }

    @Override
    public DefaultTablePrepare clone() {
        DefaultTablePrepare clone = null;
        try {
            clone = (DefaultTablePrepare)super.clone();
        }
        catch (Exception e) {
            clone = new DefaultTablePrepare();
        }
        return clone;
    }
}

