/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.transaction.init;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import javax.sql.DataSource;
import org.anyline.data.datasource.ApplicationConnectionHolder;
import org.anyline.data.datasource.ThreadConnectionHolder;
import org.anyline.data.transaction.TransactionDefine;
import org.anyline.data.transaction.TransactionManage;
import org.anyline.data.transaction.TransactionState;
import org.anyline.data.transaction.init.DefaultTransactionState;

public class DefaultTransactionManage
implements TransactionManage {
    private DataSource datasource;

    public DefaultTransactionManage() {
    }

    public DefaultTransactionManage(DataSource datasource) {
        this.datasource = datasource;
    }

    public DataSource getDatasource() {
        return this.datasource;
    }

    public void setDatasource(DataSource datasource) {
        this.datasource = datasource;
    }

    @Override
    public TransactionState start(TransactionDefine define) throws SQLException {
        Connection con = null;
        String name = define.getName();
        TransactionDefine.MODE mode = define.getMode();
        boolean isNew = false;
        if (TransactionDefine.MODE.THREAD == mode) {
            con = ThreadConnectionHolder.get(this.datasource);
            if (null == con || con.isClosed()) {
                con = this.datasource.getConnection();
                isNew = true;
                ThreadConnectionHolder.set(this.datasource, con);
            }
        } else if (TransactionDefine.MODE.APPLICATION == mode) {
            con = ApplicationConnectionHolder.get(this.datasource, name);
            if (null == con) {
                con = this.datasource.getConnection();
                isNew = true;
                ApplicationConnectionHolder.set(this.datasource, name, con);
                log.info("[\u5f00\u542f\u8de8\u7ebf\u7a0b\u4e8b\u52a1][name:{}]", (Object)name);
            } else {
                log.info("[\u52a0\u5165\u8de8\u7ebf\u7a0b\u4e8b\u52a1][name:{}]", (Object)name);
            }
            ThreadConnectionHolder.set(this.datasource, con);
        }
        DefaultTransactionState state = new DefaultTransactionState();
        state.setConnection(con);
        state.setDataSource(this.datasource);
        state.setName(name);
        state.setMode(mode);
        if (isNew) {
            con.setAutoCommit(false);
        }
        TransactionManage.records.put(state, this);
        return state;
    }

    @Override
    public void commit(TransactionState state) throws SQLException {
        DataSource ds = state.getDataSource();
        Connection con = state.getConnection();
        con.commit();
        con.setAutoCommit(true);
        con.close();
        String name = state.getName();
        log.info("[\u63d0\u4ea4\u4e8b\u52a1][name:{}]", (Object)name);
        TransactionDefine.MODE mode = state.getMode();
        if (TransactionDefine.MODE.THREAD == mode) {
            ThreadConnectionHolder.remove(ds);
        } else if (TransactionDefine.MODE.APPLICATION == mode) {
            ApplicationConnectionHolder.remove(ds, name);
        }
        TransactionManage.records.remove(state);
    }

    @Override
    public void rollback(TransactionState state) throws SQLException {
        DataSource ds = state.getDataSource();
        Connection con = state.getConnection();
        Savepoint point = state.getPoint();
        if (null != point) {
            con.rollback(point);
        } else {
            con.rollback();
        }
        con.setAutoCommit(true);
        con.close();
        String name = state.getName();
        log.info("[\u56de\u6eda\u4e8b\u52a1][name:{}]", (Object)name);
        TransactionDefine.MODE mode = state.getMode();
        if (TransactionDefine.MODE.THREAD == mode) {
            ThreadConnectionHolder.remove(ds);
        } else if (TransactionDefine.MODE.APPLICATION == mode) {
            ApplicationConnectionHolder.remove(ds, name);
        }
        TransactionManage.records.remove(state);
    }
}

