/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.util;

import java.util.Collection;
import org.anyline.data.param.ConfigStore;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.metadata.Metadata;
import org.anyline.metadata.Table;
import org.anyline.proxy.EntityAdapterProxy;
import org.anyline.util.BasicUtil;
import org.anyline.util.regular.RegularUtil;

public class DataSourceUtil {
    public static String[] parseRuntime(Metadata meta) {
        if (null != meta) {
            return DataSourceUtil.parseRuntime(meta.getName());
        }
        return new String[2];
    }

    public static String[] parseRuntime(String src) {
        String[] result = new String[2];
        result[1] = src;
        String runtime = null;
        if (null != src && src.startsWith("<")) {
            int fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                runtime = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                result[0] = runtime;
                result[1] = src;
            }
        }
        return result;
    }

    public static Table parseDest(String src, ConfigStore configs) {
        int fr;
        if (null == src) {
            return null;
        }
        Table result = new Table();
        String up = src.toUpperCase().trim();
        if (src.startsWith("<")) {
            fr = src.indexOf("<");
            int to = src.indexOf(">");
            if (fr != -1) {
                String datasource = src.substring(fr + 1, to);
                src = src.substring(to + 1);
                result.setDataSource(datasource);
            }
        }
        if (src.endsWith(">") && (fr = src.lastIndexOf("<")) != -1) {
            String[] keys = src.substring(fr + 1, src.length() - 1).split(",");
            src = src.substring(0, fr);
            result.setPrimaryKey(keys);
        }
        if (src.contains(" ") || up.startsWith("SELECT")) {
            result.setText(src);
        } else if (src.contains(":")) {
            result.setId(src);
        }
        if (!up.startsWith("SELECT")) {
            result.setName(src);
        }
        return result;
    }

    public static Table parseDest(String dest, Object obj, ConfigStore configs) {
        Table table = null;
        if (BasicUtil.isNotEmpty((Object)dest) || null == obj) {
            return DataSourceUtil.parseDest(dest, configs);
        }
        if (obj instanceof DataRow) {
            DataRow row = (DataRow)obj;
            table = DataSourceUtil.parseDest(row.getDest(), configs);
        } else if (obj instanceof DataSet) {
            DataSet set = (DataSet)obj;
            if (!set.isEmpty()) {
                table = DataSourceUtil.parseDest(set.getRow(0).getDest(), configs);
            }
        } else if (obj instanceof Collection) {
            Collection list = (Collection)obj;
            if (!list.isEmpty()) {
                Object first = list.iterator().next();
                if (first instanceof DataRow) {
                    table = DataSourceUtil.parseDest(((DataRow)first).getDest(), configs);
                } else {
                    String tableName = EntityAdapterProxy.table(first.getClass(), (boolean)true);
                    table = DataSourceUtil.parseDest(tableName, configs);
                }
            }
        } else {
            table = EntityAdapterProxy.table(obj.getClass());
        }
        return table;
    }

    public static String parseAdapterKey(String url) {
        return DataSourceUtil.parseParamValue(url, "adapter");
    }

    public static String parseCatalog(String url) {
        return DataSourceUtil.parseParamValue(url, "catalog");
    }

    public static String parseSchema(String url) {
        return DataSourceUtil.parseParamValue(url, "schema");
    }

    public static String parseParamValue(String url, String key) {
        String value = null;
        if (null != url && url.contains(key) && BasicUtil.isEmpty((Object)(value = RegularUtil.cut((String)url, (String[])new String[]{key + "=", "&"})))) {
            value = RegularUtil.cut((String)url, (String[])new String[]{key + "=", "${end}"});
        }
        return value;
    }
}

