/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.data.param.init;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.anyline.data.param.Config;
import org.anyline.data.param.ConfigChain;
import org.anyline.data.param.init.DefaultConfig;
import org.anyline.data.prepare.Condition;
import org.anyline.data.prepare.ConditionChain;
import org.anyline.data.prepare.auto.init.DefaultAutoConditionChain;
import org.anyline.entity.Compare;
import org.anyline.entity.DataRow;
import org.anyline.entity.DataSet;
import org.anyline.entity.OriginRow;
import org.anyline.util.BasicUtil;

public class DefaultConfigChain
extends DefaultConfig
implements ConfigChain {
    private List<Config> configs = new ArrayList<Config>();

    public DefaultConfigChain() {
    }

    @Override
    public String toString() {
        Object str = null;
        if (null != this.configs) {
            for (Config conf : this.configs) {
                if (null == conf) continue;
                if (null == str) {
                    str = conf.toString();
                    continue;
                }
                str = (String)str + "," + conf;
            }
        }
        return "[" + str + "]";
    }

    @Override
    public DataRow map() {
        return this.map(true);
    }

    @Override
    public DataRow map(boolean empty) {
        OriginRow row = new OriginRow();
        String join = this.getJoin();
        if (null != join) {
            join = join.trim();
        }
        row.put("join", (Object)join);
        if (null != this.configs && !this.configs.isEmpty() || empty) {
            DataSet set = new DataSet();
            for (Config config : this.configs) {
                set.add(config.map(empty));
            }
            row.put("items", (Object)set);
        }
        return row;
    }

    @Override
    public String json() {
        return this.map().json();
    }

    @Override
    public String cacheKey() {
        Object str = null;
        if (null != this.configs) {
            for (Config conf : this.configs) {
                if (null == conf) continue;
                if (null == str) {
                    str = conf.cacheKey();
                    continue;
                }
                str = (String)str + "," + conf.cacheKey();
            }
        }
        return str;
    }

    public DefaultConfigChain(String config) {
        if (null == config) {
            return;
        }
        String[] configs = config.split("\\|");
        int size = configs.length;
        for (int i = 0; i < size; ++i) {
            String next;
            Object item = configs[i];
            if (i + 1 < size && !(next = configs[i + 1]).contains(":")) {
                item = (String)item + "|" + next;
                ++i;
            }
            DefaultConfig conf = new DefaultConfig((String)item);
            conf.setJoin(" OR ");
            this.configs.add(conf);
        }
    }

    @Override
    public Config getConfig(String id, String var) {
        List<Config> list = this.getConfigs(id, var);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public List<Config> getConfigs(String id, String var) {
        ArrayList<Config> list = new ArrayList<Config>();
        if (BasicUtil.isEmpty((Object[])new Object[]{id, var})) {
            return list;
        }
        for (Config conf : this.configs) {
            if (conf instanceof ConfigChain) {
                ConfigChain chain = (ConfigChain)conf;
                list.addAll(chain.getConfigs(id, var));
            }
            String confId = conf.getPrefix();
            String confVar = conf.getVariable();
            if (BasicUtil.isEmpty((Object)id)) {
                if (!var.equalsIgnoreCase(confVar)) continue;
                list.add(conf);
                continue;
            }
            if (BasicUtil.isEmpty((Object)var)) {
                if (!id.equalsIgnoreCase(confId)) continue;
                list.add(conf);
                continue;
            }
            if (!id.equalsIgnoreCase(confId) || !var.equalsIgnoreCase(confVar)) continue;
            list.add(conf);
        }
        return list;
    }

    @Override
    public List<Config> getConfigs(String prefix, String var, Compare type) {
        ArrayList<Config> list = new ArrayList<Config>();
        if (BasicUtil.isEmpty((Object[])new Object[]{prefix, var})) {
            return list;
        }
        for (Config conf : this.configs) {
            if (conf instanceof ConfigChain) {
                ConfigChain chain = (ConfigChain)conf;
                list.addAll(chain.getConfigs(prefix, var, type));
            }
            String confId = conf.getPrefix();
            String confVar = conf.getVariable();
            Compare confType = conf.getCompare();
            if (BasicUtil.isEmpty((Object)prefix)) {
                if (!var.equalsIgnoreCase(confVar) || type != confType) continue;
                list.add(conf);
                continue;
            }
            if (BasicUtil.isEmpty((Object)var)) {
                if (!prefix.equalsIgnoreCase(confId) || type != confType) continue;
                list.add(conf);
                continue;
            }
            if (!prefix.equalsIgnoreCase(confId) || !var.equalsIgnoreCase(confVar) || type != confType) continue;
            list.add(conf);
        }
        return list;
    }

    @Override
    public Config getConfig(String prefix, String var, Compare type) {
        if (BasicUtil.isEmpty((Object[])new Object[]{prefix, var})) {
            return null;
        }
        List<Config> list = this.getConfigs(prefix, var, type);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    public ConfigChain removeConfig(String prefix, String var) {
        List<Config> configs = this.getConfigs(prefix, var);
        return this.removeConfig(configs);
    }

    @Override
    public ConfigChain removeConfig(String key, String var, Compare type) {
        List<Config> configs = this.getConfigs(key, var, type);
        return this.removeConfig(configs);
    }

    @Override
    public ConfigChain removeConfig(Config config) {
        if (null != config) {
            this.configs.remove(config);
            for (Config item : this.configs) {
                if (!(item instanceof ConfigChain)) continue;
                ConfigChain chain = (ConfigChain)item;
                chain.removeConfig(config);
            }
        }
        return this;
    }

    @Override
    public ConfigChain removeConfig(List<Config> list) {
        if (null != list) {
            for (Config config : list) {
                this.removeConfig(config);
            }
        }
        return this;
    }

    @Override
    public void addConfig(Config config) {
        this.configs.add(config);
    }

    @Override
    public List<Object> getValues() {
        ArrayList<Object> values = new ArrayList<Object>();
        for (Config config : this.configs) {
            List<Object> vs = config.getValues();
            if (null == vs) continue;
            values.addAll(vs);
        }
        return values;
    }

    @Override
    public List<Config> getConfigs() {
        return this.configs;
    }

    @Override
    public ConditionChain createAutoConditionChain() {
        DefaultAutoConditionChain chain = new DefaultAutoConditionChain();
        chain.setJoin(this.getJoin());
        for (Config config : this.configs) {
            Condition condition = config.createAutoCondition(chain);
            if (null == condition) continue;
            if (condition instanceof ConditionChain) {
                ConditionChain itemChain = (ConditionChain)condition;
                List<Condition> items = itemChain.getConditions();
                if (items.size() == 1) {
                    Condition first = items.get(0);
                    first.setJoin(itemChain.getJoin());
                    chain.addCondition(first);
                    continue;
                }
                if (items.size() <= 1) continue;
                chain.addCondition(condition);
                continue;
            }
            chain.addCondition(condition);
        }
        chain.integrality(this.integrality);
        return chain;
    }

    @Override
    public void setValue(Map<String, Object> values) {
        for (Config config : this.configs) {
            config.setValue(values);
        }
    }

    @Override
    public boolean isEmpty() {
        if (null != this.configs) {
            for (Config config : this.configs) {
                if (null == config || config.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public DefaultConfigChain clone() {
        DefaultConfigChain clone = null;
        try {
            clone = (DefaultConfigChain)super.clone();
            clone.configs = new ArrayList<Config>();
        }
        catch (Exception e) {
            clone = new DefaultConfigChain();
        }
        List<Config> configs = this.getConfigs();
        for (Config config : configs) {
            if (null == config) continue;
            clone.configs.add(config.clone());
        }
        return clone;
    }
}

