/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.prepare.auto.init;

public class Join {
    private String schema;
    private String name;
    private String alias;
    private TYPE type = TYPE.INNER;
    private String condition;

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
        this.parseName();
    }

    private void parseName() {
        if (null != this.name) {
            if (null != this.name && this.name.contains(".")) {
                String[] tbs = this.name.split("\\.");
                this.name = tbs[1];
                this.schema = tbs[0];
            }
            String tag = " as ";
            String lower = this.name.toLowerCase();
            int tagIdx = lower.indexOf(tag);
            if (tagIdx > 0) {
                this.alias = this.name.substring(tagIdx + tag.length()).trim();
                this.name = this.name.substring(0, tagIdx).trim();
            }
            if (this.name.contains(" ")) {
                String[] tmps = this.name.split(" ");
                this.name = tmps[0];
                this.alias = tmps[1];
            }
        }
    }

    public TYPE getType() {
        return this.type;
    }

    public void setType(TYPE type) {
        this.type = type;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public static enum TYPE {
        INNER{

            @Override
            public String getCode() {
                return "INNER JOIN";
            }

            @Override
            public String getName() {
                return "\u5185\u8fde\u63a5";
            }
        }
        ,
        LEFT{

            @Override
            public String getCode() {
                return "LEFT JOIN";
            }

            @Override
            public String getName() {
                return "\u5de6\u8fde\u63a5";
            }
        }
        ,
        RIGHT{

            @Override
            public String getCode() {
                return "RIGHT JOIN";
            }

            @Override
            public String getName() {
                return "\u53f3\u8fde\u63a5";
            }
        }
        ,
        FULL{

            @Override
            public String getCode() {
                return "FULL JOIN";
            }

            @Override
            public String getName() {
                return "\u5168\u8fde\u63a5";
            }
        };


        public abstract String getName();

        public abstract String getCode();
    }
}

