/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.prepare.auto.init;

import java.util.ArrayList;
import java.util.List;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.param.Config;
import org.anyline.jdbc.param.ConfigChain;
import org.anyline.jdbc.prepare.Condition;
import org.anyline.jdbc.prepare.ConditionChain;
import org.anyline.jdbc.prepare.auto.init.SimpleAutoCondition;
import org.anyline.jdbc.prepare.init.SimpleConditionChain;
import org.anyline.jdbc.run.RunValue;
import org.anyline.util.BasicUtil;

public class SimpleAutoConditionChain
extends SimpleConditionChain
implements ConditionChain {
    public SimpleAutoConditionChain() {
    }

    public SimpleAutoConditionChain(ConfigChain chain) {
        if (null == chain) {
            return;
        }
        for (Config config : chain.getConfigs()) {
            if (config instanceof ConfigChain) {
                this.conditions.add(new SimpleAutoConditionChain((ConfigChain)config));
                continue;
            }
            this.conditions.add(new SimpleAutoCondition(config));
        }
    }

    @Override
    public String getRunText(String prefix, JDBCAdapter adapter) {
        this.runValues = new ArrayList();
        int size = this.conditions.size();
        if (size == 0) {
            return "";
        }
        StringBuilder subBuilder = new StringBuilder();
        String txt = "";
        for (int i = 0; i < size; ++i) {
            String chk;
            Condition condition = (Condition)this.conditions.get(i);
            if (null == condition || BasicUtil.isEmpty((Object)(txt = condition.getRunText(prefix, adapter)))) continue;
            List<RunValue> values = condition.getRunValues();
            if (condition.getVariableType() != 2 && BasicUtil.isEmpty((boolean)true, values) && !condition.isActive() && !condition.isRequired()) continue;
            if (!(this.joinSize <= 0 || (chk = txt.toLowerCase().trim()).startsWith("and ") || chk.startsWith("or ") || chk.startsWith("and(") || chk.startsWith("or("))) {
                subBuilder.append(condition.getJoin());
            }
            subBuilder.append(" ").append(txt);
            this.addRunValue(values);
            ++this.joinSize;
        }
        if (this.joinSize > 0) {
            StringBuilder builder = new StringBuilder();
            if (!this.hasContainer() || this.getContainerJoinSize() > 0) {
                builder.append("\nAND");
            } else {
                builder.append("\n\t");
            }
            builder.append("(");
            builder.append(subBuilder.toString());
            builder.append(")\n\t");
            return builder.toString();
        }
        return "";
    }

    @Override
    public Condition setRunText(String text) {
        this.text = text;
        return this;
    }

    private int getContainerJoinSize() {
        if (this.hasContainer()) {
            return this.getContainer().getJoinSize();
        }
        return 0;
    }

    public String toString() {
        int size = this.conditions.size();
        String txt = "[";
        for (int i = 0; i < size; ++i) {
            txt = i == 0 ? txt + ((Condition)this.conditions.get(i)).toString() : txt + "," + ((Condition)this.conditions.get(i)).toString();
        }
        txt = txt + "]";
        return txt;
    }
}

