/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.jdbc.run;

import java.util.List;
import org.anyline.entity.Order;
import org.anyline.entity.OrderStore;
import org.anyline.entity.OrderStoreImpl;
import org.anyline.entity.PageNavi;
import org.anyline.jdbc.adapter.JDBCAdapter;
import org.anyline.jdbc.param.ConfigStore;
import org.anyline.jdbc.prepare.Condition;
import org.anyline.jdbc.prepare.ConditionChain;
import org.anyline.jdbc.prepare.RunPrepare;
import org.anyline.jdbc.prepare.auto.init.SimpleAutoConditionChain;
import org.anyline.jdbc.run.BasicRun;
import org.anyline.jdbc.run.Run;
import org.anyline.jdbc.run.RunValue;
import org.anyline.util.BasicUtil;

public class TableRun
extends BasicRun
implements Run {
    public TableRun(JDBCAdapter adapter, String table) {
        this.builder = new StringBuilder();
        this.conditionChain = new SimpleAutoConditionChain();
        this.orderStore = new OrderStoreImpl();
        this.table = table;
        this.adapter = adapter;
    }

    private void parseDataSource() {
        if (null != this.prepare) {
            this.table = this.prepare.getTable();
        }
        this.table = this.table.replace(this.delimiterFr, "").replace(this.delimiterTo, "");
        if (this.table.contains(".")) {
            this.schema = this.table.substring(0, this.table.indexOf("."));
            this.table = this.table.substring(this.table.indexOf(".") + 1);
        } else if (null != this.prepare && BasicUtil.isNotEmpty((Object)this.prepare.getSchema())) {
            this.schema = this.prepare.getSchema();
        }
    }

    @Override
    public void init() {
        super.init();
        this.parseDataSource();
        if (null != this.configStore) {
            PageNavi navi;
            List orders;
            OrderStore orderStore;
            ConditionChain chain = this.configStore.getConfigChain().createAutoConditionChain();
            if (null != chain) {
                for (Condition condition : chain.getConditions()) {
                    this.addCondition(condition);
                }
            }
            if (null != (orderStore = this.configStore.getOrders()) && null != (orders = orderStore.getOrders())) {
                for (Order order : orders) {
                    this.orderStore.order(order);
                }
            }
            if ((navi = this.configStore.getPageNavi()) != null) {
                this.pageNavi = navi;
            }
        }
    }

    public void appendOrderStore() {
    }

    public void appendGroup() {
        if (null != this.groupStore) {
            this.builder.append(this.groupStore.getRunText(this.delimiterFr + this.delimiterTo));
        }
        if (BasicUtil.isNotEmpty((Object)this.having)) {
            this.builder.append(" HAVING ").append(this.having);
        }
    }

    public void checkValid() {
        if (null != this.conditionChain && !this.conditionChain.isValid()) {
            this.valid = false;
        }
    }

    public void appendCondition() {
        if (null == this.conditionChain) {
            return;
        }
        String alias = null;
        if (null != this.prepare) {
            alias = this.prepare.getAlias();
        }
        this.builder.append(this.conditionChain.getRunText(alias, this.adapter));
        List<RunValue> values = this.conditionChain.getRunValues();
        this.addValues(values);
    }

    public void setConfigs(ConfigStore configs) {
        this.configStore = configs;
        if (null != configs) {
            this.pageNavi = configs.getPageNavi();
        }
    }

    @Override
    public Run setConditionValue(boolean required, boolean strictRequired, String condition, String variable, Object value, RunPrepare.COMPARE_TYPE compare) {
        return this;
    }

    @Override
    public Run setConditionValue(boolean required, String condition, String variable, Object value, RunPrepare.COMPARE_TYPE compare) {
        return this.setConditionValue(required, false, condition, variable, value, compare);
    }
}

