/*
 * Decompiled with CFR 0.152.
 */
package org.anyline.nacos.util;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.anyline.nacos.util.NacosConfig;
import org.anyline.util.AnylineConfig;
import org.anyline.util.BasicUtil;
import org.anyline.util.BeanUtil;
import org.anyline.util.ClassUtil;
import org.anyline.util.ConfigTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NacosUtil {
    private static Logger log = LoggerFactory.getLogger(NacosUtil.class);
    private NacosConfig config = null;
    private static Hashtable<String, NacosUtil> instances = new Hashtable();

    public static Hashtable<String, NacosUtil> getInstances() {
        return instances;
    }

    public void scan() {
        if (null == this.config) {
            return;
        }
        Listener listener = new Listener(){

            public void receiveConfigInfo(String content) {
                log.warn("[nacos reload config][group:{}][namespace:{}][data:{}][class:{}]", new Object[]{((NacosUtil)NacosUtil.this).config.GROUP, ((NacosUtil)NacosUtil.this).config.NAMESPACE, ConfigTable.CONFIG_NAME, ConfigTable.class.getSimpleName()});
                ConfigTable.parse((String)content);
            }

            public Executor getExecutor() {
                return null;
            }
        };
        try {
            this.config(null, ConfigTable.CONFIG_NAME, listener);
        }
        catch (Exception e) {
            log.warn("[nacos config][result:false][group:{}][namespace:{}][class:{}][msg:{}]", new Object[]{this.config.GROUP, this.config.NAMESPACE, ConfigTable.class.getSimpleName(), e.toString()});
        }
        Map listenerFiles = AnylineConfig.getListeners();
        for (Map.Entry item : listenerFiles.entrySet()) {
            String[] file = new File((String)item.getKey());
            Map params = (Map)item.getValue();
            Class clazz = (Class)params.get("CLAZZ");
            Hashtable instances = (Hashtable)params.get("INSTANCES");
            String[] compatibles = (String[])params.get("COMPATIBLES");
            try {
                this.config(null, file.getName(), clazz);
            }
            catch (NacosException e) {
                log.warn("[nacos config][result:false][class:{}][msg:{}]", (Object)clazz.getSimpleName(), (Object)e.toString());
            }
        }
        if (this.config.AUTO_SCAN) {
            String cls;
            String[] pks;
            String packages = this.config.SCAN_PACKAGE;
            if (BasicUtil.isNotEmpty((Object)packages) && null != (pks = packages.split(","))) {
                for (String pk : pks) {
                    List list = ClassUtil.list((String)pk, (boolean)true, (Class[])new Class[]{AnylineConfig.class, ConfigTable.class});
                    Iterator e = list.iterator();
                    while (e.hasNext()) {
                        Class clazz;
                        Class configClass = clazz = (Class)e.next();
                        String configName = (String)BeanUtil.getFieldValue((Object)clazz, (String)"CONFIG_NAME");
                        try {
                            this.config(null, configName, configClass);
                        }
                        catch (NacosException e2) {
                            log.warn("[nacos config][result:false][package:{}][msg:{}]", (Object)pk, (Object)configName);
                        }
                    }
                }
            }
            if (BasicUtil.isNotEmpty((Object)(cls = this.config.SCAN_CLASS))) {
                String[] clas;
                for (String c : clas = cls.split(",")) {
                    Class<?> clazz = null;
                    try {
                        Class<?> configClass = clazz = Class.forName(c);
                        String configName = (String)BeanUtil.getFieldValue(clazz, (String)"CONFIG_NAME");
                        this.config(null, configName, configClass);
                    }
                    catch (Exception e) {
                        log.warn("[nacos config][result:false][class:{}][msg:{}]", (Object)c, (Object)e.toString());
                    }
                }
            }
        }
    }

    public static NacosUtil getInstance() {
        return NacosUtil.getInstance("default");
    }

    public static NacosUtil getInstance(String key) {
        NacosUtil util;
        if (BasicUtil.isEmpty((Object)key)) {
            key = "default";
        }
        if (null == (util = instances.get(key))) {
            util = new NacosUtil();
            NacosConfig config = NacosConfig.getInstance(key);
            if (null != config) {
                util.config = config;
                instances.put(key, util);
            }
        }
        return util;
    }

    public String config(String group, String data, final Class<? extends AnylineConfig> T) throws NacosException {
        if (BasicUtil.isEmpty((Object)group)) {
            group = this.config.GROUP;
        }
        log.warn("[nacos config][group:{}][data:{}][class:{}]", new Object[]{group, data, T.getName()});
        final String gp = group;
        final String dt = data;
        Listener listener = new Listener(){

            public void receiveConfigInfo(String content) {
                log.warn("[nacos reload config][group:{}][data:{}][class:{}]", new Object[]{gp, dt, T.getName()});
                NacosUtil.parse(T, content);
            }

            public Executor getExecutor() {
                return null;
            }
        };
        String config = this.config(group, data, listener);
        NacosUtil.parse(T, config);
        return config;
    }

    public String config(String group, String data, Listener listener) throws NacosException {
        if (BasicUtil.isEmpty((Object)group)) {
            group = this.config.GROUP;
        }
        log.warn("[nacos config][group:{}][namespace:{}][data:{}][listener:{}]", new Object[]{group, this.config.NAMESPACE, data, listener});
        Properties properties = new Properties();
        properties.put("namespace", this.config.NAMESPACE);
        String adr = this.config.ADDRESS;
        if (!adr.contains(":") && this.config.PORT > 0) {
            adr = adr + ":" + this.config.PORT;
        }
        properties.put("serverAddr", adr);
        ConfigService configService = NacosFactory.createConfigService((Properties)properties);
        String content = configService.getConfig(data, group, (long)this.config.TIMEOUT);
        if (null != listener) {
            configService.addListener(data, group, listener);
        }
        return content;
    }

    public String config(String data) {
        try {
            Listener listener = null;
            return this.config(null, data, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String config(String group, String data) {
        try {
            Listener listener = null;
            return this.config(group, data, listener);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void parse(Class<? extends AnylineConfig> T, String content) {
        if (BasicUtil.isEmpty((Object)content)) {
            log.warn("[nacos config][pull fail][config class:{}]", (Object)T.getSimpleName());
            return;
        }
        try {
            Class<?> clazz = Class.forName(T.getName());
            Method method = clazz.getMethod("parse", String.class);
            method.invoke(null, content);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        Hashtable<String, AnylineConfig> configs = NacosConfig.getInstances();
        for (String key : configs.keySet()) {
            NacosUtil instance = NacosUtil.getInstance(key);
            if (null == instance) continue;
            instances.put(key, instance);
            instance.scan();
        }
    }
}

