/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.cache;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Manage;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.cache.magic.AbstractReader;
import org.aoju.bus.cache.magic.AnnoHolder;
import org.aoju.bus.cache.magic.CachePair;
import org.aoju.bus.cache.magic.MethodHolder;
import org.aoju.bus.cache.support.ArgNameGenerator;
import org.aoju.bus.cache.support.CacheInfoContainer;
import org.aoju.bus.cache.support.KeyGenerator;
import org.aoju.bus.cache.support.SpelCalculator;
import org.aoju.bus.core.annotation.Inject;
import org.aoju.bus.core.annotation.Named;
import org.aoju.bus.core.annotation.Singleton;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.proxy.invoker.ProxyChain;

@Singleton
public class Complex {
    @Inject
    private Context config;
    @Inject
    private Manage cacheManager;
    @Inject
    @Named(value="singleCacheReader")
    private AbstractReader singleCacheReader;
    @Inject
    @Named(value="multiCacheReader")
    private AbstractReader multiCacheReader;

    public static boolean isSwitchOn(Context config, Cached cached, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == Context.Switch.ON, cached.expire(), cached.condition(), method, args);
    }

    public static boolean isSwitchOn(Context config, Invalid invalid, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == Context.Switch.ON, 0, invalid.condition(), method, args);
    }

    public static boolean isSwitchOn(Context config, CachedGet cachedGet, Method method, Object[] args) {
        return Complex.doIsSwitchOn(config.getCache() == Context.Switch.ON, 0, cachedGet.condition(), method, args);
    }

    private static boolean doIsSwitchOn(boolean openStat, int expire, String condition, Method method, Object[] args) {
        if (!openStat) {
            return false;
        }
        if (expire == -1) {
            return false;
        }
        return (Boolean)SpelCalculator.calcSpelValueWithContext(condition, ArgNameGenerator.getArgNames(method), args, true);
    }

    public Object read(CachedGet cachedGet, Method method, ProxyChain baseInvoker) throws Throwable {
        Object result = Complex.isSwitchOn(this.config, cachedGet, method, baseInvoker.getArguments()) ? this.doReadWrite(method, baseInvoker, false) : baseInvoker.proceed();
        return result;
    }

    public Object readWrite(Cached cached, Method method, ProxyChain baseInvoker) throws Throwable {
        Object result = Complex.isSwitchOn(this.config, cached, method, baseInvoker.getArguments()) ? this.doReadWrite(method, baseInvoker, true) : baseInvoker.proceed();
        return result;
    }

    public void remove(Invalid invalid, Method method, Object[] args) {
        if (Complex.isSwitchOn(this.config, invalid, method, args)) {
            long start = System.currentTimeMillis();
            AnnoHolder annoHolder = CacheInfoContainer.getCacheInfo(method).getLeft();
            if (annoHolder.isMulti()) {
                Map[] pair = KeyGenerator.generateMultiKey(annoHolder, args);
                Set keys = pair[1].keySet();
                this.cacheManager.remove(invalid.value(), keys.toArray(new String[keys.size()]));
                Logger.info("multi cache clear, keys: {}", keys);
            } else {
                String key = KeyGenerator.generateSingleKey(annoHolder, args);
                this.cacheManager.remove(invalid.value(), key);
                Logger.info("single cache clear, key: {}", key);
            }
            Logger.debug("cache clear total cost [{}] ms", System.currentTimeMillis() - start);
        }
    }

    private Object doReadWrite(Method method, ProxyChain baseInvoker, boolean needWrite) throws Throwable {
        long start = System.currentTimeMillis();
        CachePair<AnnoHolder, MethodHolder> pair = CacheInfoContainer.getCacheInfo(method);
        AnnoHolder annoHolder = pair.getLeft();
        MethodHolder methodHolder = pair.getRight();
        Object result = annoHolder.isMulti() ? this.multiCacheReader.read(annoHolder, methodHolder, baseInvoker, needWrite) : this.singleCacheReader.read(annoHolder, methodHolder, baseInvoker, needWrite);
        Logger.debug("cache read total cost [{}] ms", System.currentTimeMillis() - start);
        return result;
    }

    public void write() {
    }
}

