/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.date;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.MonthDay;
import java.time.ZoneId;
import java.time.chrono.Era;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.SimpleTimeZone;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import org.aoju.bus.core.convert.NumberFormatter;
import org.aoju.bus.core.date.Almanac;
import org.aoju.bus.core.date.Converter;
import org.aoju.bus.core.date.DateTime;
import org.aoju.bus.core.date.formatter.DatePeriod;
import org.aoju.bus.core.date.formatter.DatePrinter;
import org.aoju.bus.core.date.formatter.parser.CSTDateParser;
import org.aoju.bus.core.date.formatter.parser.FastDateParser;
import org.aoju.bus.core.date.formatter.parser.FastTimeParser;
import org.aoju.bus.core.date.formatter.parser.NormalDateParser;
import org.aoju.bus.core.date.formatter.parser.PositionDateParser;
import org.aoju.bus.core.date.formatter.parser.PureDateParser;
import org.aoju.bus.core.date.formatter.parser.UTCDateParser;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Fields;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Formatter {
    public static String format(Date date) {
        if (null != date) {
            return Fields.NORM_DATETIME_FORMAT.format(date);
        }
        return "";
    }

    public static String format(Date date, String format) {
        TimeZone timeZone;
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (date instanceof DateTime && null != (timeZone = ((DateTime)date).getTimeZone())) {
            sdf.setTimeZone(timeZone);
        }
        return Formatter.format(date, sdf);
    }

    public static String format(Date date, DatePrinter format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateFormat format) {
        if (null == format || null == date) {
            return null;
        }
        return format.format(date);
    }

    public static String format(Date date, DateTimeFormatter format) {
        if (null == format || null == date) {
            return null;
        }
        return Formatter.format((TemporalAccessor)date.toInstant(), format);
    }

    public static String format(Date date, String format, String timeZone) {
        if (null == date || StringKit.isBlank(format)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        if (null != timeZone) {
            sdf.setTimeZone(new SimpleTimeZone(0, timeZone));
        }
        return Formatter.format(date, sdf);
    }

    public static String format(String text, String srcPattern, String destPattern) {
        try {
            SimpleDateFormat srcSdf = new SimpleDateFormat(srcPattern);
            SimpleDateFormat dstSdf = new SimpleDateFormat(destPattern);
            return dstSdf.format(srcSdf.parse(text));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public static long format(String text) {
        try {
            return Fields.NORM_DATETIME_FORMAT.parse(text).getTime();
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
    }

    public static String format(long timestamp) {
        return Fields.NORM_DATETIME_FORMAT.format(new Date(timestamp));
    }

    public static String format(long timestamp, String format) {
        return new SimpleDateFormat(format).format(new Date(timestamp));
    }

    public static long format(String text, String format) {
        try {
            return new SimpleDateFormat(format).parse(text).getTime();
        }
        catch (ParseException e) {
            throw new InternalException(e);
        }
    }

    public static String format(LocalDateTime localDateTime) {
        return Formatter.format(localDateTime, "yyyy-MM-dd HH:mm:ss");
    }

    public static String format(LocalDateTime localDateTime, String format) {
        if (null == localDateTime || StringKit.isBlank(format)) {
            return null;
        }
        DateTimeFormatter df = DateTimeFormatter.ofPattern(format);
        return localDateTime.format(df);
    }

    public static String format(TemporalAccessor time, DateTimeFormatter formatter) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (null == formatter) {
            formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;
        }
        try {
            return formatter.format(time);
        }
        catch (UnsupportedTemporalTypeException e) {
            if (time instanceof LocalDate && e.getMessage().contains("HourOfDay")) {
                return formatter.format(((LocalDate)time).atStartOfDay());
            }
            if (time instanceof LocalTime && e.getMessage().contains("YearOfEra")) {
                return formatter.format(((LocalTime)time).atDate(LocalDate.now()));
            }
            if (time instanceof Instant) {
                return formatter.format(((Instant)time).atZone(ZoneId.systemDefault()));
            }
            throw e;
        }
    }

    public static String format(TemporalAccessor time, String format) {
        if (null == time) {
            return null;
        }
        if (time instanceof Month) {
            return time.toString();
        }
        if (time instanceof DayOfWeek || time instanceof Month || time instanceof Era || time instanceof MonthDay) {
            return time.toString();
        }
        DateTimeFormatter formatter = StringKit.isBlank(format) ? null : DateTimeFormatter.ofPattern(format);
        return Formatter.format(time, formatter);
    }

    public static String format(Date date, boolean isUppercase, boolean withTime) {
        if (null == date) {
            return null;
        }
        if (!isUppercase) {
            return (withTime ? Fields.NORM_CN_DATE_TIME_FORMAT : Fields.NORM_DATE_CN_FORMAT).format(date);
        }
        return Formatter.format(Converter.toCalendar(date), withTime);
    }

    public static String format(Calendar calendar, boolean withTime) {
        StringBuilder result = StringKit.builder();
        String year = String.valueOf(calendar.get(1));
        int length = year.length();
        for (int i = 0; i < length; ++i) {
            result.append(NumberFormatter.Chinese.numberCharToChinese(year.charAt(i), false));
        }
        result.append('\u5e74');
        int month = calendar.get(2) + 1;
        result.append(NumberFormatter.Chinese.formatThousand(month, false));
        result.append('\u6708');
        int day = calendar.get(5);
        result.append(NumberFormatter.Chinese.formatThousand(day, false));
        result.append('\u65e5');
        String temp = result.toString().replace('\u96f6', '\u3007');
        result.delete(0, result.length());
        result.append(temp);
        if (withTime) {
            int hour = calendar.get(11);
            result.append(NumberFormatter.Chinese.formatThousand(hour, false));
            result.append('\u65f6');
            int minute = calendar.get(12);
            result.append(NumberFormatter.Chinese.formatThousand(minute, false));
            result.append('\u5206');
            int second = calendar.get(13);
            result.append(NumberFormatter.Chinese.formatThousand(second, false));
            result.append('\u79d2');
        }
        return result.toString().replace('\u96f6', '\u3007');
    }

    public static String formatDate(Date date) {
        return Formatter.formatDate(date, false);
    }

    public static String formatDate(Date date, boolean isHttp) {
        if (null == date) {
            return null;
        }
        if (isHttp) {
            return Fields.HTTP_DATETIME_FORMAT.format(date);
        }
        return Fields.NORM_DATE_FORMAT.format(date);
    }

    public static String formatTime(Date date) {
        if (null == date) {
            return null;
        }
        return Fields.NORM_TIME_FORMAT.format(date);
    }

    public static String formatBetween(Date beginDate, Date endDate, Fields.Units units) {
        return Formatter.formatBetween(Almanac.between(beginDate, endDate, Fields.Units.MILLISECOND), units);
    }

    public static String formatBetween(Date beginDate, Date endDate) {
        return Formatter.formatBetween(Almanac.between(beginDate, endDate, Fields.Units.MILLISECOND));
    }

    public static String formatBetween(long betweenMs, Fields.Units units) {
        return new DatePeriod(betweenMs, units).format();
    }

    public static String formatBetween(long betweenMs) {
        return new DatePeriod(betweenMs, Fields.Units.MILLISECOND).format();
    }

    public static DateTime parse(CharSequence text, DateFormat dateFormat) {
        return new DateTime(text, dateFormat);
    }

    public static DateTime parse(CharSequence text, PositionDateParser parser) {
        return new DateTime(text, parser);
    }

    public static DateTime parse(CharSequence text, PositionDateParser parser, boolean lenient) {
        return new DateTime(text, parser, lenient);
    }

    public static DateTime parse(CharSequence text, DateTimeFormatter formatter) {
        return new DateTime(text, formatter);
    }

    public static DateTime parse(CharSequence text, String format) {
        return new DateTime(text, format);
    }

    public static DateTime parse(CharSequence text, String format, Locale locale) {
        return new DateTime(text, Formatter.newSimpleFormat(format, locale, null));
    }

    public static DateTime parse(String text, String ... format) throws InternalException {
        return new DateTime(Formatter.parseByPatterns(text, format));
    }

    public static DateTime parse(CharSequence text) {
        if (StringKit.isBlank(text)) {
            return null;
        }
        String dateText = text.toString();
        if (MathKit.isNumber(dateText = StringKit.removeAll((CharSequence)dateText.trim(), '\u65e5', '\u79d2'))) {
            return PureDateParser.INSTANCE.parse(dateText);
        }
        if (PatternKit.isMatch(RegEx.TIME, (CharSequence)dateText)) {
            return FastTimeParser.INSTANCE.parse(dateText);
        }
        if (StringKit.containsAnyIgnoreCase(dateText, Fields.WTB)) {
            return CSTDateParser.INSTANCE.parse(dateText);
        }
        if (StringKit.contains((CharSequence)dateText, 'T')) {
            return UTCDateParser.INSTANCE.parse(dateText);
        }
        if (PatternKit.isMatch(Fields.REGEX_NORM, (CharSequence)(dateText = Formatter.normalize(dateText)))) {
            return NormalDateParser.INSTANCE.parse(dateText);
        }
        throw new InternalException("No format fit for date String [{}] !", dateText);
    }

    public static Calendar parseByPatterns(String text, String ... pattern) {
        return Formatter.parseByPatterns(text, null, pattern);
    }

    public static Calendar parseByPatterns(String text, Locale locale, String ... pattern) {
        return Formatter.parseByPatterns(text, locale, true, pattern);
    }

    public static Calendar parseByPatterns(CharSequence text, boolean lenient, PositionDateParser parser) {
        Calendar calendar = Calendar.getInstance(parser.getTimeZone(), parser.getLocale());
        calendar.clear();
        calendar.setLenient(lenient);
        return parser.parse(StringKit.toString(text), new ParsePosition(0), calendar) ? calendar : null;
    }

    public static Calendar parseByPatterns(String text, Locale locale, boolean lenient, String ... pattern) {
        if (null == text || null == pattern) {
            throw new IllegalArgumentException("Date and Patterns must not be null");
        }
        TimeZone tz = TimeZone.getDefault();
        Locale lcl = ObjectKit.defaultIfNull(locale, Locale.getDefault());
        ParsePosition pos = new ParsePosition(0);
        Calendar calendar = Calendar.getInstance(tz, lcl);
        calendar.setLenient(lenient);
        for (String parsePattern : pattern) {
            FastDateParser fdp = new FastDateParser(parsePattern, tz, lcl);
            calendar.clear();
            try {
                if (fdp.parse(text, pos, calendar) && pos.getIndex() == text.length()) {
                    return calendar;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            pos.setIndex(0);
        }
        throw new InternalException("Unable to parse the date: {}", text);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern) {
        return Formatter.newSimpleFormat(pattern, null, null);
    }

    public static SimpleDateFormat newSimpleFormat(String pattern, Locale locale, TimeZone timeZone) {
        if (null == locale) {
            locale = Locale.getDefault(Locale.Category.FORMAT);
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
        if (null != timeZone) {
            format.setTimeZone(timeZone);
        }
        format.setLenient(false);
        return format;
    }

    public static String getShotName(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return "ns";
            }
            case MICROSECONDS: {
                return "\u03bcs";
            }
            case MILLISECONDS: {
                return "ms";
            }
            case SECONDS: {
                return "s";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "h";
            }
        }
        return unit.name().toLowerCase();
    }

    private static String normalize(CharSequence text) {
        if (StringKit.isBlank(text)) {
            return StringKit.toString(text);
        }
        List<String> dateAndTime = StringKit.splitTrim(text, ' ');
        int size = dateAndTime.size();
        if (size < 1 || size > 2) {
            return StringKit.toString(text);
        }
        StringBuilder builder = StringKit.builder();
        String datePart = dateAndTime.get(0).replaceAll("[/.\u5e74\u6708]", "-");
        datePart = StringKit.removeSuffix(datePart, "\u65e5");
        builder.append(datePart);
        if (size == 2) {
            builder.append(' ');
            String timePart = dateAndTime.get(1).replaceAll("[\u65f6\u5206\u79d2]", ":");
            timePart = StringKit.removeSuffix(timePart, ":");
            timePart = timePart.replace(',', '.');
            builder.append(timePart);
        }
        return builder.toString();
    }
}

