/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.image.element;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.font.TextAttribute;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.image.element.AbstractElement;
import org.aoju.bus.core.lang.Scale;
import org.aoju.bus.core.lang.Validator;
import org.aoju.bus.core.toolkit.StringKit;

public class TextElement
extends AbstractElement<TextElement> {
    private String text;
    private Font font;
    private Float space;
    private boolean strikeThrough;
    private Color color = new Color(0, 0, 0);
    private boolean autoBreakLine = false;
    private int maxLineWidth = 600;
    private int maxLineCount = 2;
    private Integer lineHeight;
    private Integer rotate;
    private Integer width;
    private Integer height;
    private Integer drawY;
    private Scale.Align align = Scale.Align.LEFT;
    private List<TextElement> breakLineElements;

    public TextElement(String text, Font font, int x, int y) {
        this.text = text;
        this.font = font;
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font("\u963f\u91cc\u5df4\u5df4\u666e\u60e0\u4f53", 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public TextElement(String text, String fontName, int fontSize, int x, int y) {
        this.text = text;
        this.font = new Font(fontName, 0, fontSize);
        super.setX(x);
        super.setY(y);
    }

    public Integer getWidth() {
        if (this.width == null) {
            this.width = this.getFrontWidth(this.text);
        }
        return this.width;
    }

    public Integer getHeight() {
        if (this.height == null) {
            this.height = this.autoBreakLine ? Integer.valueOf(this.getLineHeight() * this.getBreakLineElements().size()) : this.getLineHeight();
        }
        return this.height;
    }

    public Integer getDrawY() {
        if (this.drawY == null) {
            this.drawY = this.getY() + (this.getLineHeight() - this.getHeight()) / 2;
        }
        return this.drawY;
    }

    public List<TextElement> getBreakLineElements() {
        if (this.breakLineElements == null) {
            this.breakLineElements = this.computeBreakLineElements();
        }
        return this.breakLineElements;
    }

    @Override
    public TextElement setY(int y) {
        this.resetProperties();
        return (TextElement)super.setY(y);
    }

    public String getText() {
        return this.text;
    }

    public TextElement setText(String text) {
        this.resetProperties();
        this.text = text;
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public TextElement setFont(Font font) {
        this.resetProperties();
        this.font = font;
        return this;
    }

    public Float getSpace() {
        return this.space;
    }

    public TextElement setSpace(Float space) {
        HashMap<TextAttribute, Float> attributes = new HashMap<TextAttribute, Float>();
        attributes.put(TextAttribute.TRACKING, space);
        Font font2 = this.font.deriveFont(attributes);
        this.setFont(font2);
        return this;
    }

    public Integer getRotate() {
        return this.rotate;
    }

    public TextElement setRotate(Integer rotate) {
        this.rotate = rotate;
        return this;
    }

    public Color getColor() {
        return this.color;
    }

    public TextElement setColor(Color color) {
        this.color = color;
        return this;
    }

    public TextElement setColor(int r, int g, int b) {
        return this.setColor(new Color(r, g, b));
    }

    public Integer getLineHeight() {
        if (this.lineHeight == null) {
            this.lineHeight = this.getHeight();
        }
        return this.lineHeight;
    }

    public TextElement setLineHeight(Integer lineHeight) {
        this.resetProperties();
        this.lineHeight = lineHeight;
        return this;
    }

    public boolean isStrikeThrough() {
        return this.strikeThrough;
    }

    public TextElement setStrikeThrough(boolean strikeThrough) {
        this.strikeThrough = strikeThrough;
        return this;
    }

    public boolean isAutoBreakLine() {
        return this.autoBreakLine;
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount, int lineHeight) {
        this.autoBreakLine = true;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        this.lineHeight = lineHeight;
        return this;
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount) {
        this.autoBreakLine = true;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        return this;
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount, int lineHeight, Scale.Align align) {
        this.autoBreakLine = true;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        this.lineHeight = lineHeight;
        this.align = align;
        return this;
    }

    public TextElement setAutoBreakLine(int maxLineWidth, int maxLineCount, Scale.Align align) {
        this.autoBreakLine = true;
        this.maxLineWidth = maxLineWidth;
        this.maxLineCount = maxLineCount;
        this.align = align;
        return this;
    }

    public Scale.Align getAlign() {
        return this.align;
    }

    private void resetProperties() {
        this.width = null;
        this.height = null;
        this.drawY = null;
        this.breakLineElements = null;
    }

    private List<TextElement> computeBreakLineElements() {
        ArrayList<TextElement> breakLineElements = new ArrayList<TextElement>();
        List<String> breakLineTexts = this.computeLines(this.text);
        int currentY = this.getY();
        for (int i = 0; i < breakLineTexts.size() && i < this.maxLineCount; ++i) {
            Object text = breakLineTexts.get(i);
            if (i == this.maxLineCount - 1 && i < breakLineTexts.size() - 1) {
                text = ((String)text).substring(0, ((String)text).length() - 1) + "...";
            }
            TextElement textLineElement = new TextElement((String)text, this.font, this.getX(), currentY);
            textLineElement.setColor(this.color);
            textLineElement.setStrikeThrough(this.strikeThrough);
            textLineElement.setCenter(this.isCenter());
            textLineElement.setAlpha(this.getAlpha());
            textLineElement.setRotate(this.rotate);
            textLineElement.setLineHeight(this.getLineHeight());
            textLineElement.setDirection(this.getDirection());
            breakLineElements.add(textLineElement);
            currentY += this.getLineHeight().intValue();
        }
        return breakLineElements;
    }

    private List<String> computeLines(String text) {
        ArrayList<String> computedLines = new ArrayList<String>();
        Object strToComputer = "";
        Object word = "";
        boolean hasWord = false;
        char[] chars = text.toCharArray();
        int count = 0;
        for (int i = 0; i < chars.length && count++ <= 2000; ++i) {
            char c = chars[i];
            if (Validator.isChinese(StringKit.toString(c)) || c == ' ' || i == chars.length - 1) {
                word = (String)word + c;
                hasWord = true;
            } else {
                word = (String)word + c;
            }
            if (!hasWord) continue;
            int originWidth = this.getFrontWidth((String)strToComputer);
            int wordWidth = this.getFrontWidth((String)word);
            strToComputer = (String)strToComputer + (String)word;
            int newWidth = originWidth + wordWidth;
            if (wordWidth > this.maxLineWidth) {
                int fetch = (int)((float)(this.maxLineWidth - originWidth) / (float)wordWidth * (float)((String)word).length());
                strToComputer = ((String)strToComputer).substring(0, ((String)strToComputer).length() - ((String)word).length() + fetch);
                computedLines.add((String)strToComputer);
                strToComputer = "";
                i -= ((String)word).length() - fetch;
            } else if (newWidth > this.maxLineWidth) {
                strToComputer = ((String)strToComputer).substring(0, ((String)strToComputer).length() - ((String)word).length());
                computedLines.add((String)strToComputer);
                strToComputer = "";
                i -= ((String)word).length();
            }
            word = "";
            hasWord = false;
        }
        if (strToComputer != "") {
            computedLines.add((String)strToComputer);
        }
        return computedLines;
    }

    public int getFrontWidth(String text) {
        BufferedImage image = new BufferedImage(1, 1, 2);
        FontMetrics metrics = image.createGraphics().getFontMetrics(this.font);
        int width = 0;
        for (int i = 0; i < text.length(); ++i) {
            width += metrics.charWidth(text.charAt(i));
        }
        return width;
    }
}

