/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.sink;

import java.io.IOException;
import org.aoju.bus.core.io.buffer.Buffer;
import org.aoju.bus.core.io.sink.AssignSink;
import org.aoju.bus.core.io.sink.Sink;

public class FaultHideSink
extends AssignSink {
    private boolean hasErrors;

    public FaultHideSink(Sink delegate) {
        super(delegate);
    }

    @Override
    public void write(Buffer source, long byteCount) throws IOException {
        if (this.hasErrors) {
            source.skip(byteCount);
            return;
        }
        try {
            super.write(source, byteCount);
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.flush();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.hasErrors) {
            return;
        }
        try {
            super.close();
        }
        catch (IOException e) {
            this.hasErrors = true;
            this.onException(e);
        }
    }

    protected void onException(IOException e) {
    }
}

