/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.io.stream;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.IoKit;

public class StreamWriter {
    private final OutputStream out;
    private final boolean closeAfterWrite;

    public StreamWriter(OutputStream out, boolean closeAfterWrite) {
        this.out = out;
        this.closeAfterWrite = closeAfterWrite;
    }

    public static StreamWriter of(OutputStream out, boolean closeAfterWrite) {
        return new StreamWriter(out, closeAfterWrite);
    }

    public void write(byte[] content) throws InternalException {
        OutputStream out = this.out;
        try {
            out.write(content);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            if (this.closeAfterWrite) {
                IoKit.close(out);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeObject(Object ... contents) throws InternalException {
        ObjectOutputStream osw = null;
        try {
            osw = this.out instanceof ObjectOutputStream ? (ObjectOutputStream)this.out : new ObjectOutputStream(this.out);
            for (Object content : contents) {
                if (content == null) continue;
                osw.writeObject(content);
            }
            osw.flush();
            if (!this.closeAfterWrite) return;
        }
        catch (IOException e) {
            try {
                throw new InternalException(e);
            }
            catch (Throwable throwable) {
                if (!this.closeAfterWrite) throw throwable;
                IoKit.close(osw);
                throw throwable;
            }
        }
        IoKit.close(osw);
        return;
    }

    public void writeString(Charset charset, Object ... contents) throws InternalException {
        OutputStreamWriter osw = null;
        try {
            osw = IoKit.getWriter(this.out, charset);
            for (Object content : contents) {
                if (content == null) continue;
                osw.write(Convert.toString(content, ""));
            }
            osw.flush();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            if (this.closeAfterWrite) {
                IoKit.close(osw);
            }
        }
    }
}

