/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.lang.reflect.Method;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.atomic.AtomicLong;
import org.aoju.bus.core.lang.Console;

public class Job
implements Runnable {
    private final Object target;
    private final Method method;
    private final AtomicLong runCount = new AtomicLong();
    private TYPE type;
    private Long fixedDelay;
    private Long fixedRate;
    private Long initialDelay;
    private String cron;
    private Boolean async;
    private Instant startAt;

    public Job(Object target, Method method) {
        this.target = target;
        this.method = method;
    }

    public Job configFixedDelay(long fixedDelay, long initialDelay) {
        this.type = TYPE.FIXED_DELAY;
        this.fixedDelay = fixedDelay;
        this.initialDelay = initialDelay;
        return this;
    }

    public Job configFixedRate(long fixedRate, long initialDelay) {
        this.type = TYPE.FIXED_RATE;
        this.fixedRate = fixedRate;
        this.initialDelay = initialDelay;
        return this;
    }

    public Job configCron(String cron) {
        this.type = TYPE.CRON;
        this.cron = cron;
        return this;
    }

    public Job configOnApplicationStart(boolean async) {
        Job job = this;
        if (null != this.type) {
            job = new Job(this.target, this.method);
        }
        job.type = TYPE.ON_APPLICATION_START;
        job.async = async;
        return job;
    }

    @Override
    public void run() {
        try {
            this.startAt = Instant.now();
            this.method.invoke(this.target, new Object[0]);
        }
        catch (Exception e) {
            this.onException(e);
        }
        finally {
            this.onFinally();
        }
    }

    private void onException(Exception e) {
        Console.log("job [{}] execute error", this, e);
    }

    private void onFinally() {
        long count = this.runCount.incrementAndGet();
        Console.log("job [{}] elapsed time [{}], current rounds [{}]", this, Duration.between(this.startAt, Instant.now()).toMillis(), count);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.target.getClass().getName()).append("#").append(this.method.getName()).append("|").append((Object)this.type);
        if (this.type == TYPE.CRON) {
            sb.append("|").append(this.cron);
        } else if (this.type == TYPE.ON_APPLICATION_START) {
            sb.append('|').append(this.async);
        } else {
            if (this.type == TYPE.FIXED_DELAY) {
                sb.append("|").append(this.fixedDelay);
            } else if (this.type == TYPE.FIXED_RATE) {
                sb.append("|").append(this.fixedRate);
            }
            sb.append(',').append(this.initialDelay);
        }
        return sb.toString();
    }

    public static enum TYPE {
        FIXED_DELAY,
        FIXED_RATE,
        CRON,
        ON_APPLICATION_START;

    }
}

