/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.regex.Pattern;
import org.aoju.bus.core.exception.ValidateException;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.toolkit.CitizenIdKit;
import org.aoju.bus.core.toolkit.DateKit;
import org.aoju.bus.core.toolkit.LicenseKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.PatternKit;
import org.aoju.bus.core.toolkit.PhoneKit;
import org.aoju.bus.core.toolkit.StringKit;

public class Validator {
    public static boolean isNull(Object value) {
        return null == value;
    }

    public static <T> T validateNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNotNull(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return null;
    }

    public static boolean isNotNull(Object value) {
        return null != value;
    }

    public static <T> T validateNotNull(T value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isNull(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return value;
    }

    public static boolean isEmpty(Object value) {
        return null == value || value instanceof String && StringKit.isEmpty((String)value);
    }

    public static <T> T validateEmpty(T value, String errorMsg) throws ValidateException {
        if (Validator.isNotEmpty(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isNotEmpty(Object value) {
        return false == Validator.isEmpty(value);
    }

    public static <T> T validateNotEmpty(T value, String errorMsg) throws ValidateException {
        if (Validator.isEmpty(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isTrue(boolean value) {
        return value;
    }

    public static boolean validateTrue(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isFalse(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return true;
    }

    public static boolean isFalse(boolean value) {
        return false == value;
    }

    public static boolean validateFalse(boolean value, String errorMsgTemplate, Object ... params) throws ValidateException {
        if (Validator.isTrue(value)) {
            throw new ValidateException(errorMsgTemplate, params);
        }
        return false;
    }

    public static boolean equal(Object t1, Object t2) {
        return ObjectKit.equals(t1, t2);
    }

    public static Object validateEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (!Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
        return t1;
    }

    public static void validateNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        if (Validator.equal(t1, t2)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static void validateNotEmptyAndEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateEqual(t1, t2, errorMsg);
    }

    public static void validateNotEmptyAndNotEqual(Object t1, Object t2, String errorMsg) throws ValidateException {
        Validator.validateNotEmpty(t1, errorMsg);
        Validator.validateNotEqual(t1, t2, errorMsg);
    }

    public static boolean isUpperCase(CharSequence value) {
        return StringKit.isAllCharMatch(value, Character::isUpperCase);
    }

    public static <T extends CharSequence> T validateUpperCase(T value, String errorMsg) throws ValidateException {
        if (!Validator.isUpperCase(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isLowerCase(CharSequence value) {
        return StringKit.isAllCharMatch(value, Character::isLowerCase);
    }

    public static <T extends CharSequence> T validateLowerCase(T value, String errorMsg) throws ValidateException {
        if (!Validator.isLowerCase(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isLetter(CharSequence value) {
        return Validator.isMatchRegex("[a-zA-Z]+", value);
    }

    public static <T extends CharSequence> T validateLetter(T value, String errorMsg) throws ValidateException {
        if (!Validator.isLetter(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isLetterWithChinese(CharSequence value) {
        return StringKit.isAllCharMatch(value, Character::isLetter);
    }

    public static <T extends CharSequence> T validateLetterWithChinese(T value, String errorMsg) throws ValidateException {
        if (!Validator.isLetterWithChinese(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isNumber(CharSequence value) {
        return MathKit.isNumber(value);
    }

    public static String validateNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.isNumber(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean hasNumber(CharSequence value) {
        return PatternKit.contains("\\d+", value);
    }

    public static String validateHasNumber(String value, String errorMsg) throws ValidateException {
        if (!Validator.hasNumber(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isGeneral(CharSequence value) {
        return Validator.isMatchRegex(RegEx.GENERAL, value);
    }

    public static <T extends CharSequence> T validateGeneral(T value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isGeneral(CharSequence value, int min) {
        return Validator.isGeneral(value, min, 0);
    }

    public static <T extends CharSequence> T validateGeneral(T value, int min, String errorMsg) throws ValidateException {
        return Validator.validateGeneral(value, min, 0, errorMsg);
    }

    public static boolean isGeneral(CharSequence value, int min, int max) {
        if (min < 0) {
            min = 0;
        }
        String reg = "^\\w{" + min + "," + max + "}$";
        if (max <= 0) {
            reg = "^\\w{" + min + ",}$";
        }
        return Validator.isMatchRegex(reg, value);
    }

    public static <T extends CharSequence> T validateGeneral(T value, int min, int max, String errorMsg) throws ValidateException {
        if (!Validator.isGeneral(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isGeneralWithChinese(CharSequence value) {
        return Validator.isMatchRegex(RegEx.GENERAL_WITH_CHINESE, value);
    }

    public static <T extends CharSequence> T validateGeneralWithChinese(T value, String errorMsg) throws ValidateException {
        if (!Validator.isGeneralWithChinese(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isMoney(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MONEY, value);
    }

    public static <T extends CharSequence> T validateMoney(T value, String errorMsg) throws ValidateException {
        if (!Validator.isMoney(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isZipCode(CharSequence value) {
        return Validator.isMatchRegex(RegEx.ZIP_CODE, value);
    }

    public static <T extends CharSequence> T validateZipCode(T value, String errorMsg) throws ValidateException {
        if (!Validator.isZipCode(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isEmail(CharSequence value) {
        return Validator.isMatchRegex(RegEx.EMAIL, value);
    }

    public static <T extends CharSequence> T validateEmail(T value, String errorMsg) throws ValidateException {
        if (!Validator.isEmail(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isPhone(CharSequence value) {
        return PhoneKit.isPhone(value);
    }

    public static <T extends CharSequence> T validatePhone(T value, String errorMsg) throws ValidateException {
        if (!Validator.isPhone(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isMobile(CharSequence value) {
        return Validator.isMatchRegex(RegEx.MOBILE, value);
    }

    public static <T extends CharSequence> T validateMobile(T value, String errorMsg) throws ValidateException {
        if (!Validator.isMobile(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isCitizenId(CharSequence value) {
        return CitizenIdKit.isValidCard(String.valueOf(value));
    }

    public static <T extends CharSequence> T validateCitizenId(T value, String errorMsg) throws ValidateException {
        if (!Validator.isCitizenId(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isBirthday(CharSequence value) {
        return DateKit.isBirthday(value);
    }

    public static <T extends CharSequence> T validateBirthday(T value, String errorMsg) throws ValidateException {
        if (!Validator.isBirthday(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isIpv4(CharSequence value) {
        return Validator.isMatchRegex(RegEx.IPV4, value);
    }

    public static <T extends CharSequence> T validateIpv4(T value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv4(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isIpv6(CharSequence value) {
        return Validator.isMatchRegex(RegEx.IPV6, value);
    }

    public static <T extends CharSequence> T validateIpv6(T value, String errorMsg) throws ValidateException {
        if (!Validator.isIpv6(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isMac(CharSequence value) {
        return Validator.isMatchRegex("((?:[a-fA-F0-9]{1,2}[:-]){5}[a-fA-F0-9]{1,2})|0x(\\d{12}).+ETHER", value);
    }

    public static <T extends CharSequence> T validateMac(T value, String errorMsg) throws ValidateException {
        if (!Validator.isMac(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isPlateNumber(CharSequence value) {
        return Validator.isMatchRegex(RegEx.PLATE_NUMBER, value);
    }

    public static <T extends CharSequence> T validatePlateNumber(T value, String errorMsg) throws ValidateException {
        if (!Validator.isPlateNumber(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isUrl(CharSequence value) {
        if (StringKit.isBlank(value)) {
            return false;
        }
        try {
            new URL(StringKit.toString(value));
        }
        catch (MalformedURLException e) {
            return false;
        }
        return true;
    }

    public static <T extends CharSequence> T validateUrl(T value, String errorMsg) throws ValidateException {
        if (!Validator.isUrl(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isChinese(CharSequence value) {
        return Validator.isMatchRegex("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+", value);
    }

    public static <T extends CharSequence> T validateChinese(T value, String errorMsg) throws ValidateException {
        if (!Validator.isChinese(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean hasChinese(CharSequence value) {
        return PatternKit.contains("[\u2e80-\u2eff\u2f00-\u2fdf\u31c0-\u31ef\u3400-\u4dbf\u4e00-\u9fff\uf900-\ufaff\ud840\udc00-\ud869\udedf\ud869\udf00-\ud86d\udf3f\ud86d\udf40-\ud86e\udc1f\ud86e\udc20-\ud873\udeaf\ud87e\udc00-\ud87e\ude1f]+", value);
    }

    public static <T extends CharSequence> T validateHasChinese(T value, String errorMsg) throws ValidateException {
        if (!Validator.hasChinese(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isUUID(CharSequence value) {
        return Validator.isMatchRegex(RegEx.UUID, value) || Validator.isMatchRegex(RegEx.UUID_SIMPLE, value);
    }

    public static <T extends CharSequence> T validateUUID(T value, String errorMsg) throws ValidateException {
        if (!Validator.isUUID(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isHex(CharSequence value) {
        return Validator.isMatchRegex("^[a-fA-F0-9]+$", value);
    }

    public static <T extends CharSequence> T validateHex(T value, String errorMsg) throws ValidateException {
        if (!Validator.isHex(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isBetween(Number value, Number min, Number max) {
        Assert.notNull(value);
        Assert.notNull(min);
        Assert.notNull(max);
        double doubleValue = value.doubleValue();
        return doubleValue >= min.doubleValue() && doubleValue <= max.doubleValue();
    }

    public static void validateBetween(Number value, Number min, Number max, String errorMsg) throws ValidateException {
        if (!Validator.isBetween(value, min, max)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isMatchRegex(String regex, CharSequence value) {
        return PatternKit.isMatch(regex, value);
    }

    public static boolean isMatchRegex(Pattern pattern, CharSequence value) {
        return PatternKit.isMatch(pattern, value);
    }

    public static <T extends CharSequence> T validateMatchRegex(String regex, T value, String errorMsg) throws ValidateException {
        if (!Validator.isMatchRegex(regex, value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isCreditCode(CharSequence value) {
        return LicenseKit.isCreditCode(value);
    }

    public static <T extends CharSequence> T validateCreditCode(T value, String errorMsg) throws ValidateException {
        if (!Validator.isCreditCode(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isCarVin(CharSequence value) {
        return Validator.isMatchRegex(RegEx.CAR_VIN, value);
    }

    public static <T extends CharSequence> T validateCarVin(T value, String errorMsg) throws ValidateException {
        if (!Validator.isCarVin(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isCarDrivingLicence(CharSequence value) {
        return Validator.isMatchRegex(RegEx.CAR_DRIVING_LICENCE, value);
    }

    public static <T extends CharSequence> T validateCarDrivingLicence(T value, String errorMsg) throws ValidateException {
        if (!Validator.isCarDrivingLicence(value)) {
            throw new ValidateException(errorMsg);
        }
        return value;
    }

    public static boolean isPassword(String value, boolean ... weak) {
        boolean result = false;
        for (boolean element : weak) {
            result ^= element;
        }
        return result ? Validator.isMatchRegex(RegEx.PASSWORD_WEAK, (CharSequence)value) : Validator.isMatchRegex(RegEx.PASSWORD_STRONG, (CharSequence)value);
    }

    public static void validatePassword(String value, String errorMsg, boolean ... weak) throws ValidateException {
        if (!Validator.isPassword(value, weak)) {
            throw new ValidateException(errorMsg);
        }
    }

    public static boolean isChineseName(CharSequence value) {
        return Validator.isMatchRegex("^[\u2e80-\u9fff\u00b7]{2,60}$", value);
    }

    public static void validateisChineseName(String value, String errorMsg) throws ValidateException {
        if (!Validator.isChineseName(value)) {
            throw new ValidateException(errorMsg);
        }
    }
}

