/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.lang.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.aoju.bus.core.exception.InternalException;

@FunctionalInterface
public interface XBiConsumer<T, U>
extends BiConsumer<T, U>,
Serializable {
    @SafeVarargs
    public static <T, U> XBiConsumer<T, U> multi(XBiConsumer<T, U> ... consumers) {
        return Stream.of(consumers).reduce(XBiConsumer::andThen).orElseGet(() -> (o, q) -> {});
    }

    public static <T, U> XBiConsumer<T, U> nothing() {
        return (l, r) -> {};
    }

    public void accepting(T var1, U var2) throws Exception;

    @Override
    default public void accept(T t, U u) {
        try {
            this.accepting(t, u);
        }
        catch (Exception e) {
            throw new InternalException(e);
        }
    }

    @Override
    default public XBiConsumer<T, U> andThen(XBiConsumer<? super T, ? super U> after) {
        Objects.requireNonNull(after);
        return (l, r) -> {
            this.accepting(l, r);
            after.accepting(l, r);
        };
    }
}

