/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.map;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aoju.bus.core.map.FuncKeyMap;
import org.aoju.bus.core.map.MapBuilder;

public class CaseInsensitiveMap<K, V>
extends FuncKeyMap<K, V> {
    private static final long serialVersionUID = 1L;

    public CaseInsensitiveMap() {
        this(16);
    }

    public CaseInsensitiveMap(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public CaseInsensitiveMap(Map<? extends K, ? extends V> map) {
        this(0.75f, map);
    }

    public CaseInsensitiveMap(float loadFactor, Map<? extends K, ? extends V> map) {
        this(map.size(), loadFactor);
        this.putAll(map);
    }

    public CaseInsensitiveMap(int initialCapacity, float loadFactor) {
        this(MapBuilder.of(new HashMap(initialCapacity, loadFactor)));
    }

    CaseInsensitiveMap(MapBuilder<K, V> emptyMapBuilder) {
        super(emptyMapBuilder.build(), (Function<Object, Object> & Serializable)key -> {
            if (key instanceof CharSequence) {
                key = key.toString().toLowerCase();
            }
            return key;
        });
    }
}

