/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.scanner.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.aoju.bus.core.scanner.AnnotationScanner;
import org.aoju.bus.core.scanner.annotation.AbstractTypeScanner;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ClassKit;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.StringKit;

public class MethodScanner
extends AbstractTypeScanner<MethodScanner>
implements AnnotationScanner {
    public MethodScanner(boolean scanSameSignatureMethod, Predicate<Class<?>> filter, Set<Class<?>> excludeTypes) {
        super(scanSameSignatureMethod, scanSameSignatureMethod, filter, excludeTypes);
    }

    public MethodScanner(boolean scanSameSignatureMethod) {
        this(scanSameSignatureMethod, targetClass -> true, CollKit.newLinkedHashSet(new Class[0]));
    }

    public MethodScanner() {
        this(false);
    }

    @Override
    public boolean support(AnnotatedElement annotatedEle) {
        return annotatedEle instanceof Method;
    }

    @Override
    protected Class<?> getClassFormAnnotatedElement(AnnotatedElement annotatedElement) {
        return ((Method)annotatedElement).getDeclaringClass();
    }

    @Override
    protected Annotation[] getAnnotationsFromTargetClass(AnnotatedElement source, int index, Class<?> targetClass) {
        Method sourceMethod = (Method)source;
        return (Annotation[])Stream.of(targetClass.getDeclaredMethods()).filter(superMethod -> !superMethod.isBridge()).filter(superMethod -> this.hasSameSignature(sourceMethod, (Method)superMethod)).map(AnnotatedElement::getAnnotations).flatMap(Stream::of).toArray(Annotation[]::new);
    }

    public MethodScanner setScanSameSignatureMethod(boolean scanSuperMethodIfOverride) {
        this.setIncludeInterfaces(scanSuperMethodIfOverride);
        this.setIncludeSupperClass(scanSuperMethodIfOverride);
        return this;
    }

    private boolean hasSameSignature(Method sourceMethod, Method superMethod) {
        Class<?>[] targetParameterTypes;
        if (!StringKit.equals(sourceMethod.getName(), superMethod.getName())) {
            return false;
        }
        Class<?>[] sourceParameterTypes = sourceMethod.getParameterTypes();
        if (sourceParameterTypes.length != (targetParameterTypes = superMethod.getParameterTypes()).length) {
            return false;
        }
        if (!ArrayKit.containsAll(sourceParameterTypes, targetParameterTypes)) {
            return false;
        }
        return ClassKit.isAssignable(superMethod.getReturnType(), sourceMethod.getReturnType());
    }
}

