/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text;

import java.util.Map;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.StringKit;

public class TextFormatter {
    public static String format(String template, Object ... args) {
        return TextFormatter.format(template, "{}", args);
    }

    public static String format(String template, String placeHolder, Object ... args) {
        if (StringKit.isBlank(template) || StringKit.isBlank(placeHolder) || ArrayKit.isEmpty(args)) {
            return template;
        }
        int templateLength = template.length();
        int placeHolderLength = placeHolder.length();
        StringBuilder text = new StringBuilder(templateLength + 50);
        int handledPosition = 0;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            int delimIndex = template.indexOf(placeHolder, handledPosition);
            if (delimIndex == -1) {
                if (handledPosition == 0) {
                    return template;
                }
                text.append(template, handledPosition, templateLength);
                return text.toString();
            }
            if (delimIndex > 0 && template.charAt(delimIndex - 1) == '\\') {
                if (delimIndex > 1 && template.charAt(delimIndex - 2) == '\\') {
                    text.append(template, handledPosition, delimIndex - 1);
                    text.append(StringKit.toString(args[argIndex]));
                    handledPosition = delimIndex + placeHolderLength;
                    continue;
                }
                --argIndex;
                text.append(template, handledPosition, delimIndex - 1);
                text.append(placeHolder.charAt(0));
                handledPosition = delimIndex + 1;
                continue;
            }
            text.append(template, handledPosition, delimIndex);
            text.append(StringKit.toString(args[argIndex]));
            handledPosition = delimIndex + placeHolderLength;
        }
        text.append(template, handledPosition, template.length());
        return text.toString();
    }

    public static String format(CharSequence template, Map<?, ?> map, boolean ignoreNull) {
        if (null == template) {
            return null;
        }
        if (null == map || map.isEmpty()) {
            return template.toString();
        }
        String text = template.toString();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String value = StringKit.toString(entry.getValue());
            if (null == value && ignoreNull) continue;
            text = StringKit.replace((CharSequence)text, (CharSequence)("{" + String.valueOf(entry.getKey()) + "}"), value);
        }
        return text;
    }
}

