/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.bloom;

import java.util.BitSet;
import org.aoju.bus.core.text.bloom.BloomFilter;

public abstract class AbstractFilter
implements BloomFilter {
    private static final long serialVersionUID = 1L;
    private final BitSet bitSet;
    protected int size;

    public AbstractFilter(int size) {
        this.size = size;
        this.bitSet = new BitSet(size);
    }

    @Override
    public boolean contains(String text) {
        return this.bitSet.get(Math.abs(this.hash(text)));
    }

    @Override
    public boolean add(String text) {
        int hash = Math.abs(this.hash(text));
        if (this.bitSet.get(hash)) {
            return false;
        }
        this.bitSet.set(hash);
        return true;
    }

    public abstract int hash(String var1);
}

