/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.text.finder;

import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.text.finder.TextFinder;
import org.aoju.bus.core.toolkit.MathKit;

public class CharFinder
extends TextFinder {
    private static final long serialVersionUID = 1L;
    private final char word;
    private final boolean caseInsensitive;

    public CharFinder(char word) {
        this(word, false);
    }

    public CharFinder(char word, boolean caseInsensitive) {
        this.word = word;
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public int start(int from) {
        Assert.notNull(this.text, "Text to find must be not null!", new Object[0]);
        int limit = this.getValidEndIndex();
        if (this.negative) {
            for (int i = from; i > limit; --i) {
                if (!MathKit.equals(this.word, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        } else {
            for (int i = from; i < limit; ++i) {
                if (!MathKit.equals(this.word, this.text.charAt(i), this.caseInsensitive)) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int end(int start) {
        if (start < 0) {
            return -1;
        }
        return start + 1;
    }
}

