/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.convert.Convert;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.image.Images;
import org.aoju.bus.core.image.Removal;
import org.aoju.bus.core.io.resource.Resource;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.MathKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.RandomKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.core.toolkit.UriKit;

public class ImageKit {
    public static void scale(File srcImageFile, File destImageFile, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcImageFile), destImageFile, scale);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcStream), destStream, scale);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, float scale) {
        ImageKit.scale((Image)ImageKit.read(srcStream), destStream, scale);
    }

    public static void scale(Image srcImage, File destFile, float scale) throws InternalException {
        Images.from(srcImage).setTargetImageType(FileKit.getSuffix(destFile)).scale(scale).write(destFile);
    }

    public static void scale(Image srcImage, OutputStream out, float scale) throws InternalException {
        ImageKit.scale(srcImage, ImageKit.getImageOutputStream(out), scale);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, float scale) throws InternalException {
        ImageKit.writeJpg(ImageKit.scale(srcImage, scale), destImageStream);
    }

    public static Image scale(Image srcImage, float scale) {
        return Images.from(srcImage).scale(scale).getImg();
    }

    public static Image scale(Image srcImage, int width, int height) {
        return Images.from(srcImage).scale(width, height).getImg();
    }

    public static void scale(File srcImageFile, File destImageFile, int width, int height, Color fixedColor) throws InternalException {
        ImageKit.write(ImageKit.scale(ImageKit.read(srcImageFile), width, height, fixedColor), destImageFile);
    }

    public static void scale(InputStream srcStream, OutputStream destStream, int width, int height, Color fixedColor) throws InternalException {
        ImageKit.scale(ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), width, height, fixedColor);
    }

    public static void scale(ImageInputStream srcStream, ImageOutputStream destStream, int width, int height, Color fixedColor) throws InternalException {
        ImageKit.scale(ImageKit.read(srcStream), destStream, width, height, fixedColor);
    }

    public static void scale(Image srcImage, ImageOutputStream destImageStream, int width, int height, Color fixedColor) throws InternalException {
        ImageKit.writeJpg(ImageKit.scale(srcImage, width, height, fixedColor), destImageStream);
    }

    public static Image scale(Image srcImage, int width, int height, Color fixedColor) {
        return Images.from(srcImage).scale(width, height, fixedColor).getImg();
    }

    public static void cut(File srcImgFile, File destImgFile, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcImgFile), destImgFile, rectangle);
    }

    public static void cut(InputStream srcStream, OutputStream destStream, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcStream), destStream, rectangle);
    }

    public static void cut(ImageInputStream srcStream, ImageOutputStream destStream, Rectangle rectangle) {
        ImageKit.cut((Image)ImageKit.read(srcStream), destStream, rectangle);
    }

    public static void cut(Image srcImage, File destFile, Rectangle rectangle) throws InternalException {
        ImageKit.write(ImageKit.cut(srcImage, rectangle), destFile);
    }

    public static void cut(Image srcImage, OutputStream out, Rectangle rectangle) throws InternalException {
        ImageKit.cut(srcImage, ImageKit.getImageOutputStream(out), rectangle);
    }

    public static void cut(Image srcImage, ImageOutputStream destImageStream, Rectangle rectangle) throws InternalException {
        ImageKit.writeJpg(ImageKit.cut(srcImage, rectangle), destImageStream);
    }

    public static Image cut(Image srcImage, Rectangle rectangle) {
        return Images.from(srcImage).setPositionBaseCentre(false).cut(rectangle).getImg();
    }

    public static Image cut(Image srcImage, int x, int y) {
        return ImageKit.cut(srcImage, x, y, -1);
    }

    public static Image cut(Image srcImage, int x, int y, int radius) {
        return Images.from(srcImage).cut(x, y, radius).getImg();
    }

    public static void slice(File srcImageFile, File descDir, int destWidth, int destHeight) {
        ImageKit.slice(ImageKit.read(srcImageFile), descDir, destWidth, destHeight);
    }

    public static void slice(Image srcImage, File descDir, int destWidth, int destHeight) {
        if (destWidth <= 0) {
            destWidth = 200;
        }
        if (destHeight <= 0) {
            destHeight = 150;
        }
        int srcWidth = srcImage.getWidth(null);
        int srcHeight = srcImage.getHeight(null);
        if (srcWidth < destWidth) {
            destWidth = srcWidth;
        }
        if (srcHeight < destHeight) {
            destHeight = srcHeight;
        }
        int cols = srcWidth % destWidth == 0 ? srcWidth / destWidth : (int)Math.floor((double)srcWidth / (double)destWidth) + 1;
        int rows = srcHeight % destHeight == 0 ? srcHeight / destHeight : (int)Math.floor((double)srcHeight / (double)destHeight) + 1;
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < cols; ++j) {
                Image tag = ImageKit.cut(srcImage, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                ImageKit.write(tag, FileKit.file(descDir, "_r" + i + "_c" + j + ".jpg"));
            }
        }
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, int rows, int cols) {
        ImageKit.sliceByRowsAndCols(srcImageFile, destDir, "jpeg", rows, cols);
    }

    public static void sliceByRowsAndCols(File srcImageFile, File destDir, String format, int rows, int cols) {
        try {
            ImageKit.sliceByRowsAndCols(ImageIO.read(srcImageFile), destDir, format, rows, cols);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void sliceByRowsAndCols(Image srcImage, File destDir, String format, int rows, int cols) {
        if (!destDir.exists()) {
            FileKit.mkdir(destDir);
        } else if (!destDir.isDirectory()) {
            throw new IllegalArgumentException("Destination Dir must be a Directory !");
        }
        try {
            if (rows <= 0 || rows > 20) {
                rows = 2;
            }
            if (cols <= 0 || cols > 20) {
                cols = 2;
            }
            BufferedImage bi = ImageKit.toBufferedImage(srcImage);
            int srcWidth = ((Image)bi).getWidth(null);
            int srcHeight = ((Image)bi).getHeight(null);
            int destWidth = MathKit.partValue(srcWidth, cols);
            int destHeight = MathKit.partValue(srcHeight, rows);
            for (int i = 0; i < rows; ++i) {
                for (int j = 0; j < cols; ++j) {
                    Image tag = ImageKit.cut(bi, new Rectangle(j * destWidth, i * destHeight, destWidth, destHeight));
                    ImageIO.write(ImageKit.toRenderedImage(tag), format, new File(destDir, "_r" + i + "_c" + j + ".jpg"));
                }
            }
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File srcImageFile, File destImageFile) {
        Assert.notNull(srcImageFile);
        Assert.notNull(destImageFile);
        Assert.isFalse(srcImageFile.equals(destImageFile), "Src file is equals to dest file!", new Object[0]);
        String srcSuffix = FileKit.getSuffix(srcImageFile);
        String destSuffix = FileKit.getSuffix(destImageFile);
        if (StringKit.equalsIgnoreCase(srcSuffix, destSuffix)) {
            FileKit.copy(srcImageFile, destImageFile, true);
        }
        ImageOutputStream imageOutputStream = null;
        try {
            imageOutputStream = ImageKit.getImageOutputStream(destImageFile);
            ImageKit.convert(ImageKit.read(srcImageFile), destSuffix, imageOutputStream, StringKit.equalsIgnoreCase("png", srcSuffix));
        }
        finally {
            IoKit.close(imageOutputStream);
        }
    }

    public static void convert(InputStream srcStream, String formatName, OutputStream destStream) {
        ImageKit.write((Image)ImageKit.read(srcStream), formatName, ImageKit.getImageOutputStream(destStream));
    }

    public static void convert(Image srcImage, String formatName, ImageOutputStream destImageStream, boolean isSrcPng) {
        try {
            ImageIO.write((RenderedImage)(isSrcPng ? ImageKit.copyImage(srcImage, 1) : ImageKit.toBufferedImage(srcImage)), formatName, destImageStream);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }

    public static void gray(File srcImageFile, File destImageFile) {
        ImageKit.gray((Image)ImageKit.read(srcImageFile), destImageFile);
    }

    public static void gray(InputStream srcStream, OutputStream destStream) {
        ImageKit.gray((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream));
    }

    public static void gray(ImageInputStream srcStream, ImageOutputStream destStream) {
        ImageKit.gray((Image)ImageKit.read(srcStream), destStream);
    }

    public static void gray(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.gray(srcImage), outFile);
    }

    public static void gray(Image srcImage, OutputStream out) {
        ImageKit.gray(srcImage, ImageKit.getImageOutputStream(out));
    }

    public static void gray(Image srcImage, ImageOutputStream destImageStream) throws InternalException {
        ImageKit.writeJpg(ImageKit.gray(srcImage), destImageStream);
    }

    public static Image gray(Image srcImage) {
        return Images.from(srcImage).gray().getImg();
    }

    public static void binary(File srcImageFile, File destImageFile) {
        ImageKit.binary(ImageKit.read(srcImageFile), destImageFile);
    }

    public static void binary(InputStream srcStream, OutputStream destStream, String imageType) {
        ImageKit.binary((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), imageType);
    }

    public static void binary(ImageInputStream srcStream, ImageOutputStream destStream, String imageType) {
        ImageKit.binary((Image)ImageKit.read(srcStream), destStream, imageType);
    }

    public static void binary(Image srcImage, File outFile) {
        ImageKit.write(ImageKit.binary(srcImage), outFile);
    }

    public static void binary(Image srcImage, OutputStream out, String imageType) {
        ImageKit.binary(srcImage, ImageKit.getImageOutputStream(out), imageType);
    }

    public static void binary(Image srcImage, ImageOutputStream destImageStream, String imageType) throws InternalException {
        ImageKit.write(ImageKit.binary(srcImage), imageType, destImageStream);
    }

    public static Image binary(Image srcImage) {
        return Images.from(srcImage).binary().getImg();
    }

    public static void pressText(File imageFile, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(imageFile), destFile, pressText, color, font, x, y, alpha);
    }

    public static void pressText(InputStream srcStream, OutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), pressText, color, font, x, y, alpha);
    }

    public static void pressText(ImageInputStream srcStream, ImageOutputStream destStream, String pressText, Color color, Font font, int x, int y, float alpha) {
        ImageKit.pressText((Image)ImageKit.read(srcStream), destStream, pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, File destFile, String pressText, Color color, Font font, int x, int y, float alpha) throws InternalException {
        ImageKit.write(ImageKit.pressText(srcImage, pressText, color, font, x, y, alpha), destFile);
    }

    public static void pressText(Image srcImage, OutputStream to, String pressText, Color color, Font font, int x, int y, float alpha) throws InternalException {
        ImageKit.pressText(srcImage, ImageKit.getImageOutputStream(to), pressText, color, font, x, y, alpha);
    }

    public static void pressText(Image srcImage, ImageOutputStream destImageStream, String pressText, Color color, Font font, int x, int y, float alpha) throws InternalException {
        ImageKit.writeJpg(ImageKit.pressText(srcImage, pressText, color, font, x, y, alpha), destImageStream);
    }

    public static Image pressText(Image srcImage, String pressText, Color color, Font font, int x, int y, float alpha) {
        return Images.from(srcImage).pressText(pressText, color, font, x, y, alpha).getImg();
    }

    public static void pressImage(File srcImageFile, File destImageFile, Image pressImage, int x, int y, float alpha) {
        ImageKit.pressImage((Image)ImageKit.read(srcImageFile), destImageFile, pressImage, x, y, alpha);
    }

    public static void pressImage(InputStream srcStream, OutputStream destStream, Image pressImage, int x, int y, float alpha) {
        ImageKit.pressImage((Image)ImageKit.read(srcStream), ImageKit.getImageOutputStream(destStream), pressImage, x, y, alpha);
    }

    public static void pressImage(ImageInputStream srcStream, ImageOutputStream destStream, Image pressImage, int x, int y, float alpha) throws InternalException {
        ImageKit.pressImage((Image)ImageKit.read(srcStream), destStream, pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, File outFile, Image pressImage, int x, int y, float alpha) throws InternalException {
        ImageKit.write(ImageKit.pressImage(srcImage, pressImage, x, y, alpha), outFile);
    }

    public static void pressImage(Image srcImage, OutputStream out, Image pressImage, int x, int y, float alpha) throws InternalException {
        ImageKit.pressImage(srcImage, ImageKit.getImageOutputStream(out), pressImage, x, y, alpha);
    }

    public static void pressImage(Image srcImage, ImageOutputStream destImageStream, Image pressImage, int x, int y, float alpha) throws InternalException {
        ImageKit.writeJpg(ImageKit.pressImage(srcImage, pressImage, x, y, alpha), destImageStream);
    }

    public static Image pressImage(Image srcImage, Image pressImage, int x, int y, float alpha) {
        return Images.from(srcImage).pressImage(pressImage, x, y, alpha).getImg();
    }

    public static Image pressImage(Image srcImage, Image pressImage, Rectangle rectangle, float alpha) {
        return Images.from(srcImage).pressImage(pressImage, rectangle, alpha).getImg();
    }

    public static void rotate(File imageFile, int degree, File outFile) throws InternalException {
        ImageKit.rotate((Image)ImageKit.read(imageFile), degree, outFile);
    }

    public static void rotate(Image image, int degree, File outFile) throws InternalException {
        ImageKit.write(ImageKit.rotate(image, degree), outFile);
    }

    public static void rotate(Image image, int degree, OutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), ImageKit.getImageOutputStream(out));
    }

    public static void rotate(Image image, int degree, ImageOutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.rotate(image, degree), out);
    }

    public static Image rotate(Image image, int degree) {
        return Images.from(image).rotate(degree).getImg();
    }

    public static void flip(File imageFile, File outFile) throws InternalException {
        ImageKit.flip((Image)ImageKit.read(imageFile), outFile);
    }

    public static void flip(Image image, File outFile) throws InternalException {
        ImageKit.write(ImageKit.flip(image), outFile);
    }

    public static void flip(Image image, OutputStream out) throws InternalException {
        ImageKit.flip(image, ImageKit.getImageOutputStream(out));
    }

    public static void flip(Image image, ImageOutputStream out) throws InternalException {
        ImageKit.writeJpg(ImageKit.flip(image), out);
    }

    public static Image flip(Image image) {
        return Images.from(image).flip().getImg();
    }

    public static void compress(File imageFile, File outFile, float quality) throws InternalException {
        Images.from(imageFile).setQuality(quality).write(outFile);
    }

    public static RenderedImage toRenderedImage(Image image) {
        if (image instanceof RenderedImage) {
            return (RenderedImage)((Object)image);
        }
        return ImageKit.copyImage(image, 1);
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        return ImageKit.copyImage(img, 1);
    }

    public static BufferedImage toBufferedImage(Image image, String imageType) {
        int type = imageType.equalsIgnoreCase("png") ? 2 : 1;
        return ImageKit.toBufferedImage(image, type);
    }

    public static BufferedImage toBufferedImage(Image image, int imageType) {
        if (image instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)image;
            if (imageType != bufferedImage.getType()) {
                bufferedImage = ImageKit.copyImage(image, imageType);
            }
            return bufferedImage;
        }
        BufferedImage bufferedImage = ImageKit.copyImage(image, imageType);
        return bufferedImage;
    }

    public static BufferedImage copyImage(Image image, int imageType) {
        return ImageKit.copyImage(image, imageType, null);
    }

    public static BufferedImage copyImage(Image image, int imageType, Color backgroundColor) {
        BufferedImage bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), imageType);
        Graphics2D bGr = org.aoju.bus.core.lang.Graphics.createGraphics(bimage, backgroundColor);
        bGr.drawImage(image, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static BufferedImage toImage(String base64) throws InternalException {
        return ImageKit.toImage(Base64.decode(base64));
    }

    public static BufferedImage toImage(byte[] imageBytes) throws InternalException {
        return ImageKit.read(new ByteArrayInputStream(imageBytes));
    }

    public static ByteArrayInputStream toStream(Image image, String imageType) {
        return IoKit.toStream(ImageKit.toBytes(image, imageType));
    }

    public static String toBase64(Image image, String imageType) {
        return Base64.encode(ImageKit.toBytes(image, imageType));
    }

    public static String toBase64Uri(Image image, String imageType) {
        return UriKit.toURL("image/" + imageType, "base64", ImageKit.toBase64(image, imageType));
    }

    public static byte[] toBytes(Image image, String imageType) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ImageKit.write(image, imageType, out);
        return out.toByteArray();
    }

    public static void createImage(String text, Font font, Color backgroundColor, Color fontColor, ImageOutputStream out) {
        ImageKit.writePng((Image)ImageKit.createImage(text, font, backgroundColor, fontColor, 2), out);
    }

    public static BufferedImage createImage(String text, Font font, Color backgroundColor, Color fontColor, int imageType) {
        Rectangle2D r = ImageKit.getRectangle(text, font);
        int unitHeight = (int)Math.floor(r.getHeight());
        int width = (int)Math.round(r.getWidth()) + 1;
        int height = unitHeight + 3;
        BufferedImage image = new BufferedImage(width, height, imageType);
        Graphics g = image.getGraphics();
        if (null != backgroundColor) {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, width, height);
        }
        g.setColor(ObjectKit.defaultIfNull(fontColor, Color.BLACK));
        g.setFont(font);
        g.drawString(text, 0, font.getSize());
        g.dispose();
        return image;
    }

    public static Rectangle2D getRectangle(String text, Font font) {
        return font.getStringBounds(text, new FontRenderContext(AffineTransform.getScaleInstance(1.0, 1.0), false, false));
    }

    public static void writeJpg(Image image, ImageOutputStream destImageStream) throws InternalException {
        ImageKit.write(image, "jpg", destImageStream);
    }

    public static void writePng(Image image, ImageOutputStream destImageStream) throws InternalException {
        ImageKit.write(image, "png", destImageStream);
    }

    public static void writeJpg(Image image, OutputStream out) throws InternalException {
        ImageKit.write(image, "jpg", out);
    }

    public static void writePng(Image image, OutputStream out) throws InternalException {
        ImageKit.write(image, "png", out);
    }

    public static void write(Image image, String imageType, OutputStream out) throws InternalException {
        ImageKit.write(image, imageType, ImageKit.getImageOutputStream(out));
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream) throws InternalException {
        return ImageKit.write(image, imageType, destImageStream, 1.0f);
    }

    public static boolean write(Image image, String imageType, ImageOutputStream destImageStream, float quality) throws InternalException {
        if (StringKit.isBlank(imageType)) {
            imageType = "jpg";
        }
        BufferedImage bufferedImage = ImageKit.toBufferedImage(image, imageType);
        ImageWriter writer = ImageKit.getWriter(bufferedImage, imageType);
        return ImageKit.write((Image)bufferedImage, writer, destImageStream, quality);
    }

    public static void write(Image image, File targetFile) throws InternalException {
        FileKit.touch(targetFile);
        ImageOutputStream out = null;
        try {
            out = ImageKit.getImageOutputStream(targetFile);
            ImageKit.write(image, FileKit.getSuffix(targetFile), out);
        }
        finally {
            IoKit.close(out);
        }
    }

    public static boolean write(Image image, ImageWriter writer, ImageOutputStream output, float quality) {
        if (null == writer) {
            return false;
        }
        writer.setOutput(output);
        RenderedImage renderedImage = ImageKit.toRenderedImage(image);
        ImageWriteParam imgWriteParams = null;
        if (quality > 0.0f && quality < 1.0f && (imgWriteParams = writer.getDefaultWriteParam()).canWriteCompressed()) {
            imgWriteParams.setCompressionMode(2);
            imgWriteParams.setCompressionQuality(quality);
            ColorModel colorModel = renderedImage.getColorModel();
            imgWriteParams.setDestinationType(new ImageTypeSpecifier(colorModel, colorModel.createCompatibleSampleModel(16, 16)));
        }
        try {
            if (null != imgWriteParams) {
                writer.write(null, new IIOImage(renderedImage, null, null), imgWriteParams);
            } else {
                writer.write(renderedImage);
            }
            output.flush();
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        finally {
            writer.dispose();
        }
        return true;
    }

    public static ImageReader getReader(String type) {
        Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(type);
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }

    public static BufferedImage read(String imageFilePath) {
        return ImageKit.read(FileKit.file(imageFilePath));
    }

    public static BufferedImage read(File imageFile) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageFile);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + imageFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static BufferedImage read(Resource resource) {
        return ImageKit.read(resource.getStream());
    }

    public static BufferedImage read(InputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(ImageInputStream imageStream) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageStream);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static BufferedImage read(URL imageUrl) {
        BufferedImage result;
        try {
            result = ImageIO.read(imageUrl);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of [" + imageUrl.toString() + "] is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(OutputStream out) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(out);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageOutputStream getImageOutputStream(File outFile) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(outFile);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type of file [" + outFile.getName() + "] is not supported!");
        }
        return result;
    }

    public static ImageInputStream getImageInputStream(InputStream in) throws InternalException {
        ImageOutputStream result;
        try {
            result = ImageIO.createImageOutputStream(in);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
        if (null == result) {
            throw new IllegalArgumentException("Image type is not supported!");
        }
        return result;
    }

    public static ImageWriter getWriter(Image image, String formatName) {
        ImageTypeSpecifier type = ImageTypeSpecifier.createFromRenderedImage(ImageKit.toRenderedImage(image));
        Iterator<ImageWriter> iter = ImageIO.getImageWriters(type, formatName);
        return iter.hasNext() ? iter.next() : null;
    }

    public static ImageWriter getWriter(String formatName) {
        ImageWriter writer = null;
        Iterator<ImageWriter> iter = ImageIO.getImageWritersByFormatName(formatName);
        if (iter.hasNext()) {
            writer = iter.next();
        }
        if (null == writer && (iter = ImageIO.getImageWritersBySuffix(formatName)).hasNext()) {
            writer = iter.next();
        }
        return writer;
    }

    public static String toHex(Color color) {
        Object R = Integer.toHexString(color.getRed());
        R = ((String)R).length() < 2 ? "0" + (String)R : R;
        Object G = Integer.toHexString(color.getGreen());
        G = ((String)G).length() < 2 ? "0" + (String)G : G;
        Object B = Integer.toHexString(color.getBlue());
        B = ((String)B).length() < 2 ? "0" + (String)B : B;
        return "#" + (String)R + (String)G + (String)B;
    }

    public static String toHex(int r, int g, int b) {
        if (r < 0 || r > 255 || g < 0 || g > 255 || b < 0 || b > 255) {
            throw new IllegalArgumentException("RGB must be 0~255!");
        }
        return String.format("#%02X%02X%02X", r, g, b);
    }

    public static Color hexToColor(String hex) {
        return ImageKit.getColor(Integer.parseInt(StringKit.removePrefix("#", hex), 16));
    }

    public static Color getColor(int rgb) {
        return new Color(rgb);
    }

    public static Color getColor(String colorName) {
        if (StringKit.isBlank(colorName)) {
            return null;
        }
        if ("BLACK".equals(colorName = colorName.toUpperCase())) {
            return Color.BLACK;
        }
        if ("WHITE".equals(colorName)) {
            return Color.WHITE;
        }
        if ("LIGHTGRAY".equals(colorName) || "LIGHT_GRAY".equals(colorName)) {
            return Color.LIGHT_GRAY;
        }
        if ("GRAY".equals(colorName)) {
            return Color.GRAY;
        }
        if ("DARK_GRAY".equals(colorName) || "DARK_GRAY".equals(colorName)) {
            return Color.DARK_GRAY;
        }
        if ("RED".equals(colorName)) {
            return Color.RED;
        }
        if ("PINK".equals(colorName)) {
            return Color.PINK;
        }
        if ("ORANGE".equals(colorName)) {
            return Color.ORANGE;
        }
        if ("YELLOW".equals(colorName)) {
            return Color.YELLOW;
        }
        if ("GREEN".equals(colorName)) {
            return Color.GREEN;
        }
        if ("MAGENTA".equals(colorName)) {
            return Color.MAGENTA;
        }
        if ("CYAN".equals(colorName)) {
            return Color.CYAN;
        }
        if ("BLUE".equals(colorName)) {
            return Color.BLUE;
        }
        if ("DARKGOLD".equals(colorName)) {
            return ImageKit.hexToColor("#9e7e67");
        }
        if ("LIGHTGOLD".equals(colorName)) {
            return ImageKit.hexToColor("#ac9c85");
        }
        if (StringKit.startWith((CharSequence)colorName, '#')) {
            return ImageKit.hexToColor(colorName);
        }
        if (StringKit.startWith((CharSequence)colorName, '$')) {
            return ImageKit.hexToColor("#" + colorName.substring(1));
        }
        List<String> rgb = StringKit.split((CharSequence)colorName, ',');
        if (3 == rgb.size()) {
            Integer b;
            Integer g;
            Integer r = Convert.toInt(rgb.get(0));
            if (!ArrayKit.hasNull(r, g = Convert.toInt(rgb.get(1)), b = Convert.toInt(rgb.get(2)))) {
                return new Color(r, g, b);
            }
        } else {
            return null;
        }
        return null;
    }

    public static Color randomColor() {
        return ImageKit.randomColor(null);
    }

    public static Color randomColor(Random random) {
        if (null == random) {
            random = RandomKit.getRandom();
        }
        return new Color(random.nextInt(256), random.nextInt(256), random.nextInt(256));
    }

    public static Images merge(BufferedImage srcImage, String fileType) {
        return Images.from(srcImage, null, fileType);
    }

    public static Images merge(String imageUrl, String fileType) {
        return Images.from(null, imageUrl, fileType);
    }

    public static String getMainColor(BufferedImage image, int[] ... rgbFilters) {
        HashMap<CallSite, Long> countMap = new HashMap<CallSite, Long>();
        int width = image.getWidth();
        int height = image.getHeight();
        int minx = image.getMinX();
        int miny = image.getMinY();
        for (int i = minx; i < width; ++i) {
            for (int j = miny; j < height; ++j) {
                int b;
                int g;
                int pixel = image.getRGB(i, j);
                int r = (pixel & 0xFF0000) >> 16;
                if (ImageKit.matchFilters(r, g = (pixel & 0xFF00) >> 8, b = pixel & 0xFF, rgbFilters)) continue;
                countMap.merge((CallSite)((Object)(r + "-" + g + "-" + b)), 1L, Long::sum);
            }
        }
        String maxColor = null;
        long maxCount = 0L;
        for (Map.Entry entry : countMap.entrySet()) {
            String key = (String)entry.getKey();
            Long count = (Long)entry.getValue();
            if (count <= maxCount) continue;
            maxColor = key;
            maxCount = count;
        }
        String[] splitRgbStr = StringKit.splitToArray(maxColor, '/');
        Object rHex = Integer.toHexString(Integer.parseInt(splitRgbStr[0]));
        Object gHex = Integer.toHexString(Integer.parseInt(splitRgbStr[1]));
        Object bHex = Integer.toHexString(Integer.parseInt(splitRgbStr[2]));
        rHex = ((String)rHex).length() == 1 ? "0" + (String)rHex : rHex;
        gHex = ((String)gHex).length() == 1 ? "0" + (String)gHex : gHex;
        bHex = ((String)bHex).length() == 1 ? "0" + (String)bHex : bHex;
        return "#" + (String)rHex + (String)gHex + (String)bHex;
    }

    private static boolean matchFilters(int r, int g, int b, int[] ... rgbFilters) {
        if (rgbFilters != null && rgbFilters.length > 0) {
            for (int[] rgbFilter : rgbFilters) {
                if (r != rgbFilter[0] || g != rgbFilter[1] || b != rgbFilter[2]) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean remove(String inputPath, String outputPath, int tolerance) {
        return Removal.remove(inputPath, outputPath, tolerance);
    }

    public static boolean remove(File input, File output, int tolerance) {
        return Removal.remove(input, output, tolerance);
    }

    public static boolean remove(File input, File output, Color override, int tolerance) {
        return Removal.remove(input, output, override, tolerance);
    }

    public static BufferedImage remove(BufferedImage bufferedImage, Color override, int tolerance) {
        return Removal.remove(bufferedImage, override, tolerance);
    }

    public static BufferedImage remove(ByteArrayOutputStream outputStream, Color override, int tolerance) {
        return Removal.remove(outputStream, override, tolerance);
    }

    public static BufferedImage filter(ColorSpace colorSpace, BufferedImage image) {
        return ImageKit.filter(new ColorConvertOp(colorSpace, null), image);
    }

    public static BufferedImage filter(AffineTransform xform, BufferedImage image) {
        return ImageKit.filter(new AffineTransformOp(xform, null), image);
    }

    public static BufferedImage filter(BufferedImageOp op, BufferedImage image) {
        return op.filter(image, null);
    }

    public static Image filter(ImageFilter filter, Image image) {
        return Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), filter));
    }

    public static Point getPointCentre(Rectangle rectangle, int backgroundWidth, int backgroundHeight) {
        return new Point(rectangle.x + Math.abs(backgroundWidth - rectangle.width) / 2, rectangle.y + Math.abs(backgroundHeight - rectangle.height) / 2);
    }
}

