/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.core.toolkit;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.io.watcher.WatchMonitor;
import org.aoju.bus.core.io.watcher.Watcher;
import org.aoju.bus.core.toolkit.UriKit;

public class WatchKit {
    public static WatchMonitor of(URL url, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(url, 0, events);
    }

    public static WatchMonitor of(URL url, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(UriKit.toURI(url), maxDepth, events);
    }

    public static WatchMonitor of(URI uri, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(uri, 0, events);
    }

    public static WatchMonitor of(URI uri, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(Paths.get(uri), maxDepth, events);
    }

    public static WatchMonitor of(File file, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(file, 0, events);
    }

    public static WatchMonitor of(File file, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(file.toPath(), maxDepth, events);
    }

    public static WatchMonitor of(String path, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(path, 0, events);
    }

    public static WatchMonitor of(String path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(Paths.get(path, new String[0]), maxDepth, events);
    }

    public static WatchMonitor of(Path path, WatchEvent.Kind<?> ... events) {
        return WatchKit.of(path, 0, events);
    }

    public static WatchMonitor of(Path path, int maxDepth, WatchEvent.Kind<?> ... events) {
        return new WatchMonitor(path, maxDepth, events);
    }

    public static WatchMonitor ofAll(URL url, Watcher watcher) {
        return WatchKit.ofAll(url, 0, watcher);
    }

    public static WatchMonitor ofAll(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(UriKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(URI uri, Watcher watcher) {
        return WatchKit.ofAll(uri, 0, watcher);
    }

    public static WatchMonitor ofAll(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(File file, Watcher watcher) {
        return WatchKit.ofAll(file, 0, watcher);
    }

    public static WatchMonitor ofAll(File file, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(String path, Watcher watcher) {
        return WatchKit.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(String path, int maxDepth, Watcher watcher) {
        return WatchKit.ofAll(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor ofAll(Path path, Watcher watcher) {
        return WatchKit.ofAll(path, 0, watcher);
    }

    public static WatchMonitor ofAll(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchKit.of(path, maxDepth, WatchMonitor.EVENTS_ALL);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchMonitor createModify(URL url, Watcher watcher) {
        return WatchKit.createModify(url, 0, watcher);
    }

    public static WatchMonitor createModify(URL url, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(UriKit.toURI(url), maxDepth, watcher);
    }

    public static WatchMonitor createModify(URI uri, Watcher watcher) {
        return WatchKit.createModify(uri, 0, watcher);
    }

    public static WatchMonitor createModify(URI uri, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(Paths.get(uri), maxDepth, watcher);
    }

    public static WatchMonitor createModify(File file, Watcher watcher) {
        return WatchKit.createModify(file, 0, watcher);
    }

    public static WatchMonitor createModify(File file, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(file.toPath(), maxDepth, watcher);
    }

    public static WatchMonitor createModify(String path, Watcher watcher) {
        return WatchKit.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(String path, int maxDepth, Watcher watcher) {
        return WatchKit.createModify(Paths.get(path, new String[0]), maxDepth, watcher);
    }

    public static WatchMonitor createModify(Path path, Watcher watcher) {
        return WatchKit.createModify(path, 0, watcher);
    }

    public static WatchMonitor createModify(Path path, int maxDepth, Watcher watcher) {
        WatchMonitor watchMonitor = WatchKit.of(path, maxDepth, WatchMonitor.ENTRY_MODIFY);
        watchMonitor.setWatcher(watcher);
        return watchMonitor;
    }

    public static WatchKey register(Watchable watchable, WatchService watcher, WatchEvent.Kind<?> ... events) {
        try {
            return watchable.register(watcher, events);
        }
        catch (IOException e) {
            throw new InternalException(e);
        }
    }
}

