/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.crypto.asymmetric;

import java.io.InputStream;
import java.nio.charset.Charset;
import org.aoju.bus.core.codec.Base64;
import org.aoju.bus.core.exception.CryptoException;
import org.aoju.bus.core.toolkit.HexKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.asymmetric.KeyType;

public interface Encryptor {
    public byte[] encrypt(byte[] var1, KeyType var2);

    default public String encryptHex(byte[] data, KeyType keyType) {
        return HexKit.encodeHexString(this.encrypt(data, keyType));
    }

    default public String encryptBase64(byte[] data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    default public byte[] encrypt(String data, String charset, KeyType keyType) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset), keyType);
    }

    default public byte[] encrypt(String data, Charset charset, KeyType keyType) {
        return this.encrypt(StringKit.bytes((CharSequence)data, charset), keyType);
    }

    default public byte[] encrypt(String data, KeyType keyType) {
        return this.encrypt(StringKit.bytes(data), keyType);
    }

    default public String encryptHex(String data, KeyType keyType) {
        return HexKit.encodeHexString(this.encrypt(data, keyType));
    }

    default public String encryptHex(String data, Charset charset, KeyType keyType) {
        return HexKit.encodeHexString(this.encrypt(data, charset, keyType));
    }

    default public String encryptBase64(String data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }

    default public String encryptBase64(String data, Charset charset, KeyType keyType) {
        return Base64.encode(this.encrypt(data, charset, keyType));
    }

    default public byte[] encrypt(InputStream data, KeyType keyType) throws CryptoException {
        return this.encrypt(IoKit.readBytes(data), keyType);
    }

    default public String encryptHex(InputStream data, KeyType keyType) {
        return HexKit.encodeHexString(this.encrypt(data, keyType));
    }

    default public String encryptBase64(InputStream data, KeyType keyType) {
        return Base64.encode(this.encrypt(data, keyType));
    }
}

