/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.goalie.handler;

import java.util.Map;
import org.aoju.bus.base.normal.ErrorCode;
import org.aoju.bus.base.spring.Controller;
import org.aoju.bus.core.exception.BusinessException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.goalie.Provider;
import org.aoju.bus.logger.Logger;
import org.reactivestreams.Publisher;
import org.springframework.boot.web.reactive.error.ErrorWebExceptionHandler;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.web.reactive.function.client.WebClientException;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.util.annotation.NonNull;

public class GlobalExceptionHandler
extends Controller
implements ErrorWebExceptionHandler {
    @NonNull
    public Mono<Void> handle(ServerWebExchange exchange, Throwable ex) {
        BusinessException e;
        ServerHttpResponse response = exchange.getResponse();
        response.setStatusCode((HttpStatusCode)HttpStatus.OK);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        Context context = Context.get(exchange);
        Map<String, String> map = context.getRequestMap();
        String method = null;
        if (null != map) {
            method = map.get("method");
        }
        Logger.error("traceId:{},request: {},error:{}", exchange.getLogPrefix(), method, ex.getMessage());
        Logger.error(ex);
        Object message = ex instanceof WebClientException ? Controller.write(ErrorCode.EM_FAILURE) : (ex instanceof BusinessException ? (StringKit.isNotBlank((e = (BusinessException)ex).getErrcode()) ? Controller.write(e.getErrcode()) : Controller.write(ErrorCode.EM_100513, e.getMessage())) : Controller.write(ErrorCode.EM_100513));
        Provider provider = context.getFormat().getProvider();
        String formatBody = null != provider ? provider.serialize(message) : Context.Format.json.getProvider().serialize(message);
        DataBuffer db = response.bufferFactory().wrap(formatBody.getBytes());
        return response.writeWith((Publisher)Mono.just((Object)db)).doOnTerminate(() -> Logger.info("traceId:{},exec time :{}ms", exchange.getLogPrefix(), System.currentTimeMillis() - context.getStartTime()));
    }
}

