/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.builtin;

import java.io.Serializable;
import org.aoju.bus.core.toolkit.FileKit;
import org.aoju.bus.health.Builder;

public class JvmRuntime
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Runtime currentRuntime = Runtime.getRuntime();

    public final Runtime getRuntime() {
        return this.currentRuntime;
    }

    public final long getMaxMemory() {
        return this.currentRuntime.maxMemory();
    }

    public final long getTotalMemory() {
        return this.currentRuntime.totalMemory();
    }

    public final long getFreeMemory() {
        return this.currentRuntime.freeMemory();
    }

    public final long getUsableMemory() {
        return this.currentRuntime.maxMemory() - this.currentRuntime.totalMemory() + this.currentRuntime.freeMemory();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        Builder.append(builder, "Max Memory:    ", FileKit.readableFileSize(this.getMaxMemory()));
        Builder.append(builder, "Total Memory:     ", FileKit.readableFileSize(this.getTotalMemory()));
        Builder.append(builder, "Free Memory:     ", FileKit.readableFileSize(this.getFreeMemory()));
        Builder.append(builder, "Usable Memory:     ", FileKit.readableFileSize(this.getUsableMemory()));
        return builder.toString();
    }
}

