/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.drivers;

import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Dmidecode {
    public static String querySerialNumber() {
        String marker = "Serial Number:";
        for (String checkLine : Executor.runNative("dmidecode -t system")) {
            if (!checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return null;
    }

    public static String queryUUID() {
        String marker = "UUID:";
        for (String checkLine : Executor.runNative("dmidecode -t system")) {
            if (!checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        return null;
    }

    public static Pair<String, String> queryBiosNameRev() {
        String biosName = null;
        String revision = null;
        String biosMarker = "SMBIOS";
        String revMarker = "Bios Revision:";
        for (String checkLine : Executor.runNative("dmidecode -t bios")) {
            String[] biosArr;
            if (checkLine.contains("SMBIOS") && (biosArr = RegEx.SPACES.split(checkLine)).length >= 2) {
                biosName = biosArr[0] + " " + biosArr[1];
            }
            if (!checkLine.contains("Bios Revision:")) continue;
            revision = checkLine.split("Bios Revision:")[1].trim();
            break;
        }
        return Pair.of(biosName, revision);
    }
}

