/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.drivers.proc;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.linux.ProcPath;

@ThreadSafe
public final class CpuStat {
    public static long[] getSystemCpuLoadTicks() {
        long[] ticks = new long[CentralProcessor.TickType.values().length];
        List<String> procStat = Builder.readFile(ProcPath.STAT);
        if (procStat.isEmpty()) {
            return ticks;
        }
        String tickStr = procStat.get(0);
        String[] tickArr = RegEx.SPACES.split(tickStr);
        if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
            return ticks;
        }
        for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
            ticks[i] = Builder.parseLongOrDefault(tickArr[i + 1], 0L);
        }
        return ticks;
    }

    public static long[][] getProcessorCpuLoadTicks(int logicalProcessorCount) {
        long[][] ticks = new long[logicalProcessorCount][CentralProcessor.TickType.values().length];
        int cpu = 0;
        List<String> procStat = Builder.readFile(ProcPath.STAT);
        for (String stat : procStat) {
            if (!stat.startsWith("cpu") || stat.startsWith("cpu ")) continue;
            String[] tickArr = RegEx.SPACES.split(stat);
            if (tickArr.length <= CentralProcessor.TickType.IDLE.getIndex()) {
                return ticks;
            }
            for (int i = 0; i < CentralProcessor.TickType.values().length; ++i) {
                ticks[cpu][i] = Builder.parseLongOrDefault(tickArr[i + 1], 0L);
            }
            if (++cpu < logicalProcessorCount) continue;
            break;
        }
        return ticks;
    }

    public static long getContextSwitches() {
        List<String> procStat = Builder.readFile(ProcPath.STAT);
        for (String stat : procStat) {
            String[] ctxtArr;
            if (!stat.startsWith("ctxt ") || (ctxtArr = RegEx.SPACES.split(stat)).length != 2) continue;
            return Builder.parseLongOrDefault(ctxtArr[1], 0L);
        }
        return 0L;
    }

    public static long getInterrupts() {
        List<String> procStat = Builder.readFile(ProcPath.STAT);
        for (String stat : procStat) {
            String[] intrArr;
            if (!stat.startsWith("intr ") || (intrArr = RegEx.SPACES.split(stat)).length <= 2) continue;
            return Builder.parseLongOrDefault(intrArr[1], 0L);
        }
        return 0L;
    }

    public static long getBootTime() {
        List<String> procStat = Builder.readFile(ProcPath.STAT);
        for (String stat : procStat) {
            if (!stat.startsWith("btime")) continue;
            String[] bTime = RegEx.SPACES.split(stat);
            return Builder.parseLongOrDefault(bTime[1], 0L);
        }
        return 0L;
    }
}

