/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.linux.hardware;

import com.sun.jna.platform.linux.Udev;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.RegEx;
import org.aoju.bus.core.lang.tuple.Quartet;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractCentralProcessor;
import org.aoju.bus.health.builtin.hardware.CentralProcessor;
import org.aoju.bus.health.linux.LinuxLibc;
import org.aoju.bus.health.linux.ProcPath;
import org.aoju.bus.health.linux.drivers.Lshw;
import org.aoju.bus.health.linux.drivers.proc.CpuStat;
import org.aoju.bus.health.linux.software.LinuxOperatingSystem;
import org.aoju.bus.logger.Logger;

@ThreadSafe
final class LinuxCentralProcessor
extends AbstractCentralProcessor {
    LinuxCentralProcessor() {
    }

    private static String getProcessorID(String vendor, String stepping, String model, String family, String[] flags) {
        boolean procInfo = false;
        String marker = "Processor Information";
        for (String checkLine : Executor.runNative("dmidecode -t 4")) {
            if (!procInfo && checkLine.contains(marker)) {
                marker = "ID:";
                procInfo = true;
                continue;
            }
            if (!procInfo || !checkLine.contains(marker)) continue;
            return checkLine.split(marker)[1].trim();
        }
        marker = "eax=";
        for (String checkLine : Executor.runNative("cpuid -1r")) {
            if (!checkLine.contains(marker) || !checkLine.trim().startsWith("0x00000001")) continue;
            String eax = "";
            String edx = "";
            for (String register : RegEx.SPACES.split(checkLine)) {
                if (register.startsWith("eax=")) {
                    eax = Builder.removeMatchingString(register, "eax=0x");
                    continue;
                }
                if (!register.startsWith("edx=")) continue;
                edx = Builder.removeMatchingString(register, "edx=0x");
            }
            return edx + eax;
        }
        if (vendor.startsWith("0x")) {
            return LinuxCentralProcessor.createMIDR(vendor, stepping, model, family) + "00000000";
        }
        return LinuxCentralProcessor.createProcessorID(stepping, model, family, flags);
    }

    private static String createMIDR(String vendor, String stepping, String model, String family) {
        int midrBytes = 0;
        if (stepping.startsWith("r") && stepping.contains("p")) {
            String[] rev = stepping.substring(1).split("p");
            midrBytes |= Builder.parseLastInt(rev[1], 0);
            midrBytes |= Builder.parseLastInt(rev[0], 0) << 20;
        }
        midrBytes |= Builder.parseLastInt(model, 0) << 4;
        midrBytes |= Builder.parseLastInt(family, 0) << 16;
        return String.format("%08X", midrBytes |= Builder.parseLastInt(vendor, 0) << 24);
    }

    @Override
    protected CentralProcessor.ProcessorIdentifier queryProcessorId() {
        String cpuVendor = "";
        String cpuName = "";
        String cpuFamily = "";
        String cpuModel = "";
        String cpuStepping = "";
        long cpuFreq = 0L;
        boolean cpu64bit = false;
        StringBuilder armStepping = new StringBuilder();
        String[] flags = new String[]{};
        List<String> cpuInfo = Builder.readFile(ProcPath.CPUINFO);
        block25: for (String line : cpuInfo) {
            String[] splitLine = Builder.whitespacesColonWhitespace.split(line);
            if (splitLine.length < 2) {
                if (!line.startsWith("CPU architecture: ")) continue;
                cpuFamily = line.replace("CPU architecture: ", "").trim();
                continue;
            }
            block14 : switch (splitLine[0]) {
                case "vendor_id": 
                case "CPU implementer": {
                    cpuVendor = splitLine[1];
                    break;
                }
                case "model name": 
                case "Processor": {
                    if (splitLine[1].indexOf(32) <= 0) break;
                    cpuName = splitLine[1];
                    break;
                }
                case "flags": {
                    for (String flag : flags = splitLine[1].toLowerCase().split(" ")) {
                        if (!"lm".equals(flag)) continue;
                        cpu64bit = true;
                        break block14;
                    }
                    continue block25;
                }
                case "stepping": {
                    cpuStepping = splitLine[1];
                    break;
                }
                case "CPU variant": {
                    if (armStepping.toString().startsWith("r")) break;
                    int rev = Builder.parseLastInt(splitLine[1], 0);
                    armStepping.insert(0, "r" + rev);
                    break;
                }
                case "CPU revision": {
                    if (armStepping.toString().contains("p")) break;
                    armStepping.append('p').append(splitLine[1]);
                    break;
                }
                case "model": 
                case "CPU part": {
                    cpuModel = splitLine[1];
                    break;
                }
                case "cpu family": {
                    cpuFamily = splitLine[1];
                    break;
                }
                case "cpu MHz": {
                    cpuFreq = Builder.parseHertz(splitLine[1]);
                    break;
                }
            }
        }
        if (cpuName.isEmpty()) {
            cpuName = Builder.getStringFromFile(ProcPath.MODEL);
        }
        if (cpuName.contains("Hz")) {
            cpuFreq = -1L;
        } else {
            long cpuCapacity = Lshw.queryCpuCapacity();
            if (cpuCapacity > cpuFreq) {
                cpuFreq = cpuCapacity;
            }
        }
        if (cpuStepping.isEmpty()) {
            cpuStepping = armStepping.toString();
        }
        String processorID = LinuxCentralProcessor.getProcessorID(cpuVendor, cpuStepping, cpuModel, cpuFamily, flags);
        if (cpuVendor.startsWith("0x")) {
            List<String> lscpu = Executor.runNative("lscpu");
            for (String line : lscpu) {
                if (!line.startsWith("Architecture:")) continue;
                cpuVendor = line.replace("Architecture:", "").trim();
            }
        }
        return new CentralProcessor.ProcessorIdentifier(cpuVendor, cpuName, cpuFamily, cpuModel, cpuStepping, processorID, cpu64bit, cpuFreq);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromUdev() {
        ArrayList<CentralProcessor.LogicalProcessor> logProcs = new ArrayList<CentralProcessor.LogicalProcessor>();
        HashSet<CentralProcessor.ProcessorCache> caches = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap<Integer, Integer> coreEfficiencyMap = new HashMap<Integer, Integer>();
        HashMap<Integer, String> modAliasMap = new HashMap<Integer, String>();
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate enumerate = udev.enumerateNew();
            try {
                enumerate.addMatchSubsystem("cpu");
                enumerate.scanDevices();
                for (Udev.UdevListEntry entry = enumerate.getListEntry(); entry != null; entry = entry.getNext()) {
                    String syspath = entry.getName();
                    Udev.UdevDevice device = udev.deviceNewFromSyspath(syspath);
                    String modAlias = null;
                    if (device != null) {
                        try {
                            modAlias = device.getPropertyValue("MODALIAS");
                        }
                        finally {
                            device.unref();
                        }
                    }
                    logProcs.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(syspath, caches, modAlias, coreEfficiencyMap, modAliasMap));
                }
            }
            finally {
                enumerate.unref();
            }
        }
        finally {
            udev.unref();
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(logProcs, LinuxCentralProcessor.orderedProcCaches(caches), coreEfficiencyMap, modAliasMap);
    }

    private static Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> readTopologyFromSysfs() {
        ArrayList logProcs = new ArrayList();
        HashSet<CentralProcessor.ProcessorCache> caches = new HashSet<CentralProcessor.ProcessorCache>();
        HashMap coreEfficiencyMap = new HashMap();
        HashMap modAliasMap = new HashMap();
        String cpuPath = "/sys/devices/system/cpu/";
        try (Stream<Path> cpuFiles = Files.find(Paths.get(cpuPath, new String[0]), Integer.MAX_VALUE, (path, basicFileAttributes) -> path.toFile().getName().matches("cpu\\d+"), new FileVisitOption[0]);){
            cpuFiles.forEach(cpu -> {
                String syspath = cpu.toString();
                Map<String, String> uevent = Builder.getKeyValueMapFromFile(syspath + "/uevent", "=");
                String modAlias = uevent.get("MODALIAS");
                logProcs.add(LinuxCentralProcessor.getLogicalProcessorFromSyspath(syspath, caches, modAlias, coreEfficiencyMap, modAliasMap));
            });
        }
        catch (IOException e) {
            Logger.warn("Unable to find CPU information in sysfs at path {}", cpuPath);
        }
        return new Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>>(logProcs, LinuxCentralProcessor.orderedProcCaches(caches), coreEfficiencyMap, modAliasMap);
    }

    private static CentralProcessor.LogicalProcessor getLogicalProcessorFromSyspath(String syspath, Set<CentralProcessor.ProcessorCache> caches, String modAlias, Map<Integer, Integer> coreEfficiencyMap, Map<Integer, String> modAliasMap) {
        int processor = Builder.getFirstIntValue(syspath);
        int coreId = Builder.getIntFromFile(syspath + "/topology/core_id");
        int pkgId = Builder.getIntFromFile(syspath + "/topology/physical_package_id");
        int pkgCoreKey = (pkgId << 16) + coreId;
        coreEfficiencyMap.put(pkgCoreKey, Builder.getIntFromFile(syspath + "/cpu_capacity"));
        if (!StringKit.isBlank(modAlias)) {
            modAliasMap.put(pkgCoreKey, modAlias);
        }
        int nodeId = 0;
        String nodePrefix = syspath + "/node";
        try (Stream<Path> path2 = Files.list(Paths.get(syspath, new String[0]));){
            Optional<Path> first = path2.filter(p -> p.toString().startsWith(nodePrefix)).findFirst();
            if (first.isPresent()) {
                nodeId = Builder.getFirstIntValue(first.get().getFileName().toString());
            }
        }
        catch (IOException path2) {
            // empty catch block
        }
        String cachePath = syspath + "/cache";
        String indexPrefix = cachePath + "/index";
        try (Stream<Path> path = Files.list(Paths.get(cachePath, new String[0]));){
            path.filter(p -> p.toString().startsWith(indexPrefix)).forEach(c -> {
                int level = Builder.getIntFromFile(String.valueOf(c) + "/level");
                CentralProcessor.ProcessorCache.Type type = LinuxCentralProcessor.parseCacheType(Builder.getStringFromFile(String.valueOf(c) + "/type"));
                int associativity = Builder.getIntFromFile(String.valueOf(c) + "/ways_of_associativity");
                int lineSize = Builder.getIntFromFile(String.valueOf(c) + "/coherency_line_size");
                long size = Builder.parseDecimalMemorySizeToBinary(Builder.getStringFromFile(String.valueOf(c) + "/size"));
                caches.add(new CentralProcessor.ProcessorCache(level, associativity, lineSize, size, type));
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new CentralProcessor.LogicalProcessor(processor, coreId, pkgId, nodeId);
    }

    private static CentralProcessor.ProcessorCache.Type parseCacheType(String type) {
        try {
            return CentralProcessor.ProcessorCache.Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return CentralProcessor.ProcessorCache.Type.UNIFIED;
        }
    }

    @Override
    protected Triple<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.PhysicalProcessor>, List<CentralProcessor.ProcessorCache>> initProcessorCounts() {
        Quartet<List<CentralProcessor.LogicalProcessor>, List<CentralProcessor.ProcessorCache>, Map<Integer, Integer>, Map<Integer, String>> topology = LinuxOperatingSystem.HAS_UDEV ? LinuxCentralProcessor.readTopologyFromUdev() : LinuxCentralProcessor.readTopologyFromSysfs();
        List<CentralProcessor.LogicalProcessor> logProcs = topology.getA();
        List<CentralProcessor.ProcessorCache> caches = topology.getB();
        Map<Integer, Integer> coreEfficiencyMap = topology.getC();
        Map<Integer, String> modAliasMap = topology.getD();
        if (logProcs.isEmpty()) {
            logProcs.add(new CentralProcessor.LogicalProcessor(0, 0, 0));
            coreEfficiencyMap.put(0, 0);
        }
        logProcs.sort(Comparator.comparingInt(CentralProcessor.LogicalProcessor::getProcessorNumber));
        List physProcs = coreEfficiencyMap.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(e -> {
            int pkgId = (Integer)e.getKey() >> 16;
            int coreId = (Integer)e.getKey() & 0xFFFF;
            return new CentralProcessor.PhysicalProcessor(pkgId, coreId, (Integer)e.getValue(), modAliasMap.getOrDefault(e.getKey(), ""));
        }).collect(Collectors.toList());
        return Triple.of(logProcs, physProcs, caches);
    }

    @Override
    public long[] querySystemCpuLoadTicks() {
        long[] ticks = CpuStat.getSystemCpuLoadTicks();
        if (LongStream.of(ticks).sum() == 0L) {
            ticks = CpuStat.getSystemCpuLoadTicks();
        }
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            ticks[i] = ticks[i] * 1000L / hz;
        }
        return ticks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] queryCurrentFreq() {
        long[] freqs = new long[this.getLogicalProcessorCount()];
        long max = 0L;
        Udev.UdevContext udev = Udev.INSTANCE.udev_new();
        try {
            Udev.UdevEnumerate enumerate = udev.enumerateNew();
            try {
                enumerate.addMatchSubsystem("cpu");
                enumerate.scanDevices();
                for (Udev.UdevListEntry entry = enumerate.getListEntry(); entry != null; entry = entry.getNext()) {
                    String syspath = entry.getName();
                    int cpu = Builder.getFirstIntValue(syspath);
                    if (cpu >= 0 && cpu < freqs.length) {
                        freqs[cpu] = Builder.getLongFromFile(syspath + "/cpufreq/scaling_cur_freq");
                        if (freqs[cpu] == 0L) {
                            freqs[cpu] = Builder.getLongFromFile(syspath + "/cpufreq/cpuinfo_cur_freq");
                        }
                    }
                    if (max >= freqs[cpu]) continue;
                    max = freqs[cpu];
                }
                if (max > 0L) {
                    int i22 = 0;
                    while (i22 < freqs.length) {
                        int n = i22++;
                        freqs[n] = freqs[n] * 1000L;
                    }
                    long[] i22 = freqs;
                    return i22;
                }
            }
            finally {
                enumerate.unref();
            }
        }
        finally {
            udev.unref();
        }
        Arrays.fill(freqs, -1L);
        List<String> cpuInfo = Builder.readFile(ProcPath.CPUINFO);
        int proc = 0;
        for (String s : cpuInfo) {
            if (!s.toLowerCase().contains("cpu mhz")) continue;
            freqs[proc] = Math.round(Builder.parseLastDouble(s, 0.0) * 1000000.0);
            if (++proc < freqs.length) continue;
            break;
        }
        return freqs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long queryMaxFreq() {
        long max;
        block17: {
            max = Arrays.stream(this.getCurrentFreq()).max().orElse(-1L);
            if (max > 0L) {
                max /= 1000L;
            }
            Udev.UdevContext udev = Udev.INSTANCE.udev_new();
            try {
                Udev.UdevEnumerate enumerate = udev.enumerateNew();
                try {
                    enumerate.addMatchSubsystem("cpu");
                    enumerate.scanDevices();
                    Udev.UdevListEntry entry = enumerate.getListEntry();
                    if (entry == null) break block17;
                    String syspath = entry.getName();
                    String cpuFreqPath = syspath.substring(0, syspath.lastIndexOf(File.separatorChar)) + "/cpuFreq";
                    String policyPrefix = cpuFreqPath + "/policy";
                    try (Stream<Path> path = Files.list(Paths.get(cpuFreqPath, new String[0]));){
                        Optional<Long> maxPolicy = path.filter(p -> p.toString().startsWith(policyPrefix)).map(p -> {
                            long freq = Builder.getLongFromFile(String.valueOf(p) + "/scaling_max_freq");
                            if (freq == 0L) {
                                freq = Builder.getLongFromFile(String.valueOf(p) + "/cpuinfo_max_freq");
                            }
                            return freq;
                        }).max(Long::compare);
                        if (maxPolicy.isPresent() && max < maxPolicy.get()) {
                            max = maxPolicy.get();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                finally {
                    enumerate.unref();
                }
            }
            finally {
                udev.unref();
            }
        }
        if (max == 0L) {
            return -1L;
        }
        long lshwMax = Lshw.queryCpuCapacity();
        return lshwMax > (max *= 1000L) ? lshwMax : max;
    }

    @Override
    public double[] getSystemLoadAverage(int nelem) {
        if (nelem < 1 || nelem > 3) {
            throw new IllegalArgumentException("Must include from one to three elements.");
        }
        double[] average = new double[nelem];
        int retval = LinuxLibc.INSTANCE.getloadavg(average, nelem);
        if (retval < nelem) {
            for (int i = Math.max(retval, 0); i < average.length; ++i) {
                average[i] = -1.0;
            }
        }
        return average;
    }

    @Override
    public long[][] queryProcessorCpuLoadTicks() {
        long[][] ticks = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        if (LongStream.of(ticks[0]).sum() == 0L) {
            ticks = CpuStat.getProcessorCpuLoadTicks(this.getLogicalProcessorCount());
        }
        long hz = LinuxOperatingSystem.getHz();
        for (int i = 0; i < ticks.length; ++i) {
            for (int j = 0; j < ticks[i].length; ++j) {
                ticks[i][j] = ticks[i][j] * 1000L / hz;
            }
        }
        return ticks;
    }

    @Override
    public long queryContextSwitches() {
        return CpuStat.getContextSwitches();
    }

    @Override
    public long queryInterrupts() {
        return CpuStat.getInterrupts();
    }
}

