/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix;

import com.sun.jna.Native;
import java.nio.ByteBuffer;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.unix.CLibrary;

public interface AixLibc
extends CLibrary {
    public static final AixLibc INSTANCE = (AixLibc)Native.load((String)"c", AixLibc.class);
    public static final int PRCLSZ = 8;
    public static final int PRFNSZ = 16;
    public static final int PRARGSZ = 80;

    public int thread_self();

    public static class Timestruc {
        public long tv_sec;
        public int tv_nsec;
        public int pad;

        public Timestruc(ByteBuffer buff) {
            this.tv_sec = Builder.readLongFromBuffer(buff);
            this.tv_nsec = Builder.readIntFromBuffer(buff);
            this.pad = Builder.readIntFromBuffer(buff);
        }
    }

    public static class AixLwpsInfo {
        public long pr_lwpid;
        public long pr_addr;
        public long pr_wchan;
        public int pr_flag;
        public byte pr_wtype;
        public byte pr_state;
        public byte pr_sname;
        public byte pr_nice;
        public int pr_pri;
        public int pr_policy;
        public byte[] pr_clname = new byte[8];
        public int pr_onpro;
        public int pr_bindpro;

        public AixLwpsInfo(ByteBuffer buff) {
            this.pr_lwpid = Builder.readLongFromBuffer(buff);
            this.pr_addr = Builder.readLongFromBuffer(buff);
            this.pr_wchan = Builder.readLongFromBuffer(buff);
            this.pr_flag = Builder.readIntFromBuffer(buff);
            this.pr_wtype = Builder.readByteFromBuffer(buff);
            this.pr_state = Builder.readByteFromBuffer(buff);
            this.pr_sname = Builder.readByteFromBuffer(buff);
            this.pr_nice = Builder.readByteFromBuffer(buff);
            this.pr_pri = Builder.readIntFromBuffer(buff);
            this.pr_policy = Builder.readIntFromBuffer(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_clname);
            this.pr_onpro = Builder.readIntFromBuffer(buff);
            this.pr_bindpro = Builder.readIntFromBuffer(buff);
        }
    }

    public static class AixPsInfo {
        public int pr_flag;
        public int pr_flag2;
        public int pr_nlwp;
        public int pr__pad1;
        public long pr_uid;
        public long pr_euid;
        public long pr_gid;
        public long pr_egid;
        public long pr_pid;
        public long pr_ppid;
        public long pr_pgid;
        public long pr_sid;
        public long pr_ttydev;
        public long pr_addr;
        public long pr_size;
        public long pr_rssize;
        public Timestruc pr_start;
        public Timestruc pr_time;
        public short pr_cid;
        public short pr__pad2;
        public int pr_argc;
        public long pr_argv;
        public long pr_envp;
        public byte[] pr_fname = new byte[16];
        public byte[] pr_psargs = new byte[80];
        public long[] pr__pad = new long[8];
        public AixLwpsInfo pr_lwp;

        public AixPsInfo(ByteBuffer buff) {
            this.pr_flag = Builder.readIntFromBuffer(buff);
            this.pr_flag2 = Builder.readIntFromBuffer(buff);
            this.pr_nlwp = Builder.readIntFromBuffer(buff);
            this.pr__pad1 = Builder.readIntFromBuffer(buff);
            this.pr_uid = Builder.readLongFromBuffer(buff);
            this.pr_euid = Builder.readLongFromBuffer(buff);
            this.pr_gid = Builder.readLongFromBuffer(buff);
            this.pr_egid = Builder.readLongFromBuffer(buff);
            this.pr_pid = Builder.readLongFromBuffer(buff);
            this.pr_ppid = Builder.readLongFromBuffer(buff);
            this.pr_pgid = Builder.readLongFromBuffer(buff);
            this.pr_sid = Builder.readLongFromBuffer(buff);
            this.pr_ttydev = Builder.readLongFromBuffer(buff);
            this.pr_addr = Builder.readLongFromBuffer(buff);
            this.pr_size = Builder.readLongFromBuffer(buff);
            this.pr_rssize = Builder.readLongFromBuffer(buff);
            this.pr_start = new Timestruc(buff);
            this.pr_time = new Timestruc(buff);
            this.pr_cid = Builder.readShortFromBuffer(buff);
            this.pr__pad2 = Builder.readShortFromBuffer(buff);
            this.pr_argc = Builder.readIntFromBuffer(buff);
            this.pr_argv = Builder.readLongFromBuffer(buff);
            this.pr_envp = Builder.readLongFromBuffer(buff);
            Builder.readByteArrayFromBuffer(buff, this.pr_fname);
            Builder.readByteArrayFromBuffer(buff, this.pr_psargs);
            for (int i = 0; i < this.pr__pad.length; ++i) {
                this.pr__pad[i] = Builder.readLongFromBuffer(buff);
            }
            this.pr_lwp = new AixLwpsInfo(buff);
        }
    }
}

