/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.aix.drivers;

import java.util.List;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;

@ThreadSafe
public final class Lscfg {
    public static List<String> queryAllDevices() {
        return Executor.runNative("lscfg -vp");
    }

    public static Triple<String, String, String> queryBackplaneModelSerialVersion(List<String> lscfg) {
        String planeMarker = "WAY BACKPLANE";
        String modelMarker = "Part Number";
        String serialMarker = "Serial Number";
        String versionMarker = "Version";
        String locationMarker = "Physical Location";
        String model = null;
        String serialNumber = null;
        String version = null;
        boolean planeFlag = false;
        for (String checkLine : lscfg) {
            if (!planeFlag && checkLine.contains("WAY BACKPLANE")) {
                planeFlag = true;
                continue;
            }
            if (!planeFlag) continue;
            if (checkLine.contains("Part Number")) {
                model = Builder.removeLeadingDots(checkLine.split("Part Number")[1].trim());
                continue;
            }
            if (checkLine.contains("Serial Number")) {
                serialNumber = Builder.removeLeadingDots(checkLine.split("Serial Number")[1].trim());
                continue;
            }
            if (checkLine.contains("Version")) {
                version = Builder.removeLeadingDots(checkLine.split("Version")[1].trim());
                continue;
            }
            if (!checkLine.contains("Physical Location")) continue;
            break;
        }
        return Triple.of(model, serialNumber, version);
    }

    public static Pair<String, String> queryModelSerial(String device) {
        String modelMarker = "Machine Type and Model";
        String serialMarker = "Serial Number";
        String model = null;
        String serial = null;
        for (String s : Executor.runNative("lscfg -vl " + device)) {
            String locDesc;
            int idx;
            if (model == null && s.contains(device) && (idx = (locDesc = s.split(device)[1].trim()).indexOf(32)) > 0) {
                model = locDesc.substring(idx).trim();
            }
            if (s.contains(modelMarker)) {
                model = Builder.removeLeadingDots(s.split(modelMarker)[1].trim());
                continue;
            }
            if (!s.contains(serialMarker)) continue;
            serial = Builder.removeLeadingDots(s.split(serialMarker)[1].trim());
        }
        return Pair.of(model, serial);
    }
}

