/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.freebsd.hardware;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.builtin.hardware.AbstractSoundCard;
import org.aoju.bus.health.builtin.hardware.SoundCard;

@Immutable
final class FreeBsdSoundCard
extends AbstractSoundCard {
    private static final String LSHAL = "lshal";

    FreeBsdSoundCard(String kernelVersion, String name, String codec) {
        super(kernelVersion, name, codec);
    }

    public static List<SoundCard> getSoundCards() {
        HashMap<String, String> vendorMap = new HashMap<String, String>();
        HashMap<String, String> productMap = new HashMap<String, String>();
        vendorMap.clear();
        productMap.clear();
        ArrayList<String> sounds = new ArrayList<String>();
        String key = "";
        for (String line : Executor.runNative(LSHAL)) {
            if ((line = line.trim()).startsWith("udi =")) {
                key = Builder.getSingleQuoteStringValue(line);
                continue;
            }
            if (key.isEmpty() || line.isEmpty()) continue;
            if (line.contains("freebsd.driver =") && "pcm".equals(Builder.getSingleQuoteStringValue(line))) {
                sounds.add(key);
                continue;
            }
            if (line.contains("info.product")) {
                productMap.put(key, Builder.getStringBetween(line, '\''));
                continue;
            }
            if (!line.contains("info.vendor")) continue;
            vendorMap.put(key, Builder.getStringBetween(line, '\''));
        }
        ArrayList<SoundCard> soundCards = new ArrayList<SoundCard>();
        for (String s : sounds) {
            soundCards.add(new FreeBsdSoundCard((String)productMap.get(s), (String)vendorMap.get(s) + " " + (String)productMap.get(s), (String)productMap.get(s)));
        }
        return soundCards;
    }
}

