/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.openbsd.hardware;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import java.util.function.Supplier;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractGlobalMemory;
import org.aoju.bus.health.builtin.hardware.VirtualMemory;
import org.aoju.bus.health.unix.OpenBsdLibc;
import org.aoju.bus.health.unix.openbsd.OpenBsdSysctlKit;
import org.aoju.bus.health.unix.openbsd.hardware.OpenBsdVirtualMemory;

@ThreadSafe
final class OpenBsdGlobalMemory
extends AbstractGlobalMemory {
    private final Supplier<Long> available = Memoize.memoize(OpenBsdGlobalMemory::queryAvailable, Memoize.defaultExpiration());
    private final Supplier<Long> total = Memoize.memoize(OpenBsdGlobalMemory::queryPhysMem);
    private final Supplier<Long> pageSize = Memoize.memoize(OpenBsdGlobalMemory::queryPageSize);
    private final Supplier<VirtualMemory> vm = Memoize.memoize(this::createVirtualMemory);

    OpenBsdGlobalMemory() {
    }

    private static long queryAvailable() {
        long free = 0L;
        long inactive = 0L;
        for (String line : Executor.runNative("vmstat -s")) {
            if (line.endsWith("pages free")) {
                free = Builder.getFirstIntValue(line);
                continue;
            }
            if (!line.endsWith("pages inactive")) continue;
            inactive = Builder.getFirstIntValue(line);
        }
        int[] mib = new int[]{10, 0, 3};
        try (Memory m = OpenBsdSysctlKit.sysctl(mib);){
            OpenBsdLibc.Bcachestats cache = new OpenBsdLibc.Bcachestats((Pointer)m);
            long l = cache.numbufpages + free + inactive;
            return l;
        }
    }

    private static long queryPhysMem() {
        return OpenBsdSysctlKit.sysctl("hw.physmem", 0L);
    }

    private static long queryPageSize() {
        return OpenBsdSysctlKit.sysctl("hw.pagesize", 4096L);
    }

    @Override
    public long getAvailable() {
        return this.available.get() * this.getPageSize();
    }

    @Override
    public long getTotal() {
        return this.total.get();
    }

    @Override
    public long getPageSize() {
        return this.pageSize.get();
    }

    @Override
    public VirtualMemory getVirtualMemory() {
        return this.vm.get();
    }

    private VirtualMemory createVirtualMemory() {
        return new OpenBsdVirtualMemory(this);
    }
}

