/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.unix.solaris.hardware;

import java.util.function.Supplier;
import org.aoju.bus.core.annotation.Immutable;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Executor;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.hardware.AbstractComputerSystem;
import org.aoju.bus.health.builtin.hardware.Baseboard;
import org.aoju.bus.health.builtin.hardware.Firmware;
import org.aoju.bus.health.unix.UnixBaseboard;
import org.aoju.bus.health.unix.solaris.hardware.SolarisFirmware;

@Immutable
final class SolarisComputerSystem
extends AbstractComputerSystem {
    private final Supplier<SmbiosStrings> smbiosStrings = Memoize.memoize(SolarisComputerSystem::readSmbios);

    SolarisComputerSystem() {
    }

    private static SmbiosStrings readSmbios() {
        String biosVendor = null;
        String biosVersion = null;
        String biosDate = null;
        String manufacturer = null;
        String model = null;
        String serialNumber = null;
        String uuid = null;
        String boardManufacturer = null;
        String boardModel = null;
        String boardVersion = null;
        String boardSerialNumber = null;
        String vendorMarker = "Vendor:";
        String biosDateMarker = "Release Date:";
        String biosVersionMarker = "VersionString:";
        String manufacturerMarker = "Manufacturer:";
        String productMarker = "Product:";
        String serialNumMarker = "Serial Number:";
        String uuidMarker = "UUID:";
        String versionMarker = "Version:";
        int smbTypeId = -1;
        for (String checkLine : Executor.runNative("smbios")) {
            if (checkLine.contains("SMB_TYPE_") && (smbTypeId = SolarisComputerSystem.getSmbType(checkLine)) == Integer.MAX_VALUE) break;
            switch (smbTypeId) {
                case 0: {
                    if (checkLine.contains("Vendor:")) {
                        biosVendor = checkLine.split("Vendor:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("VersionString:")) {
                        biosVersion = checkLine.split("VersionString:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Release Date:")) break;
                    biosDate = checkLine.split("Release Date:")[1].trim();
                    break;
                }
                case 1: {
                    if (checkLine.contains("Manufacturer:")) {
                        manufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        model = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Serial Number:")) {
                        serialNumber = checkLine.split("Serial Number:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("UUID:")) break;
                    uuid = checkLine.split("UUID:")[1].trim();
                    break;
                }
                case 2: {
                    if (checkLine.contains("Manufacturer:")) {
                        boardManufacturer = checkLine.split("Manufacturer:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Product:")) {
                        boardModel = checkLine.split("Product:")[1].trim();
                        break;
                    }
                    if (checkLine.contains("Version:")) {
                        boardVersion = checkLine.split("Version:")[1].trim();
                        break;
                    }
                    if (!checkLine.contains("Serial Number:")) break;
                    boardSerialNumber = checkLine.split("Serial Number:")[1].trim();
                    break;
                }
            }
        }
        if (StringKit.isBlank(serialNumber)) {
            serialNumber = SolarisComputerSystem.readSerialNumber();
        }
        return new SmbiosStrings(biosVendor, biosVersion, biosDate, manufacturer, model, serialNumber, uuid, boardManufacturer, boardModel, boardVersion, boardSerialNumber);
    }

    private static int getSmbType(String checkLine) {
        if (checkLine.contains("SMB_TYPE_BIOS")) {
            return 0;
        }
        if (checkLine.contains("SMB_TYPE_SYSTEM")) {
            return 1;
        }
        if (checkLine.contains("SMB_TYPE_BASEBOARD")) {
            return 2;
        }
        return Integer.MAX_VALUE;
    }

    private static String readSerialNumber() {
        String serialNumber = Executor.getFirstAnswer("sneep");
        if (serialNumber.isEmpty()) {
            String marker = "chassis-sn:";
            for (String checkLine : Executor.runNative("prtconf -pv")) {
                if (!checkLine.contains(marker)) continue;
                serialNumber = Builder.getSingleQuoteStringValue(checkLine);
                break;
            }
        }
        return serialNumber;
    }

    @Override
    public String getManufacturer() {
        return this.smbiosStrings.get().manufacturer;
    }

    @Override
    public String getModel() {
        return this.smbiosStrings.get().model;
    }

    @Override
    public String getSerialNumber() {
        return this.smbiosStrings.get().serialNumber;
    }

    @Override
    public String getHardwareUUID() {
        return this.smbiosStrings.get().uuid;
    }

    @Override
    public Firmware createFirmware() {
        return new SolarisFirmware(this.smbiosStrings.get().biosVendor, this.smbiosStrings.get().biosVersion, this.smbiosStrings.get().biosDate);
    }

    @Override
    public Baseboard createBaseboard() {
        return new UnixBaseboard(this.smbiosStrings.get().boardManufacturer, this.smbiosStrings.get().boardModel, this.smbiosStrings.get().boardSerialNumber, this.smbiosStrings.get().boardVersion);
    }

    private static final class SmbiosStrings {
        private final String biosVendor;
        private final String biosVersion;
        private final String biosDate;
        private final String manufacturer;
        private final String model;
        private final String serialNumber;
        private final String uuid;
        private final String boardManufacturer;
        private final String boardModel;
        private final String boardVersion;
        private final String boardSerialNumber;

        private SmbiosStrings(String biosVendor, String biosVersion, String biosDate, String manufacturer, String model, String serialNumber, String uuid, String boardManufacturer, String boardModel, String boardVersion, String boardSerialNumber) {
            this.biosVendor = StringKit.isBlank(biosVendor) ? "unknown" : biosVendor;
            this.biosVersion = StringKit.isBlank(biosVersion) ? "unknown" : biosVersion;
            this.biosDate = StringKit.isBlank(biosDate) ? "unknown" : biosDate;
            this.manufacturer = StringKit.isBlank(manufacturer) ? "unknown" : manufacturer;
            this.model = StringKit.isBlank(model) ? "unknown" : model;
            this.serialNumber = StringKit.isBlank(serialNumber) ? "unknown" : serialNumber;
            this.uuid = StringKit.isBlank(uuid) ? "unknown" : uuid;
            this.boardManufacturer = StringKit.isBlank(boardManufacturer) ? "unknown" : boardManufacturer;
            this.boardModel = StringKit.isBlank(boardModel) ? "unknown" : boardModel;
            this.boardVersion = StringKit.isBlank(boardVersion) ? "unknown" : boardVersion;
            this.boardSerialNumber = StringKit.isBlank(boardSerialNumber) ? "unknown" : boardSerialNumber;
        }
    }
}

