/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.health.windows.software;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Advapi32;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.COM.WbemcliUtil;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Kernel32Util;
import com.sun.jna.platform.win32.Shell32Util;
import com.sun.jna.platform.win32.VersionHelpers;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aoju.bus.core.annotation.ThreadSafe;
import org.aoju.bus.core.lang.tuple.Pair;
import org.aoju.bus.core.lang.tuple.Triple;
import org.aoju.bus.health.Builder;
import org.aoju.bus.health.Config;
import org.aoju.bus.health.Memoize;
import org.aoju.bus.health.builtin.ByRef;
import org.aoju.bus.health.builtin.software.AbstractOSProcess;
import org.aoju.bus.health.builtin.software.OSProcess;
import org.aoju.bus.health.builtin.software.OSThread;
import org.aoju.bus.health.windows.NtDll;
import org.aoju.bus.health.windows.WmiKit;
import org.aoju.bus.health.windows.drivers.registry.ProcessPerformanceData;
import org.aoju.bus.health.windows.drivers.registry.ProcessWtsData;
import org.aoju.bus.health.windows.drivers.registry.ThreadPerformanceData;
import org.aoju.bus.health.windows.drivers.wmi.Win32Process;
import org.aoju.bus.health.windows.drivers.wmi.Win32ProcessCached;
import org.aoju.bus.health.windows.software.WindowsFileSystem;
import org.aoju.bus.health.windows.software.WindowsOSThread;
import org.aoju.bus.health.windows.software.WindowsOperatingSystem;
import org.aoju.bus.logger.Logger;

@ThreadSafe
public class WindowsOSProcess
extends AbstractOSProcess {
    private static final boolean USE_BATCH_COMMANDLINE = Config.get("bus.health.os.windows.commandline.batch", false);
    private static final boolean USE_PROCSTATE_SUSPENDED = Config.get("bus.health.os.windows.procstate.suspended", false);
    private static final boolean IS_VISTA_OR_GREATER = VersionHelpers.IsWindowsVistaOrGreater();
    private static final boolean IS_WINDOWS7_OR_GREATER = VersionHelpers.IsWindows7OrGreater();
    private final WindowsOperatingSystem os;
    private final Supplier<Pair<String, String>> groupInfo = Memoize.memoize(this::queryGroupInfo);
    private final Supplier<Triple<String, String, Map<String, String>>> cwdCmdEnv = Memoize.memoize(this::queryCwdCommandlineEnvironment);
    private final Supplier<String> currentWorkingDirectory = Memoize.memoize(this::queryCwd);
    private String name;
    private final Supplier<Pair<String, String>> userInfo = Memoize.memoize(this::queryUserInfo);
    private String path;
    private int parentProcessID;
    private int threadCount;
    private int priority;
    private long virtualSize;
    private long residentSetSize;
    private long kernelTime;
    private long userTime;
    private long startTime;
    private final Supplier<String> commandLine = Memoize.memoize(this::queryCommandLine);
    private final Supplier<List<String>> args = Memoize.memoize(this::queryArguments);
    private OSProcess.State state = OSProcess.State.INVALID;
    private long upTime;
    private long bytesRead;
    private long bytesWritten;
    private long openFiles;
    private int bitness;
    private long pageFaults;

    public WindowsOSProcess(int pid, WindowsOperatingSystem os, Map<Integer, ProcessPerformanceData.PerfCounterBlock> processMap, Map<Integer, ProcessWtsData.WtsInfo> processWtsMap, Map<Integer, ThreadPerformanceData.PerfCounterBlock> threadMap) {
        super(pid);
        this.os = os;
        this.bitness = os.getBitness();
        this.updateAttributes(processMap.get(pid), processWtsMap.get(pid), threadMap);
    }

    private static Triple<String, String, Map<String, String>> defaultCwdCommandlineEnvironment() {
        return Triple.of("", "", Collections.emptyMap());
    }

    private static String readUnicodeString(WinNT.HANDLE h, NtDll.UNICODE_STRING s) {
        IntByReference nRead = new IntByReference();
        if (s.Length > 0) {
            try (Memory m = new Memory((long)s.Length + 2L);){
                m.clear();
                Kernel32.INSTANCE.ReadProcessMemory(h, s.Buffer, (Pointer)m, (int)s.Length, nRead);
                if (nRead.getValue() > 0) {
                    String string = m.getWideString(0L);
                    return string;
                }
            }
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getCommandLine() {
        return this.commandLine.get();
    }

    @Override
    public List<String> getArguments() {
        return this.args.get();
    }

    @Override
    public Map<String, String> getEnvironmentVariables() {
        return this.cwdCmdEnv.get().getRight();
    }

    @Override
    public String getCurrentWorkingDirectory() {
        return this.currentWorkingDirectory.get();
    }

    @Override
    public String getUser() {
        return this.userInfo.get().getLeft();
    }

    @Override
    public String getUserID() {
        return this.userInfo.get().getRight();
    }

    @Override
    public String getGroup() {
        return this.groupInfo.get().getLeft();
    }

    @Override
    public String getGroupID() {
        return this.groupInfo.get().getRight();
    }

    @Override
    public OSProcess.State getState() {
        return this.state;
    }

    @Override
    public int getParentProcessID() {
        return this.parentProcessID;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public long getVirtualSize() {
        return this.virtualSize;
    }

    @Override
    public long getResidentSetSize() {
        return this.residentSetSize;
    }

    @Override
    public long getKernelTime() {
        return this.kernelTime;
    }

    @Override
    public long getUserTime() {
        return this.userTime;
    }

    @Override
    public long getUpTime() {
        return this.upTime;
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public long getBytesRead() {
        return this.bytesRead;
    }

    @Override
    public long getBytesWritten() {
        return this.bytesWritten;
    }

    @Override
    public long getOpenFiles() {
        return this.openFiles;
    }

    @Override
    public long getSoftOpenFileLimit() {
        return WindowsFileSystem.MAX_WINDOWS_HANDLES;
    }

    @Override
    public long getHardOpenFileLimit() {
        return WindowsFileSystem.MAX_WINDOWS_HANDLES;
    }

    @Override
    public int getBitness() {
        return this.bitness;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getAffinityMask() {
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            try (ByRef.CloseableULONGptrByReference processAffinity = new ByRef.CloseableULONGptrByReference();
                 ByRef.CloseableULONGptrByReference systemAffinity = new ByRef.CloseableULONGptrByReference();){
                if (Kernel32.INSTANCE.GetProcessAffinityMask(pHandle, (BaseTSD.ULONG_PTRByReference)processAffinity, (BaseTSD.ULONG_PTRByReference)systemAffinity)) {
                    long l = Pointer.nativeValue((Pointer)processAffinity.getValue().toPointer());
                    return l;
                }
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
        }
        return 0L;
    }

    @Override
    public long getMinorFaults() {
        return this.pageFaults;
    }

    @Override
    public List<OSThread> getThreadDetails() {
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> threads = ThreadPerformanceData.buildThreadMapFromRegistry(Collections.singleton(this.getProcessID()));
        if (threads != null) {
            threads = ThreadPerformanceData.buildThreadMapFromPerfCounters(Collections.singleton(this.getProcessID()));
        }
        if (threads == null) {
            return Collections.emptyList();
        }
        return ((Stream)threads.entrySet().stream().parallel()).map(entry -> new WindowsOSThread(this.getProcessID(), (Integer)entry.getKey(), this.name, (ThreadPerformanceData.PerfCounterBlock)entry.getValue())).collect(Collectors.toList());
    }

    @Override
    public boolean updateAttributes() {
        Set<Integer> pids = Collections.singleton(this.getProcessID());
        Map<Integer, ProcessPerformanceData.PerfCounterBlock> pcb = ProcessPerformanceData.buildProcessMapFromRegistry(null);
        if (pcb == null) {
            pcb = ProcessPerformanceData.buildProcessMapFromPerfCounters(pids);
        }
        Map<Integer, ThreadPerformanceData.PerfCounterBlock> tcb = null;
        if (USE_PROCSTATE_SUSPENDED && (tcb = ThreadPerformanceData.buildThreadMapFromRegistry(null)) == null) {
            tcb = ThreadPerformanceData.buildThreadMapFromPerfCounters(null);
        }
        Map<Integer, ProcessWtsData.WtsInfo> wts = ProcessWtsData.queryProcessWtsMap(pids);
        return this.updateAttributes(pcb.get(this.getProcessID()), wts.get(this.getProcessID()), tcb);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateAttributes(ProcessPerformanceData.PerfCounterBlock pcb, ProcessWtsData.WtsInfo wts, Map<Integer, ThreadPerformanceData.PerfCounterBlock> threadMap) {
        WinNT.HANDLE pHandle;
        this.name = pcb.getName();
        this.path = wts.getPath();
        this.parentProcessID = pcb.getParentProcessID();
        this.threadCount = wts.getThreadCount();
        this.priority = pcb.getPriority();
        this.virtualSize = wts.getVirtualSize();
        this.residentSetSize = pcb.getResidentSetSize();
        this.kernelTime = wts.getKernelTime();
        this.userTime = wts.getUserTime();
        this.startTime = pcb.getStartTime();
        this.upTime = pcb.getUpTime();
        this.bytesRead = pcb.getBytesRead();
        this.bytesWritten = pcb.getBytesWritten();
        this.openFiles = wts.getOpenFiles();
        this.pageFaults = pcb.getPageFaults();
        this.state = OSProcess.State.RUNNING;
        if (threadMap != null) {
            int pid = this.getProcessID();
            for (ThreadPerformanceData.PerfCounterBlock tcb : threadMap.values()) {
                if (tcb.getOwningProcessID() != pid) continue;
                if (tcb.getThreadWaitReason() == 5) {
                    this.state = OSProcess.State.SUSPENDED;
                    continue;
                }
                this.state = OSProcess.State.RUNNING;
                break;
            }
        }
        if ((pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID())) != null) {
            try {
                if (IS_VISTA_OR_GREATER && this.bitness == 64) {
                    try (ByRef.CloseableIntByReference wow64 = new ByRef.CloseableIntByReference();){
                        if (Kernel32.INSTANCE.IsWow64Process(pHandle, (IntByReference)wow64) && wow64.getValue() > 0) {
                            this.bitness = 32;
                        }
                    }
                }
                WinNT.HANDLEByReference phToken = new WinNT.HANDLEByReference();
                try {
                    if (IS_WINDOWS7_OR_GREATER) {
                        this.path = Kernel32Util.QueryFullProcessImageName((WinNT.HANDLE)pHandle, (int)0);
                    }
                }
                catch (Win32Exception e) {
                    this.state = OSProcess.State.INVALID;
                }
                finally {
                    WinNT.HANDLE token = phToken.getValue();
                    if (token != null) {
                        Kernel32.INSTANCE.CloseHandle(token);
                    }
                }
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
        }
        return !this.state.equals((Object)OSProcess.State.INVALID);
    }

    private String queryCommandLine() {
        if (!this.cwdCmdEnv.get().getRight().isEmpty()) {
            return this.cwdCmdEnv.get().getMiddle();
        }
        if (USE_BATCH_COMMANDLINE) {
            return Win32ProcessCached.getInstance().getCommandLine(this.getProcessID(), this.getStartTime());
        }
        WbemcliUtil.WmiResult<Win32Process.CommandLineProperty> commandLineProcs = Win32Process.queryCommandLines(Collections.singleton(this.getProcessID()));
        if (commandLineProcs.getResultCount() > 0) {
            return WmiKit.getString(commandLineProcs, Win32Process.CommandLineProperty.COMMANDLINE, 0);
        }
        return "";
    }

    private List<String> queryArguments() {
        String cl = this.getCommandLine();
        if (!cl.isEmpty()) {
            return Arrays.asList(Shell32Util.CommandLineToArgv((String)cl));
        }
        return Collections.emptyList();
    }

    private String queryCwd() {
        String cwd;
        if (!this.cwdCmdEnv.get().getLeft().isEmpty()) {
            return this.cwdCmdEnv.get().getLeft();
        }
        if (this.getProcessID() == this.os.getProcessId() && !(cwd = new File(".").getAbsolutePath()).isEmpty()) {
            return cwd.substring(0, cwd.length() - 1);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<String, String> queryUserInfo() {
        Pair<String, String> pair = null;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            try (ByRef.CloseableHANDLEByReference phToken = new ByRef.CloseableHANDLEByReference();){
                try {
                    if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, (WinNT.HANDLEByReference)phToken)) {
                        Advapi32Util.Account account = Advapi32Util.getTokenAccount((WinNT.HANDLE)phToken.getValue());
                        pair = Pair.of(account.name, account.sidString);
                    } else {
                        int error = Kernel32.INSTANCE.GetLastError();
                        if (error != 5) {
                            Logger.error("Failed to get process token for process {}: {}", this.getProcessID(), Kernel32.INSTANCE.GetLastError());
                        }
                    }
                }
                catch (Win32Exception e) {
                    Logger.warn("Failed to query user info for process {} ({}): {}", this.getProcessID(), this.getName(), e.getMessage());
                }
                finally {
                    WinNT.HANDLE token = phToken.getValue();
                    if (token != null) {
                        Kernel32.INSTANCE.CloseHandle(token);
                    }
                    Kernel32.INSTANCE.CloseHandle(pHandle);
                }
            }
        }
        if (pair == null) {
            return Pair.of("unknown", "unknown");
        }
        return pair;
    }

    private Pair<String, String> queryGroupInfo() {
        Pair<String, String> pair = null;
        WinNT.HANDLE pHandle = Kernel32.INSTANCE.OpenProcess(1024, false, this.getProcessID());
        if (pHandle != null) {
            try (ByRef.CloseableHANDLEByReference phToken = new ByRef.CloseableHANDLEByReference();){
                if (Advapi32.INSTANCE.OpenProcessToken(pHandle, 10, (WinNT.HANDLEByReference)phToken)) {
                    Advapi32Util.Account account = Advapi32Util.getTokenPrimaryGroup((WinNT.HANDLE)phToken.getValue());
                    pair = Pair.of(account.name, account.sidString);
                } else {
                    int error = Kernel32.INSTANCE.GetLastError();
                    if (error != 5) {
                        Logger.error("Failed to get process token for process {}: {}", this.getProcessID(), Kernel32.INSTANCE.GetLastError());
                    }
                }
                WinNT.HANDLE token = phToken.getValue();
                if (token != null) {
                    Kernel32.INSTANCE.CloseHandle(token);
                }
                Kernel32.INSTANCE.CloseHandle(pHandle);
            }
        }
        if (pair == null) {
            return Pair.of("unknown", "unknown");
        }
        return pair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Triple<String, String, Map<String, String>> queryCwdCommandlineEnvironment() {
        block20: {
            h = Kernel32.INSTANCE.OpenProcess(1040, false, this.getProcessID());
            if (h == null) break block20;
            try {
                block25: {
                    block24: {
                        block23: {
                            block22: {
                                block21: {
                                    if (WindowsOperatingSystem.isX86() != WindowsOperatingSystem.isWow(h)) break block20;
                                    nRead = new ByRef.CloseableIntByReference();
                                    try {
                                        pbi = new NtDll.PROCESS_BASIC_INFORMATION();
                                        ret = NtDll.INSTANCE.NtQueryInformationProcess(h, 0, pbi.getPointer(), pbi.size(), nRead);
                                        if (ret == 0) break block21;
                                        var5_7 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                                        nRead.close();
                                        return var5_7;
                                    }
                                    catch (Throwable var3_4) {
                                        try {
                                            nRead.close();
                                        }
                                        catch (Throwable var4_6) {
                                            var3_4.addSuppressed(var4_6);
                                        }
                                        throw var3_4;
                                    }
                                }
                                pbi.read();
                                peb = new NtDll.PEB();
                                Kernel32.INSTANCE.ReadProcessMemory(h, pbi.PebBaseAddress, peb.getPointer(), peb.size(), (IntByReference)nRead);
                                if (nRead.getValue() != 0) break block22;
                                var6_9 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                                nRead.close();
                                return var6_9;
                            }
                            peb.read();
                            upp = new NtDll.RTL_USER_PROCESS_PARAMETERS();
                            Kernel32.INSTANCE.ReadProcessMemory(h, peb.ProcessParameters, upp.getPointer(), upp.size(), (IntByReference)nRead);
                            if (nRead.getValue() != 0) break block23;
                            var7_11 = WindowsOSProcess.defaultCwdCommandlineEnvironment();
                            nRead.close();
                            return var7_11;
                        }
                        upp.read();
                        cwd = WindowsOSProcess.readUnicodeString(h, upp.CurrentDirectory.DosPath);
                        cl = WindowsOSProcess.readUnicodeString(h, upp.CommandLine);
                        envSize = upp.EnvironmentSize.intValue();
                        if (envSize <= 0) ** GOTO lbl74
                        buffer = new Memory((long)envSize);
                        Kernel32.INSTANCE.ReadProcessMemory(h, upp.Environment, (Pointer)buffer, envSize, (IntByReference)nRead);
                        if (nRead.getValue() <= 0) break block24;
                        env = buffer.getCharArray(0L, envSize / 2);
                        envMap = Builder.parseCharArrayToStringMap(env);
                        envMap.remove("");
                        var13_20 = Triple.of(cwd, cl, Collections.unmodifiableMap(envMap));
                        buffer.close();
                        nRead.close();
                        return var13_20;
                    }
                    buffer.close();
                    break block25;
                    {
                        catch (Throwable var11_17) {
                            try {
                                buffer.close();
                            }
                            catch (Throwable var12_19) {
                                var11_17.addSuppressed(var12_19);
                            }
                            throw var11_17;
                        }
                    }
                }
                var10_15 = Triple.of(cwd, cl, Collections.emptyMap());
                nRead.close();
                return var10_15;
            }
            finally {
                Kernel32.INSTANCE.CloseHandle(h);
            }
        }
        return WindowsOSProcess.defaultCwdCommandlineEnvironment();
    }
}

