/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.http.metric.http;

import java.io.IOException;
import java.util.List;
import org.aoju.bus.core.Version;
import org.aoju.bus.core.io.source.GzipSource;
import org.aoju.bus.core.lang.MediaType;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.http.Builder;
import org.aoju.bus.http.Cookie;
import org.aoju.bus.http.Headers;
import org.aoju.bus.http.Request;
import org.aoju.bus.http.Response;
import org.aoju.bus.http.bodys.RealResponseBody;
import org.aoju.bus.http.bodys.RequestBody;
import org.aoju.bus.http.metric.CookieJar;
import org.aoju.bus.http.metric.Interceptor;

public class BridgeInterceptor
implements Interceptor {
    private final CookieJar cookieJar;

    public BridgeInterceptor(CookieJar cookieJar) {
        this.cookieJar = cookieJar;
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        List<Cookie> cookies;
        Request request = chain.request();
        Request.Builder requestBuilder = request.newBuilder();
        RequestBody body = request.body();
        if (null != body) {
            long length;
            MediaType mediaType = body.mediaType();
            if (null != mediaType) {
                requestBuilder.header("Content-Type", mediaType.toString());
            }
            if ((length = body.length()) != -1L) {
                requestBuilder.header("Content-Length", Long.toString(length));
                requestBuilder.removeHeader("Transfer-Encoding");
            } else {
                requestBuilder.header("Transfer-Encoding", "chunked");
                requestBuilder.removeHeader("Content-Length");
            }
        }
        if (null == request.header("Host")) {
            requestBuilder.header("Host", Builder.hostHeader(request.url(), false));
        }
        if (null == request.header("Connection")) {
            requestBuilder.header("Connection", "Keep-Alive");
        }
        boolean transparentGzip = false;
        if (null == request.header("Accept-Encoding") && null == request.header("Range")) {
            transparentGzip = true;
            requestBuilder.header("Accept-Encoding", "gzip");
        }
        if (!(cookies = this.cookieJar.loadForRequest(request.url())).isEmpty()) {
            requestBuilder.header("Cookie", this.cookieHeader(cookies));
        }
        if (null == request.header("User-Agent")) {
            requestBuilder.header("User-Agent", "Httpd/" + Version.all());
        }
        Response networkResponse = chain.proceed(requestBuilder.build());
        Headers.receiveHeaders(this.cookieJar, request.url(), networkResponse.headers());
        Response.Builder responseBuilder = networkResponse.newBuilder().request(request);
        if (transparentGzip && "gzip".equalsIgnoreCase(networkResponse.header("Content-Encoding")) && Headers.hasBody(networkResponse)) {
            GzipSource responseBody = new GzipSource(networkResponse.body().source());
            Headers strippedHeaders = networkResponse.headers().newBuilder().removeAll("Content-Encoding").removeAll("Content-Length").build();
            responseBuilder.headers(strippedHeaders);
            String mediaType = networkResponse.header("Content-Type");
            responseBuilder.body(new RealResponseBody(mediaType, -1L, IoKit.buffer(responseBody)));
        }
        return responseBuilder.build();
    }

    private String cookieHeader(List<Cookie> cookies) {
        StringBuilder cookieHeader = new StringBuilder();
        int size = cookies.size();
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                cookieHeader.append("; ");
            }
            Cookie cookie = cookies.get(i);
            cookieHeader.append(cookie.name()).append('=').append(cookie.value());
        }
        return cookieHeader.toString();
    }
}

