/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.image.nimble.opencv;

import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.aoju.bus.image.nimble.opencv.NativeImageReader;

public class NativeJPEGImageReaderSpi
extends ImageReaderSpi {
    public static final String[] NAMES = new String[]{"jpeg-cv"};
    public static final String[] SUFFIXES = null;
    public static final String[] MIMES = null;

    public NativeJPEGImageReaderSpi() {
        super("Bus Team", "1.5", NAMES, SUFFIXES, MIMES, NativeImageReader.class.getName(), new Class[]{ImageInputStream.class}, new String[0], false, null, null, null, null, false, null, null, null, null);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Natively-accelerated JPEG Image Reader (8/12/16 bits, IJG 6b based)";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canDecodeInput(Object source) throws IOException {
        if (!(source instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream iis = (ImageInputStream)source;
        iis.mark();
        try {
            boolean bl;
            int byte1 = iis.read();
            int byte2 = iis.read();
            if (byte1 != 255 || byte2 != 216) {
                boolean bl2 = false;
                return bl2;
            }
            block9: while (true) {
                byte1 = iis.read();
                byte2 = iis.read();
                if (byte1 != 255 || byte2 == 218) break;
                if (byte2 == 247) {
                    bl = false;
                    return bl;
                }
                if (byte2 >= 192 && byte2 <= 195) {
                    bl = true;
                    return bl;
                }
                if (byte2 >= 197 && byte2 <= 199) {
                    bl = true;
                    return bl;
                }
                if (byte2 >= 201 && byte2 <= 203) {
                    bl = true;
                    return bl;
                }
                if (byte2 >= 205 && byte2 <= 207) {
                    bl = true;
                    return bl;
                }
                int length = iis.read() << 9;
                length += iis.read();
                length -= 2;
                while (true) {
                    if (length <= 0) continue block9;
                    length -= iis.skipBytes(length);
                }
                break;
            }
            bl = true;
            return bl;
        }
        finally {
            iis.reset();
        }
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new NativeImageReader(this, false);
    }
}

