/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.mapper.provider;

import org.aoju.bus.mapper.builder.MapperBuilder;
import org.aoju.bus.mapper.builder.MapperTemplate;
import org.aoju.bus.mapper.builder.SqlBuilder;
import org.aoju.bus.mapper.reflect.MetaObject;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;

public class ConditionProvider
extends MapperTemplate {
    public ConditionProvider(Class<?> mapperClass, MapperBuilder mapperBuilder) {
        super(mapperClass, mapperBuilder);
    }

    public String selectCountByCondition(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.isCheckConditionEntityClass()) {
            sql.append(SqlBuilder.conditionCheck(entityClass));
        }
        sql.append(SqlBuilder.conditionCountColumn(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.conditionWhereClause());
        sql.append(SqlBuilder.conditionForUpdate());
        return sql.toString();
    }

    public String deleteByCondition(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (this.isCheckConditionEntityClass()) {
            sql.append(SqlBuilder.conditionCheck(entityClass));
        }
        if (this.getConfig().isSafeDelete()) {
            sql.append(SqlBuilder.conditionHasAtLeastOneCriteriaCheck("_parameter"));
        }
        if (SqlBuilder.hasLogicDeleteColumn(entityClass)) {
            sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass)));
            sql.append("<set>");
            sql.append(SqlBuilder.logicDeleteColumnEqualsValue(entityClass, true));
            sql.append("</set>");
            MetaObject.forObject(ms).setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
        } else {
            sql.append(SqlBuilder.deleteFromTable(entityClass, this.tableName(entityClass)));
        }
        sql.append(SqlBuilder.conditionWhereClause());
        return sql.toString();
    }

    public String selectByCondition(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        this.setResultType(ms, entityClass);
        StringBuilder sql = new StringBuilder("SELECT ");
        if (this.isCheckConditionEntityClass()) {
            sql.append(SqlBuilder.conditionCheck(entityClass));
        }
        sql.append("<if test=\"distinct\">distinct</if>");
        sql.append(SqlBuilder.conditionSelectColumns(entityClass));
        sql.append(SqlBuilder.fromTable(entityClass, this.tableName(entityClass)));
        sql.append(SqlBuilder.conditionWhereClause());
        sql.append(SqlBuilder.conditionOrderBy(entityClass));
        sql.append(SqlBuilder.conditionForUpdate());
        return sql.toString();
    }

    public String selectByConditionAndRowBounds(MappedStatement ms) {
        return this.selectByCondition(ms);
    }

    public String updateByConditionSelective(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (this.isCheckConditionEntityClass()) {
            sql.append(SqlBuilder.conditionCheck(entityClass));
        }
        if (this.getConfig().isSafeUpdate()) {
            sql.append(SqlBuilder.conditionHasAtLeastOneCriteriaCheck("condition"));
        }
        sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass), "condition"));
        sql.append(SqlBuilder.updateSetColumnsIgnoreVersion(entityClass, "record", true, this.isNotEmpty()));
        sql.append(SqlBuilder.updateByConditionWhereClause());
        return sql.toString();
    }

    public String updateByCondition(MappedStatement ms) {
        Class<?> entityClass = this.getEntityClass(ms);
        StringBuilder sql = new StringBuilder();
        if (this.isCheckConditionEntityClass()) {
            sql.append(SqlBuilder.conditionCheck(entityClass));
        }
        if (this.getConfig().isSafeUpdate()) {
            sql.append(SqlBuilder.conditionHasAtLeastOneCriteriaCheck("condition"));
        }
        sql.append(SqlBuilder.updateTable(entityClass, this.tableName(entityClass), "condition"));
        sql.append(SqlBuilder.updateSetColumnsIgnoreVersion(entityClass, "record", false, false));
        sql.append(SqlBuilder.updateByConditionWhereClause());
        return sql.toString();
    }

    public String selectOneByCondition(MappedStatement ms) {
        return this.selectByCondition(ms);
    }
}

