/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.notify.provider.tencent;

import java.util.HashMap;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.magic.Message;
import org.aoju.bus.notify.provider.AbstractProvider;
import org.aoju.bus.notify.provider.tencent.TencentProperty;

public class TencentSmsProvider
extends AbstractProvider<TencentProperty, Context> {
    public TencentSmsProvider(Context properties) {
        super(properties);
    }

    @Override
    public Message send(TencentProperty entity) {
        HashMap<String, Object> bodys = new HashMap<String, Object>();
        bodys.put("SmsSdkAppid", entity.getSmsAppId());
        bodys.put("Sign", entity.getSignature());
        bodys.put("TemplateID", entity.getTemplate());
        bodys.put("TemplateParamSet", StringKit.splitToArray((CharSequence)entity.getParams(), ","));
        bodys.put("PhoneNumberSet", StringKit.splitToArray((CharSequence)entity.getReceive(), ","));
        String response = Httpx.post(entity.getUrl(), bodys);
        int status = (Integer)JsonKit.getValue(response, "status");
        String errcode = status == 200 ? Builder.ErrorCode.SUCCESS.getCode() : Builder.ErrorCode.FAILURE.getCode();
        String errmsg = status == 200 ? Builder.ErrorCode.SUCCESS.getMsg() : Builder.ErrorCode.FAILURE.getMsg();
        return Message.builder().errcode(errcode).errmsg(errmsg).build();
    }
}

