/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class AliyunProvider
extends AbstractProvider {
    public AliyunProvider(Context context) {
        super(context, Registry.ALIYUN);
    }

    public AliyunProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.ALIYUN, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        String response = this.doPostAuthorizationCode(callback.getCode());
        JSONObject accessTokenObject = JSONObject.parseObject((String)response);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).expireIn(accessTokenObject.getIntValue("expires_in")).tokenType(accessTokenObject.getString("token_type")).idToken(accessTokenObject.getString("id_token")).refreshToken(accessTokenObject.getString("refresh_token")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        String userInfo = this.doGetUserInfo(accToken);
        JSONObject object = JSONObject.parseObject((String)userInfo);
        return Property.builder().rawJson(object).uuid(object.getString("sub")).username(object.getString("login_name")).nickname(object.getString("name")).gender(Normal.Gender.UNKNOWN).token(accToken).source(this.source.toString()).build();
    }
}

