/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONObject;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class FacebookProvider
extends AbstractProvider {
    public FacebookProvider(Context context) {
        super(context, Registry.FACEBOOK);
    }

    public FacebookProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.FACEBOOK, extendCache);
    }

    @Override
    public AccToken getAccessToken(Callback callback) {
        JSONObject object = JSONObject.parseObject((String)this.doPostAuthorizationCode(callback.getCode()));
        this.checkResponse(object);
        return AccToken.builder().accessToken(object.getString("access_token")).expireIn(object.getIntValue("expires_in")).tokenType(object.getString("token_type")).build();
    }

    @Override
    public Property getUserInfo(AccToken accToken) {
        JSONObject object = JSONObject.parseObject((String)this.doGetUserInfo(accToken));
        this.checkResponse(object);
        return Property.builder().rawJson(object).uuid(object.getString("id")).username(object.getString("name")).nickname(object.getString("name")).avatar(this.getUserPicture(object)).location(object.getString("locale")).email(object.getString("email")).gender(Normal.Gender.of(object.getString("gender"))).token(accToken).source(this.source.toString()).build();
    }

    private String getUserPicture(JSONObject object) {
        String picture = null;
        if (object.containsKey((Object)"picture")) {
            JSONObject pictureObj = object.getJSONObject("picture");
            if (null != (pictureObj = pictureObj.getJSONObject("data"))) {
                picture = pictureObj.getString("url");
            }
        }
        return picture;
    }

    @Override
    public String userInfoUrl(AccToken accToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("access_token", accToken.getAccessToken()).queryParam("fields", "id,name,birthday,gender,hometown,email,devices,picture.width(400)").build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(super.authorize(state)).queryParam("scope", this.getScopes(",", false, FacebookProvider.getScopes(true, OauthScope.Facebook.values()))).build();
    }

    private void checkResponse(JSONObject object) {
        if (object.containsKey((Object)"error")) {
            throw new AuthorizedException(object.getJSONObject("error").getString("message"));
        }
    }
}

