/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.oauth.provider;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.AuthorizedException;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.http.Httpx;
import org.aoju.bus.oauth.Builder;
import org.aoju.bus.oauth.Context;
import org.aoju.bus.oauth.Registry;
import org.aoju.bus.oauth.magic.AccToken;
import org.aoju.bus.oauth.magic.Callback;
import org.aoju.bus.oauth.magic.Message;
import org.aoju.bus.oauth.magic.Property;
import org.aoju.bus.oauth.metric.OauthScope;
import org.aoju.bus.oauth.provider.AbstractProvider;

public class SlackProvider
extends AbstractProvider {
    public SlackProvider(Context context) {
        super(context, Registry.SLACK);
    }

    public SlackProvider(Context context, ExtendCache extendCache) {
        super(context, Registry.SLACK, extendCache);
    }

    @Override
    protected AccToken getAccessToken(Callback callback) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        JSONObject accessTokenObject = JSONObject.parseObject((String)Httpx.post(this.accessTokenUrl(callback.getCode()), null, header));
        this.checkResponse(accessTokenObject);
        return AccToken.builder().accessToken(accessTokenObject.getString("access_token")).scope(accessTokenObject.getString("scope")).tokenType(accessTokenObject.getString("token_type")).uid(accessTokenObject.getJSONObject("authed_user").getString("id")).build();
    }

    @Override
    protected Property getUserInfo(AccToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        JSONObject object = JSONObject.parseObject((String)Httpx.post(this.userInfoUrl(authToken), null, header));
        this.checkResponse(object);
        JSONObject user = object.getJSONObject("user");
        JSONObject profile = user.getJSONObject("profile");
        return Property.builder().rawJson(user).uuid(user.getString("id")).username(user.getString("name")).nickname(user.getString("real_name")).avatar(profile.getString("image_original")).email(profile.getString("email")).gender(Normal.Gender.UNKNOWN).token(authToken).source(this.source.toString()).build();
    }

    @Override
    public Message revoke(AccToken authToken) {
        HashMap<String, String> header = new HashMap<String, String>();
        header.put("Content-Type", "application/x-www-form-urlencoded");
        header.put("Authorization", "Bearer ".concat(authToken.getAccessToken()));
        JSONObject object = JSONObject.parseObject((String)Httpx.post(this.source.revoke(), null, header));
        this.checkResponse(object);
        Builder.ErrorCode status = object.getBooleanValue("revoked") ? Builder.ErrorCode.SUCCESS : Builder.ErrorCode.FAILURE;
        return Message.builder().errcode(status.getCode()).errmsg(status.getMsg()).build();
    }

    private void checkResponse(JSONObject object) {
        if (!object.getBooleanValue("ok")) {
            JSONArray array;
            Object errorMsg = object.getString("error");
            if (object.containsKey((Object)"response_metadata") && null != (array = object.getJSONObject("response_metadata").getJSONArray("messages")) && array.size() > 0) {
                errorMsg = (String)errorMsg + "; " + String.join((CharSequence)",", (CharSequence[])array.toArray((Object[])new String[0]));
            }
            throw new AuthorizedException((String)errorMsg);
        }
    }

    @Override
    public String userInfoUrl(AccToken authToken) {
        return Builder.fromUrl(this.source.userInfo()).queryParam("user", authToken.getUid()).build();
    }

    @Override
    public String authorize(String state) {
        return Builder.fromUrl(this.source.authorize()).queryParam("client_id", this.context.getAppKey()).queryParam("state", this.getRealState(state)).queryParam("redirect_uri", this.context.getRedirectUri()).queryParam("scope", this.getScopes(",", true, SlackProvider.getScopes(true, OauthScope.Slack.values()))).build();
    }

    @Override
    protected String accessTokenUrl(String code) {
        return Builder.fromUrl(this.source.accessToken()).queryParam("code", code).queryParam("client_id", this.context.getAppKey()).queryParam("client_secret", this.context.getAppSecret()).queryParam("redirect_uri", this.context.getRedirectUri()).build();
    }
}

